/*
 * Decompiled with CFR 0.152.
 */
package swingx.dnd;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ObjectTransferable
implements Transferable {
    public static final DataFlavor serializedFlavor = new DataFlavor(Serializable.class, "Object");
    public static final DataFlavor localFlavor;
    private List flavors;
    private Object object;

    public ObjectTransferable(Object object) {
        this.object = object;
        this.flavors = this.createFlavors();
    }

    protected List createFlavors() {
        ArrayList<DataFlavor> flavors = new ArrayList<DataFlavor>();
        flavors.add(localFlavor);
        boolean serializable = true;
        if (this.object.getClass().isArray()) {
            Object[] array = (Object[])this.object;
            for (int n = 0; n < array.length; ++n) {
                serializable = serializable && array[n] instanceof Serializable;
            }
        } else {
            serializable = this.object instanceof Serializable;
        }
        if (serializable) {
            flavors.add(serializedFlavor);
        }
        return flavors;
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        if (localFlavor.equals(flavor)) {
            return this.object;
        }
        if (serializedFlavor.equals(flavor)) {
            return this.object;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    public DataFlavor[] getTransferDataFlavors() {
        return this.flavors.toArray(new DataFlavor[this.flavors.size()]);
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return this.flavors.contains(flavor);
    }

    public static Object getObject(Transferable transferable) throws UnsupportedFlavorException, IOException {
        if (transferable.isDataFlavorSupported(localFlavor)) {
            return transferable.getTransferData(localFlavor);
        }
        if (transferable.isDataFlavorSupported(serializedFlavor)) {
            return transferable.getTransferData(serializedFlavor);
        }
        throw new IOException();
    }

    public static Transferable getTigerTransferable(DropTargetDragEvent dtde) {
        try {
            return (Transferable)DropTargetDragEvent.class.getMethod("getTransferable", new Class[0]).invoke((Object)dtde, new Object[0]);
        }
        catch (Throwable t) {
            return null;
        }
    }

    static {
        try {
            localFlavor = new DataFlavor("application/x-java-jvm-local-objectref;class=java.lang.Object");
        }
        catch (ClassNotFoundException e) {
            throw new Error(e);
        }
    }
}

