/*
 * Decompiled with CFR 0.152.
 */
package genj.window;

import genj.util.Registry;
import genj.util.swing.Action2;
import genj.util.swing.TextAreaWidget;
import genj.util.swing.TextFieldWidget;
import genj.window.WindowBroadcastEvent;
import genj.window.WindowBroadcastListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public abstract class WindowManager {
    private static final Object WINDOW_MANAGER_KEY = WindowManager.class;
    private static WeakHashMap window2manager = new WeakHashMap();
    public static final int ERROR_MESSAGE = 0;
    public static final int INFORMATION_MESSAGE = 1;
    public static final int WARNING_MESSAGE = 2;
    public static final int QUESTION_MESSAGE = 3;
    public static final int PLAIN_MESSAGE = -1;
    protected Registry registry;
    private int temporaryKeyCounter = 0;
    private Map key2window = new HashMap();
    private List listeners = new ArrayList();
    private boolean muteBroadcasts = false;
    static final Logger LOG = Logger.getLogger("genj.window");

    protected WindowManager(Registry regiStry) {
        this.registry = regiStry;
    }

    public void addBroadcastListener(WindowBroadcastListener listener) {
        this.listeners.add(listener);
    }

    public void removeBroadcastListener(WindowBroadcastListener listener) {
        this.listeners.remove(listener);
    }

    public static void broadcast(WindowBroadcastEvent event) {
        WindowManager instance = WindowManager.getInstanceImpl(event.getSource());
        if (instance == null) {
            return;
        }
        instance.broadcastImpl(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcastImpl(WindowBroadcastEvent event) {
        if (this.muteBroadcasts) {
            return;
        }
        try {
            this.muteBroadcasts = true;
            HashSet<Component> visited = new HashSet<Component>();
            for (Component cursor = event.getSource(); cursor != null; cursor = cursor.getParent()) {
                if (!(cursor instanceof WindowBroadcastListener)) continue;
                visited.add(cursor);
                try {
                    if (((WindowBroadcastListener)((Object)cursor)).handleBroadcastEvent(event)) continue;
                    return;
                }
                catch (Throwable t) {
                    LOG.log(Level.WARNING, "broadcast listener threw throwable - cancelling broadcast", t);
                    return;
                }
            }
            event.setInbound();
            Iterator ls = this.listeners.iterator();
            while (ls.hasNext()) {
                WindowBroadcastListener l = (WindowBroadcastListener)ls.next();
                try {
                    l.handleBroadcastEvent(event);
                }
                catch (Throwable t) {
                    LOG.log(Level.WARNING, "broadcast listener threw throwable - continuing broadcast", t);
                }
            }
            String[] keys = this.recallKeys();
            for (int i = 0; i < keys.length; ++i) {
                WindowManager.broadcastImpl(event, this.recall(keys[i]), visited);
            }
        }
        finally {
            this.muteBroadcasts = false;
        }
    }

    private static void broadcastImpl(WindowBroadcastEvent event, Component component, Set dontRevisit) {
        if (dontRevisit.contains(component)) {
            return;
        }
        if (component instanceof WindowBroadcastListener) {
            try {
                if (!((WindowBroadcastListener)((Object)component)).handleBroadcastEvent(event)) {
                    return;
                }
            }
            catch (Throwable t) {
                LOG.log(Level.WARNING, "broadcast listener threw throwable - not recursing broadcast", t);
                return;
            }
        }
        if (component instanceof Container) {
            Component[] cs = ((Container)component).getComponents();
            for (int j = 0; j < cs.length; ++j) {
                WindowManager.broadcastImpl(event, cs[j], dontRevisit);
            }
        }
    }

    public abstract void close(String var1);

    public abstract List getRootComponents();

    public abstract JComponent getContent(String var1);

    public abstract boolean show(String var1);

    public static WindowManager getInstance(Component component) {
        WindowManager result = WindowManager.getInstanceImpl(component);
        if (result == null) {
            LOG.warning("Failed to find window manager for " + component);
        }
        return result;
    }

    private static WindowManager getInstanceImpl(Component component) {
        Component window = component;
        while (window.getParent() != null) {
            window = window.getParent();
        }
        return (WindowManager)window2manager.get(window);
    }

    public final String openWindow(String key, String title, ImageIcon image, JComponent content, JMenuBar menu, Action close) {
        if (key == null) {
            key = this.getTemporaryKey();
        }
        this.close(key);
        Rectangle bounds = this.registry.get(key, (Rectangle)null);
        boolean maximized = this.registry.get(key + ".maximized", false);
        Component window = this.openWindowImpl(key, title, image, content, menu, bounds, maximized, close);
        window2manager.put(window, this);
        this.key2window.put(key, window);
        return key;
    }

    protected abstract Component openWindowImpl(String var1, String var2, ImageIcon var3, JComponent var4, JMenuBar var5, Rectangle var6, boolean var7, Action var8);

    public final int openDialog(String key, String title, int messageType, String txt, Action[] actions, Component owner) {
        int maxLine = 40;
        int cols = 40;
        int rows = 1;
        StringTokenizer lines = new StringTokenizer(txt, "\n\r");
        while (lines.hasMoreTokens()) {
            String line = lines.nextToken();
            if (line.length() > maxLine) {
                cols = maxLine;
                rows += line.length() / maxLine;
                continue;
            }
            cols = Math.max(cols, line.length());
            ++rows;
        }
        rows = Math.min(10, rows);
        TextAreaWidget text = new TextAreaWidget("", rows, cols);
        text.setLineWrap(true);
        text.setWrapStyleWord(true);
        text.setText(txt);
        text.setEditable(false);
        text.setCaretPosition(0);
        text.setRequestFocusEnabled(false);
        JScrollPane content = new JScrollPane(text);
        return this.openDialog(key, title, messageType, content, actions, owner);
    }

    public final int openDialog(String key, String title, int messageType, JComponent[] content, Action[] actions, Component owner) {
        JPanel box = new JPanel();
        box.setLayout(new BoxLayout(box, 1));
        for (int i = 0; i < content.length; ++i) {
            if (content[i] == null) continue;
            box.add(content[i]);
            content[i].setAlignmentX(0.0f);
        }
        return this.openDialog(key, title, messageType, box, actions, owner);
    }

    public final String openDialog(String key, String title, int messageType, String txt, String value, Component owner) {
        TextFieldWidget tf = new TextFieldWidget(value, 24);
        JLabel lb = new JLabel(txt);
        int rc = this.openDialog(key, title, messageType, new JComponent[]{lb, tf}, Action2.okCancel(), owner);
        return rc == 0 ? tf.getText().trim() : null;
    }

    public final int openDialog(String key, String title, int messageType, JComponent content, Action[] actions, Component owner) {
        content.putClientProperty(WINDOW_MANAGER_KEY, this);
        if (actions == null) {
            actions = Action2.okOnly();
        }
        if (key == null) {
            key = this.getTemporaryKey();
        }
        this.close(key);
        Rectangle bounds = this.registry.get(key, (Rectangle)null);
        Object rc = this.openDialogImpl(key, title, messageType, content, actions, owner, bounds);
        for (int a = 0; a < actions.length; ++a) {
            if (rc != actions[a]) continue;
            return a;
        }
        return -1;
    }

    protected abstract Object openDialogImpl(String var1, String var2, int var3, JComponent var4, Action[] var5, Component var6, Rectangle var7);

    public final String openNonModalDialog(String key, String title, int messageType, JComponent content, Action[] actions, Component owner) {
        content.putClientProperty(WINDOW_MANAGER_KEY, this);
        if (actions == null) {
            actions = new Action[]{};
        }
        if (key == null) {
            key = this.getTemporaryKey();
        }
        this.close(key);
        Rectangle bounds = this.registry.get(key, (Rectangle)null);
        Component window = this.openNonModalDialogImpl(key, title, messageType, content, actions, owner, bounds);
        window2manager.put(window, this);
        this.key2window.put(key, window);
        return key;
    }

    protected abstract Component openNonModalDialogImpl(String var1, String var2, int var3, JComponent var4, Action[] var5, Component var6, Rectangle var7);

    protected String getTemporaryKey() {
        return "_" + this.temporaryKeyCounter++;
    }

    protected String[] recallKeys() {
        return this.key2window.keySet().toArray(new String[0]);
    }

    protected Component recall(String key) {
        if (key == null) {
            return null;
        }
        return (Component)this.key2window.get(key);
    }

    protected void closeNotify(String key, Rectangle bounds, boolean maximized) {
        if (key == null) {
            return;
        }
        this.key2window.remove(key);
        if (key.startsWith("_")) {
            return;
        }
        if (bounds != null && !maximized) {
            this.registry.put(key, bounds);
        }
        this.registry.put(key + ".maximized", maximized);
    }

    public void closeAll() {
        String[] keys = this.recallKeys();
        for (int k = 0; k < keys.length; ++k) {
            this.close(keys[k]);
        }
    }

    protected class Content
    extends JOptionPane {
        protected Content(int messageType, JComponent content, Action[] actions) {
            super(new JLabel(), messageType, -1, null, new String[0]);
            JPanel wrapper = new JPanel(new BorderLayout());
            wrapper.add("Center", content);
            this.setMessage(wrapper);
            Object[] options = new Option[actions.length];
            for (int i = 0; i < actions.length; ++i) {
                options[i] = new Option(actions[i]);
            }
            this.setOptions(options);
            if (options.length > 0) {
                this.setInitialValue(options[0]);
            }
        }

        public void doLayout() {
            super.doLayout();
            Container container = this.getTopLevelAncestor();
            Dimension minimumSize = container.getMinimumSize();
            Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
            minimumSize.width = Math.min(screen.width / 2, minimumSize.width);
            minimumSize.height = Math.min(screen.height / 2, minimumSize.height);
            Dimension size = container.getSize();
            if (size.width < minimumSize.width || size.height < minimumSize.height) {
                Dimension newSize = new Dimension(Math.max(minimumSize.width, size.width), Math.max(minimumSize.height, size.height));
                container.setSize(newSize);
            }
        }

        private class Option
        extends JButton
        implements ActionListener {
            private Option(Action action) {
                super(action);
                this.addActionListener(this);
            }

            public void actionPerformed(ActionEvent e) {
                Content.this.setValue(this.getAction());
            }
        }
    }
}

