/*
 * Decompiled with CFR 0.152.
 */
package genj.window;

import genj.util.Registry;
import genj.window.DefaultWindowManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyVetoException;
import java.util.List;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenuBar;
import javax.swing.JScrollPane;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class LightweightWindowManager
extends DefaultWindowManager {
    private JDesktopPane desktop;

    public LightweightWindowManager(Registry registry, ImageIcon defaultDialogImage) {
        super(registry, defaultDialogImage);
    }

    private JDesktopPane getDesktop(String title, ImageIcon img) {
        if (this.desktop != null) {
            return this.desktop;
        }
        this.desktop = new JDesktopPane(){

            public Dimension getPreferredSize() {
                return Toolkit.getDefaultToolkit().getScreenSize();
            }
        };
        JFrame frame = new JFrame(title);
        frame.setIconImage(img.getImage());
        frame.getContentPane().add(new JScrollPane(this.desktop));
        frame.setDefaultCloseOperation(0);
        frame.pack();
        frame.setVisible(true);
        return this.desktop;
    }

    public boolean show(String key) {
        Component frame = this.recall(key);
        if (frame instanceof JInternalFrame) {
            ((JInternalFrame)frame).toFront();
        }
        return super.show(key);
    }

    protected Component openWindowImpl(final String key, String title, ImageIcon image, JComponent content, JMenuBar menu, Rectangle bounds, boolean maximized, final Action onClosing) {
        JInternalFrame frame = new JInternalFrame(title, true, true, true, true){

            public void dispose() {
                LightweightWindowManager.this.closeNotify(key, this.getBounds(), this.isMaximum());
                super.dispose();
            }
        };
        if (image != null) {
            frame.setFrameIcon(image);
        }
        if (menu != null) {
            frame.setJMenuBar(menu);
        }
        frame.getContentPane().add(content);
        if (onClosing == null) {
            frame.setDefaultCloseOperation(2);
        } else {
            frame.setDefaultCloseOperation(0);
            frame.addInternalFrameListener(new InternalFrameAdapter(){

                public void internalFrameClosing(InternalFrameEvent e) {
                    onClosing.actionPerformed(new ActionEvent(this, 0, key));
                }
            });
        }
        JDesktopPane desktop = this.getDesktop(title, image);
        Rectangle screen = new Rectangle(desktop.getSize());
        if (bounds == null) {
            frame.pack();
            Dimension dim = frame.getSize();
            bounds = new Rectangle(screen.width / 2 - dim.width / 2, screen.height / 2 - dim.height / 2, dim.width, dim.height);
        }
        frame.setBounds(bounds.intersection(screen));
        if (maximized) {
            try {
                frame.setMaximum(true);
            }
            catch (PropertyVetoException veto) {
                // empty catch block
            }
        }
        desktop.add(frame);
        frame.show();
        return frame;
    }

    public void close(String key) {
        Component frame = this.recall(key);
        if (frame instanceof JInternalFrame) {
            ((JInternalFrame)frame).dispose();
        }
        super.close(key);
    }

    public List getRootComponents() {
        List result = super.getRootComponents();
        if (this.desktop != null) {
            result.add(this.desktop);
        }
        return result;
    }

    public JComponent getContent(String key) {
        Component frame = this.recall(key);
        if (frame instanceof JInternalFrame) {
            return (JComponent)((JInternalFrame)frame).getContentPane().getComponent(0);
        }
        return super.getContent(key);
    }
}

