/*
 * Decompiled with CFR 0.152.
 */
package genj.window;

import genj.util.Registry;
import genj.window.WindowManager;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;

public class DefaultWindowManager
extends WindowManager {
    private Rectangle screen = new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
    private JFrame defaultFrame = new JFrame();

    public DefaultWindowManager(Registry registry, ImageIcon defaultDialogImage) {
        super(registry);
        if (defaultDialogImage != null) {
            this.defaultFrame.setIconImage(defaultDialogImage.getImage());
        }
    }

    protected Component openWindowImpl(final String key, String title, ImageIcon image, JComponent content, JMenuBar menu, Rectangle bounds, boolean maximized, final Action onClosing) {
        JFrame frame = new JFrame(){

            public void dispose() {
                DefaultWindowManager.this.closeNotify(key, this.getBounds(), this.getExtendedState() == 6);
                super.dispose();
            }
        };
        if (title != null) {
            frame.setTitle(title);
        }
        if (image != null) {
            frame.setIconImage(image.getImage());
        }
        if (menu != null) {
            frame.setJMenuBar(menu);
        }
        frame.getContentPane().add(content);
        if (onClosing == null) {
            frame.setDefaultCloseOperation(2);
        } else {
            frame.setDefaultCloseOperation(0);
            frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    onClosing.actionPerformed(new ActionEvent(this, 0, key));
                }
            });
        }
        if (bounds == null) {
            frame.pack();
            Dimension dim = frame.getSize();
            bounds = new Rectangle(this.screen.width / 2 - dim.width / 2, this.screen.height / 2 - dim.height / 2, dim.width, dim.height);
            LOG.log(Level.FINE, "Sizing window " + key + " to " + bounds + " after pack()");
        }
        frame.setBounds(bounds.intersection(this.screen));
        if (maximized) {
            frame.setExtendedState(6);
        }
        frame.setVisible(true);
        return frame;
    }

    protected Component openNonModalDialogImpl(final String key, String title, int messageType, JComponent content, Action[] actions, Component owner, Rectangle bounds) {
        WindowManager.Content optionPane = new WindowManager.Content(this, messageType, content, actions);
        final JDialog dlg = optionPane.createDialog(owner != null ? owner : this.defaultFrame, title);
        dlg.setResizable(true);
        dlg.setModal(false);
        if (bounds == null) {
            dlg.pack();
            if (owner != null) {
                dlg.setLocationRelativeTo(owner.getParent());
            }
        } else if (owner == null) {
            dlg.setBounds(bounds.intersection(this.screen));
        } else {
            dlg.setBounds(new Rectangle(bounds.getSize()).intersection(this.screen));
            dlg.setLocationRelativeTo(owner.getParent());
        }
        dlg.addComponentListener(new ComponentAdapter(){

            public void componentHidden(ComponentEvent e) {
                DefaultWindowManager.this.closeNotify(key, dlg.getBounds(), false);
                dlg.dispose();
            }
        });
        dlg.setVisible(true);
        return dlg;
    }

    protected Object openDialogImpl(final String key, String title, int messageType, JComponent content, Action[] actions, Component owner, Rectangle bounds) {
        WindowManager.Content optionPane = new WindowManager.Content(this, messageType, content, actions);
        final JDialog dlg = optionPane.createDialog(owner != null ? owner : this.defaultFrame, title);
        dlg.setResizable(true);
        dlg.setModal(true);
        if (bounds == null) {
            dlg.pack();
            if (owner != null) {
                dlg.setLocationRelativeTo(owner.getParent());
            }
        } else if (owner == null) {
            dlg.setBounds(bounds.intersection(this.screen));
        } else {
            dlg.setBounds(new Rectangle(bounds.getSize()).intersection(this.screen));
            dlg.setLocationRelativeTo(owner.getParent());
        }
        dlg.addComponentListener(new ComponentAdapter(){

            public void componentHidden(ComponentEvent e) {
                DefaultWindowManager.this.closeNotify(key, dlg.getBounds(), false);
                dlg.dispose();
            }
        });
        dlg.setVisible(true);
        return optionPane.getValue();
    }

    public boolean show(String key) {
        Component framedlg = this.recall(key);
        if (framedlg instanceof JFrame) {
            ((JFrame)framedlg).toFront();
            return true;
        }
        if (framedlg instanceof JDialog) {
            ((JDialog)framedlg).toFront();
            return true;
        }
        return false;
    }

    public void close(String key) {
        Component framedlg = this.recall(key);
        if (framedlg instanceof JFrame) {
            JFrame frame = (JFrame)framedlg;
            frame.dispose();
            return;
        }
        if (framedlg instanceof JDialog) {
            JDialog dlg = (JDialog)framedlg;
            dlg.setVisible(false);
            return;
        }
    }

    public List getRootComponents() {
        ArrayList<JRootPane> result = new ArrayList<JRootPane>();
        String[] keys = this.recallKeys();
        for (int k = 0; k < keys.length; ++k) {
            Component framedlg = this.recall(keys[k]);
            if (framedlg instanceof JFrame) {
                result.add(((JFrame)framedlg).getRootPane());
            }
            if (!(framedlg instanceof JDialog)) continue;
            result.add(((JDialog)framedlg).getRootPane());
        }
        return result;
    }

    public JComponent getContent(String key) {
        Component framedlg = this.recall(key);
        if (framedlg instanceof JFrame) {
            return (JComponent)((JFrame)framedlg).getContentPane().getComponent(0);
        }
        if (framedlg instanceof JDialog) {
            return (JComponent)((JDialog)framedlg).getContentPane().getComponent(0);
        }
        return null;
    }

    private Window getWindowForComponent(Component c) {
        if (c instanceof Frame || c instanceof Dialog || c == null) {
            return (Window)c;
        }
        return this.getWindowForComponent(c.getParent());
    }
}

