/*
 * Decompiled with CFR 0.152.
 */
package genj.view;

import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Property;
import genj.gedcom.TagPath;
import genj.util.MnemonicAndText;
import genj.util.Origin;
import genj.util.Registry;
import genj.util.Resources;
import genj.util.swing.Action2;
import genj.util.swing.MenuHelper;
import genj.view.ActionProvider;
import genj.view.ContextProvider;
import genj.view.ContextSelectionEvent;
import genj.view.Images;
import genj.view.SettingsWidget;
import genj.view.ViewContainer;
import genj.view.ViewContext;
import genj.view.ViewFactory;
import genj.view.ViewHandle;
import genj.window.WindowManager;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.lang.reflect.Array;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.FocusManager;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import sun.misc.Service;

public class ViewManager {
    static final Logger LOG = Logger.getLogger("genj.view");
    static Resources RESOURCES = Resources.get(ViewManager.class);
    Map keyStrokes2factories = new HashMap();
    private ContextHook contextHook = new ContextHook();
    private ViewFactory[] factories = null;
    private Map gedcom2factory2handles = new HashMap();
    private LinkedList allHandles = new LinkedList();
    private WindowManager windowManager = null;

    public ViewManager(WindowManager windowManager) {
        ArrayList factories = new ArrayList();
        Iterator it = Service.providers((Class)ViewFactory.class);
        while (it.hasNext()) {
            factories.add(it.next());
        }
        this.init(windowManager, factories);
    }

    public ViewManager(WindowManager windowManager, String[] factoryTypes) {
        ArrayList<ViewFactory> factories = new ArrayList<ViewFactory>();
        for (int f = 0; f < factoryTypes.length; ++f) {
            try {
                factories.add((ViewFactory)Class.forName(factoryTypes[f]).newInstance());
                continue;
            }
            catch (Throwable t) {
                LOG.log(Level.SEVERE, "Factory of type " + factoryTypes[f] + " cannot be instantiated", t);
            }
        }
        this.init(windowManager, factories);
    }

    public ViewHandle[] getViews(Gedcom gedcom) {
        ArrayList<ViewHandle> result = new ArrayList<ViewHandle>();
        Iterator handles = this.allHandles.iterator();
        while (handles.hasNext()) {
            ViewHandle handle = (ViewHandle)handles.next();
            if (handle.getGedcom() != gedcom) continue;
            result.add(handle);
        }
        return result.toArray(new ViewHandle[result.size()]);
    }

    private void init(WindowManager setWindowManager, List setFactories) {
        this.windowManager = setWindowManager;
        this.factories = setFactories.toArray(new ViewFactory[setFactories.size()]);
        for (int f = 0; f < this.factories.length; ++f) {
            ViewFactory factory = this.factories[f];
            String keystroke = "ctrl " + new MnemonicAndText(factory.getTitle(false)).getMnemonic();
            if (this.keyStrokes2factories.containsKey(keystroke)) continue;
            this.keyStrokes2factories.put(keystroke, factory);
        }
    }

    public ViewFactory[] getFactories() {
        return this.factories;
    }

    void openSettings(ViewHandle handle) {
        SettingsWidget settings = (SettingsWidget)this.windowManager.getContent("settings");
        if (settings == null) {
            settings = new SettingsWidget(this);
            settings.setView(handle);
            this.windowManager.openWindow("settings", RESOURCES.getString("view.edit.title"), Images.imgSettings, settings, null, null);
        } else {
            settings.setView(handle);
        }
    }

    public static Registry getRegistry(Gedcom gedcom) {
        Origin origin = gedcom.getOrigin();
        String name = origin.getFileName();
        return Registry.lookup(name, origin);
    }

    String getPackage(ViewFactory factory) {
        Matcher m = Pattern.compile(".*\\.(.*)\\..*").matcher(factory.getClass().getName());
        if (!m.find()) {
            throw new IllegalArgumentException("can't resolve package for " + factory);
        }
        return m.group(1);
    }

    private int getNextInSequence(Gedcom gedcom, ViewFactory factory) {
        ViewHandle handle;
        Map factories2handles = (Map)this.gedcom2factory2handles.get(gedcom);
        if (factories2handles == null) {
            return 1;
        }
        List handles = (List)factories2handles.get(factory.getClass());
        if (handles == null) {
            return 1;
        }
        int result = 1;
        Iterator it = handles.iterator();
        while (it.hasNext() && (handle = (ViewHandle)it.next()) != null) {
            ++result;
        }
        return result;
    }

    protected void closeView(ViewHandle handle) {
        this.windowManager.close("settings");
        this.windowManager.close(handle.getKey());
        MenuSelectionManager.defaultManager().clearSelectedPath();
        Map factory2handles = (Map)this.gedcom2factory2handles.get(handle.getGedcom());
        List handles = (List)factory2handles.get(handle.getFactory().getClass());
        handles.set(handle.getSequence() - 1, null);
        this.allHandles.remove(handle);
    }

    public ViewHandle openView(Class factory, Gedcom gedcom) {
        for (int f = 0; f < this.factories.length; ++f) {
            if (!this.factories[f].getClass().equals(factory)) continue;
            return this.openView(gedcom, this.factories[f]);
        }
        throw new IllegalArgumentException("Unknown factory " + factory.getName());
    }

    public ViewHandle openView(Gedcom gedcom, ViewFactory factory) {
        return this.openView(gedcom, factory, -1);
    }

    protected ViewHandle openView(Gedcom gedcom, ViewFactory factory, int sequence) {
        Vector<ViewHandle> handles;
        HashMap factory2handles;
        if (sequence < 0) {
            sequence = this.getNextInSequence(gedcom, factory);
        }
        if ((factory2handles = (HashMap)this.gedcom2factory2handles.get(gedcom)) == null) {
            factory2handles = new HashMap();
            this.gedcom2factory2handles.put(gedcom, factory2handles);
        }
        if ((handles = (Vector<ViewHandle>)factory2handles.get(factory.getClass())) == null) {
            handles = new Vector<ViewHandle>(10);
            factory2handles.put(factory.getClass(), handles);
        }
        handles.setSize(Math.max(handles.size(), sequence));
        if (handles.get(sequence - 1) != null) {
            ViewHandle old = (ViewHandle)handles.get(sequence - 1);
            this.windowManager.show(old.getKey());
            return old;
        }
        Registry registry = new Registry(ViewManager.getRegistry(gedcom), this.getPackage(factory) + "." + sequence);
        String title = gedcom.getName() + " - " + factory.getTitle(false) + " (" + registry.getViewSuffix() + ")";
        JComponent view = factory.createView(title, gedcom, registry, this);
        final ViewHandle handle = new ViewHandle(this, gedcom, title, registry, factory, view, sequence);
        ViewContainer container = new ViewContainer(handle);
        InputMap inputs = view.getInputMap(2);
        inputs.put(KeyStroke.getKeyStroke("shift F10"), this.contextHook);
        inputs.put(KeyStroke.getKeyStroke("CONTEXT_MENU"), this.contextHook);
        view.getActionMap().put(this.contextHook, this.contextHook);
        handles.set(handle.getSequence() - 1, handle);
        this.allHandles.add(handle);
        Action2 close = new Action2(){

            protected void execute() {
                ViewManager.this.closeView(handle);
            }
        };
        this.windowManager.openWindow(handle.getKey(), title, factory.getImage(), container, null, close);
        return handle;
    }

    public void closeViews(Gedcom gedcom) {
        ViewHandle[] handles = this.allHandles.toArray(new ViewHandle[this.allHandles.size()]);
        for (int i = 0; i < handles.length; ++i) {
            if (handles[i].getGedcom() != gedcom) continue;
            this.closeView(handles[i]);
        }
    }

    public void showView(JComponent view) {
        Iterator handles = this.allHandles.iterator();
        while (handles.hasNext()) {
            ViewHandle handle = (ViewHandle)handles.next();
            if (handle.getView() != view) continue;
            this.windowManager.show(handle.getKey());
            break;
        }
    }

    public Object[] getViews(Class of, Gedcom gedcom) {
        ArrayList<Object> result = new ArrayList<Object>(16);
        for (int f = 0; f < this.factories.length; ++f) {
            if (!of.isAssignableFrom(this.factories[f].getClass())) continue;
            result.add(this.factories[f]);
        }
        Iterator handles = this.allHandles.iterator();
        while (handles.hasNext()) {
            ViewHandle handle = (ViewHandle)handles.next();
            if (handle.getGedcom() != gedcom || !of.isAssignableFrom(handle.getView().getClass())) continue;
            result.add(handle.getView());
        }
        return result.toArray((Object[])Array.newInstance(of, result.size()));
    }

    public JPopupMenu getContextMenu(ViewContext context, Component target) {
        int i;
        if (context == null) {
            return null;
        }
        Property[] properties = context.getProperties();
        Property[] entities = context.getEntities();
        Gedcom gedcom = context.getGedcom();
        MenuSelectionManager.defaultManager().clearSelectedPath();
        while (target.getParent() != null) {
            target = target.getParent();
        }
        MenuHelper mh = new MenuHelper().setTarget(target);
        JPopupMenu popup = mh.createPopup();
        mh.createItems(context.getActions());
        mh.createSeparator();
        ActionProvider[] as = (ActionProvider[])this.getViews(ActionProvider.class, context.getGedcom());
        if (properties.length > 1) {
            mh.createMenu("'" + Property.getPropertyNames(properties, 5) + "' (" + properties.length + ")");
            for (i = 0; i < as.length; ++i) {
                try {
                    mh.createSeparator();
                    mh.createItems(as[i].createActions(properties, this));
                    continue;
                }
                catch (Throwable t) {
                    LOG.log(Level.WARNING, "Action Provider threw " + t.getClass() + " on createActions(Property[])", t);
                }
            }
            mh.popMenu();
        }
        if (properties.length == 1) {
            for (Property property = properties[0]; property != null && !(property instanceof Entity) && !property.isTransient(); property = property.getParent()) {
                mh.createMenu(Property.LABEL + " '" + TagPath.get(property).getName() + '\'', property.getImage(false));
                for (int i2 = 0; i2 < as.length; ++i2) {
                    try {
                        mh.createItems(as[i2].createActions(property, this));
                        continue;
                    }
                    catch (Throwable t) {
                        LOG.log(Level.WARNING, "Action Provider " + as[i2].getClass().getName() + " threw " + t.getClass() + " on createActions(Property)", t);
                    }
                }
                mh.popMenu();
            }
        }
        if (entities.length > 1) {
            mh.createMenu("'" + Property.getPropertyNames(entities, 5) + "' (" + entities.length + ")");
            for (i = 0; i < as.length; ++i) {
                try {
                    mh.createSeparator();
                    mh.createItems(as[i].createActions(entities, this));
                    continue;
                }
                catch (Throwable t) {
                    LOG.log(Level.WARNING, "Action Provider threw " + t.getClass() + " on createActions(Entity[])", t);
                }
            }
            mh.popMenu();
        }
        if (entities.length == 1) {
            Entity entity = entities[0];
            String title = Gedcom.getName(entity.getTag(), false) + " '" + entity.getId() + '\'';
            mh.createMenu(title, entity.getImage(false));
            for (int i3 = 0; i3 < as.length; ++i3) {
                try {
                    mh.createItems(as[i3].createActions(entity, this));
                    continue;
                }
                catch (Throwable t) {
                    LOG.log(Level.WARNING, "Action Provider " + as[i3].getClass().getName() + " threw " + t.getClass() + " on createActions(Entity)", t);
                }
            }
            mh.popMenu();
        }
        String title = "Gedcom '" + gedcom.getName() + '\'';
        mh.createMenu(title, Gedcom.getImage());
        for (int i4 = 0; i4 < as.length; ++i4) {
            try {
                mh.createItems(as[i4].createActions(gedcom, this));
                continue;
            }
            catch (Throwable t) {
                LOG.log(Level.WARNING, "Action Provider " + as[i4].getClass().getName() + " threw " + t.getClass() + " on createActions(Gedcom", t);
            }
        }
        mh.popMenu();
        return popup;
    }

    private class ContextHook
    extends Action2
    implements AWTEventListener {
        private ContextHook() {
            try {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Toolkit.getDefaultToolkit().addAWTEventListener(ContextHook.this, 16L);
                        return null;
                    }
                });
            }
            catch (Throwable t) {
                LOG.log(Level.WARNING, "Cannot install ContextHook (" + t.getMessage() + ")");
            }
        }

        private ViewContext getContext(Component component) {
            while (component != null) {
                ContextProvider provider;
                ViewContext context;
                if (component instanceof ContextProvider && (context = (provider = (ContextProvider)((Object)component)).getContext()) != null) {
                    return context;
                }
                component = component.getParent();
            }
            return null;
        }

        protected void execute() {
            JPopupMenu popup;
            Component focus = FocusManager.getCurrentManager().getFocusOwner();
            if (!(focus instanceof JComponent)) {
                return;
            }
            ViewContext context = this.getContext(focus);
            if (context != null && (popup = ViewManager.this.getContextMenu(context, focus)) != null) {
                popup.show(focus, 0, 0);
            }
        }

        public void eventDispatched(AWTEvent event) {
            if (!(event instanceof MouseEvent)) {
                return;
            }
            final MouseEvent me = (MouseEvent)event;
            if (!me.isPopupTrigger() && me.getID() != 500) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Component component = SwingUtilities.getDeepestComponentAt(me.getComponent(), me.getX(), me.getY());
                    if (!(component instanceof JComponent)) {
                        return;
                    }
                    Point point = SwingUtilities.convertPoint(me.getComponent(), me.getX(), me.getY(), component);
                    ViewContext context = ContextHook.this.getContext(component);
                    if (context == null) {
                        return;
                    }
                    if (me.getButton() == 1 && me.getID() == 500 && me.getClickCount() == 2) {
                        WindowManager.broadcast(new ContextSelectionEvent(context, component, true));
                        return;
                    }
                    if (me.isPopupTrigger()) {
                        MenuSelectionManager.defaultManager().clearSelectedPath();
                        JPopupMenu popup = ViewManager.this.getContextMenu(context, (JComponent)component);
                        if (popup != null) {
                            popup.show((JComponent)component, point.x, point.y);
                        }
                    }
                }
            });
        }
    }
}

