/*
 * Decompiled with CFR 0.152.
 */
package genj.view;

import genj.gedcom.Gedcom;
import genj.util.Registry;
import genj.view.ViewFactory;
import genj.view.ViewManager;
import javax.swing.JComponent;

public class ViewHandle {
    private ViewManager manager;
    private Gedcom gedcom;
    private JComponent view;
    private String title;
    private Registry registry;
    private ViewFactory factory;
    private int sequence;

    ViewHandle(ViewManager manager, Gedcom gedcom, String title, Registry registry, ViewFactory factory, JComponent view, int sequence) {
        this.manager = manager;
        this.gedcom = gedcom;
        this.title = title;
        this.registry = registry;
        this.view = view;
        this.factory = factory;
        this.sequence = sequence;
    }

    public Gedcom getGedcom() {
        return this.gedcom;
    }

    public String getTitle() {
        return this.title;
    }

    public JComponent getView() {
        return this.view;
    }

    public ViewFactory getFactory() {
        return this.factory;
    }

    public int getSequence() {
        return this.sequence;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public ViewManager getManager() {
        return this.manager;
    }

    String getKey() {
        return this.gedcom.getName() + "." + this.manager.getPackage(this.factory) + "." + this.sequence;
    }

    public String persist() {
        return this.factory.getClass().getName() + "#" + this.sequence;
    }

    public static ViewHandle restore(ViewManager manager, Gedcom gedcom, String persisted) {
        try {
            int hash = persisted.indexOf(35);
            ViewFactory factory = (ViewFactory)Class.forName(persisted.substring(0, hash).trim()).newInstance();
            int sequence = Integer.parseInt(persisted.substring(hash + 1).trim());
            return manager.openView(gedcom, factory, sequence);
        }
        catch (Throwable t) {
            return null;
        }
    }
}

