/*
 * Decompiled with CFR 0.152.
 */
package genj.view;

import genj.edit.actions.Redo;
import genj.edit.actions.Undo;
import genj.print.PrintRegistry;
import genj.print.PrintTask;
import genj.print.Printer;
import genj.util.swing.Action2;
import genj.util.swing.ButtonHelper;
import genj.view.Images;
import genj.view.SettingsWidget;
import genj.view.ToolBarSupport;
import genj.view.ViewFactory;
import genj.view.ViewHandle;
import genj.view.ViewManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Iterator;
import java.util.logging.Level;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolBar;

class ViewContainer
extends JPanel {
    private static final String ACC_CLOSE = "ctrl W";
    private static final String ACC_UNDO = "ctrl Z";
    private static final String ACC_REDO = "ctrl Y";
    private JToolBar bar;
    private ViewHandle viewHandle;

    ViewContainer(ViewHandle handle) {
        ViewManager mgr = handle.getManager();
        this.viewHandle = handle;
        JComponent view = this.viewHandle.getView();
        this.setLayout(new BorderLayout());
        this.add((Component)view, "Center");
        Iterator it = mgr.keyStrokes2factories.keySet().iterator();
        while (it.hasNext()) {
            String keystroke = it.next().toString();
            ViewFactory factory = (ViewFactory)mgr.keyStrokes2factories.get(keystroke);
            ActionOpen open = new ActionOpen(factory);
            open.setAccelerator(keystroke);
            open.install(view, 2);
        }
        new ActionClose().setAccelerator(ACC_CLOSE).install(view, 2);
        new Undo(this.viewHandle.getGedcom(), true).setAccelerator(ACC_UNDO).install(view, 2);
        new Redo(this.viewHandle.getGedcom(), true).setAccelerator(ACC_REDO).install(view, 2);
    }

    public void addNotify() {
        super.addNotify();
        JComponent view = this.viewHandle.getView();
        if (!(view instanceof ToolBarSupport) || this.bar != null) {
            return;
        }
        this.bar = new JToolBar();
        ((ToolBarSupport)((Object)view)).populate(this.bar);
        this.bar.add(Box.createGlue());
        ButtonHelper bh = new ButtonHelper().setContainer(this.bar);
        bh.setInsets(0);
        if (SettingsWidget.hasSettings(view)) {
            bh.create(new ActionOpenSettings());
        }
        try {
            Printer printer = (Printer)Class.forName(view.getClass().getName() + "Printer").newInstance();
            try {
                printer.setView(view);
                PrintTask print = new PrintTask(printer, this.viewHandle.getTitle(), view, new PrintRegistry(this.viewHandle.getRegistry(), "print"));
                print.setTip(ViewManager.RESOURCES, "view.print.tip");
                bh.create(print);
            }
            catch (Throwable t) {
                ViewManager.LOG.log(Level.WARNING, "can't setup printing for printer " + printer.getClass().getName());
                ViewManager.LOG.log(Level.FINE, "throwable while setting up " + printer.getClass().getName(), t);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        bh.create(new ActionClose());
        this.add((Component)this.bar, this.viewHandle.getRegistry().get("toolbar", "West"));
    }

    protected void addImpl(Component comp, Object constraints, int index) {
        if (comp == this.bar) {
            this.viewHandle.getRegistry().put("toolbar", constraints.toString());
            int orientation = 0;
            if ("West".equals(constraints) || "East".equals(constraints)) {
                orientation = 1;
            }
            this.bar.setOrientation(orientation);
        }
        super.addImpl(comp, constraints, index);
    }

    private class ActionOpen
    extends Action2 {
        private ViewFactory factory;

        private ActionOpen(ViewFactory factory) {
            this.factory = factory;
        }

        protected void execute() {
            ViewContainer.this.viewHandle.getManager().openView(ViewContainer.this.viewHandle.getGedcom(), this.factory, 1);
        }
    }

    private class ActionOpenSettings
    extends Action2 {
        protected ActionOpenSettings() {
            super.setImage(Images.imgSettings).setTip(ViewManager.RESOURCES, "view.settings.tip");
        }

        protected void execute() {
            ViewContainer.this.viewHandle.getManager().openSettings(ViewContainer.this.viewHandle);
        }
    }

    private class ActionClose
    extends Action2 {
        protected ActionClose() {
            this.setImage(Images.imgClose);
            this.setTip(ViewManager.RESOURCES, "view.close.tip");
        }

        protected void execute() {
            ViewContainer.this.viewHandle.getManager().closeView(ViewContainer.this.viewHandle);
        }
    }
}

