/*
 * Decompiled with CFR 0.152.
 */
package genj.view;

import genj.util.swing.Action2;
import genj.util.swing.ButtonHelper;
import genj.view.Settings;
import genj.view.ViewHandle;
import genj.view.ViewManager;
import genj.window.WindowManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

class SettingsWidget
extends JPanel {
    private static Map cache = new WeakHashMap();
    private JPanel pSettings;
    private JPanel pActions;
    private ActionApply apply = new ActionApply();
    private ActionReset reset = new ActionReset();
    private Settings settings;
    private ViewManager viewManager;

    protected SettingsWidget(ViewManager manager) {
        this.viewManager = manager;
        this.pSettings = new JPanel(new BorderLayout());
        JPanel pActions = new JPanel();
        ButtonHelper bh = new ButtonHelper().setContainer(pActions);
        bh.create(this.apply);
        bh.create(this.reset);
        bh.create(new ActionClose());
        this.setLayout(new BorderLayout());
        this.add((Component)this.pSettings, "Center");
        this.add((Component)pActions, "South");
    }

    protected void setView(ViewHandle handle) {
        this.pSettings.removeAll();
        this.settings = this.getSettings(handle.getView());
        if (this.settings != null) {
            this.settings.setView(handle.getView());
            JComponent editor = this.settings.getEditor();
            editor.setBorder(new TitledBorder(handle.getTitle()));
            this.pSettings.add((Component)editor, "Center");
            this.settings.reset();
        }
        this.apply.setEnabled(this.settings != null);
        this.reset.setEnabled(this.settings != null);
        this.pSettings.revalidate();
        this.pSettings.repaint();
    }

    static boolean hasSettings(JComponent view) {
        try {
            if (Settings.class.isAssignableFrom(Class.forName(view.getClass().getName() + "Settings"))) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    Settings getSettings(JComponent view) {
        Class<?> viewType = view.getClass();
        Settings result = (Settings)cache.get(viewType);
        if (result != null) {
            return result;
        }
        String type = viewType.getName() + "Settings";
        try {
            result = (Settings)Class.forName(type).newInstance();
            result.init(this.viewManager);
            cache.put(viewType, result);
        }
        catch (Throwable t) {
            result = null;
            ViewManager.LOG.log(Level.WARNING, "couldn't instantiate settings for " + view, t);
        }
        return result;
    }

    private class ActionReset
    extends Action2 {
        protected ActionReset() {
            this.setText(ViewManager.RESOURCES, "view.reset");
            this.setEnabled(false);
        }

        protected void execute() {
            SettingsWidget.this.settings.reset();
        }
    }

    private class ActionApply
    extends Action2 {
        protected ActionApply() {
            this.setText(ViewManager.RESOURCES, "view.apply");
            this.setEnabled(false);
        }

        protected void execute() {
            SettingsWidget.this.settings.apply();
        }
    }

    private class ActionClose
    extends Action2 {
        private ActionClose() {
            this.setText(ViewManager.RESOURCES, "view.close");
        }

        protected void execute() {
            WindowManager.getInstance(this.getTarget()).close("settings");
        }
    }
}

