/*
 * Decompiled with CFR 0.152.
 */
package genj.util.swing;

import genj.util.swing.ViewPortAdapter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ViewPortOverview
extends Panel {
    private static final int DIM_RESIZE = 6;
    private JViewport viewport;
    private Rectangle last = null;

    public ViewPortOverview(JViewport viewpOrt) {
        this.viewport = viewpOrt;
        EventGlue glue = new EventGlue();
        this.viewport.addChangeListener(glue);
        this.addMouseListener(glue);
        this.addMouseMotionListener(glue);
        this.viewport.addComponentListener(glue);
    }

    public void paint(Graphics g) {
        Dimension dim = this.getSize();
        g.setColor(Color.white);
        g.fillRect(0, 0, dim.width, dim.height);
        Point2D zoom = this.getZoom();
        this.renderContent(g, zoom.getX(), zoom.getY());
        g.setColor(Color.blue);
        g.drawRect(0, 0, dim.width - 1, dim.height - 1);
        this.last = null;
        this.renderIndicator(g, zoom);
    }

    protected void renderContent(Graphics g, double zoomx, double zoomy) {
    }

    private void renderIndicator(Graphics g, Point2D zoom) {
        if (this.last != null) {
            g.setColor(Color.white);
            g.setXORMode(Color.lightGray);
            g.fillRect(this.last.x, this.last.y, this.last.width, this.last.height);
        }
        if (zoom == null) {
            zoom = this.getZoom();
        }
        Rectangle shown = this.viewport.getViewRect();
        this.last = new Rectangle((int)((double)shown.x * zoom.getX()), (int)((double)shown.y * zoom.getY()), (int)((double)shown.width * zoom.getX()), (int)((double)shown.height * zoom.getY()));
        g.setColor(Color.lightGray);
        g.setXORMode(Color.white);
        g.fillRect(this.last.x, this.last.y, this.last.width, this.last.height);
    }

    private Point2D getZoom() {
        Dimension avail = this.getSize();
        Component c = this.viewport.getView();
        if (c instanceof ViewPortAdapter) {
            c = ((ViewPortAdapter)c).getComponent();
        }
        Dimension view = c.getSize();
        return new Point2D.Double((double)avail.width / (double)view.width, (double)avail.height / (double)view.height);
    }

    private class EventGlue
    extends ComponentAdapter
    implements ChangeListener,
    MouseListener,
    MouseMotionListener {
        private Point dragOffset = null;
        private boolean isResize = false;

        private EventGlue() {
        }

        public void stateChanged(ChangeEvent e) {
            if (!ViewPortOverview.this.isVisible()) {
                return;
            }
            ViewPortOverview.this.renderIndicator(ViewPortOverview.this.getGraphics(), null);
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            Point p = e.getPoint();
            this.isResize = this.isResize(p);
            this.dragOffset = ViewPortOverview.this.last.contains(p) ? new Point(((ViewPortOverview)ViewPortOverview.this).last.x - p.x, ((ViewPortOverview)ViewPortOverview.this).last.y - p.y) : null;
        }

        public void mouseReleased(MouseEvent e) {
            this.dragOffset = null;
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
            Point p = e.getPoint();
            if (this.isResize) {
                ViewPortOverview.this.setSize(new Dimension(p.x, p.y));
                return;
            }
            if (this.dragOffset == null) {
                return;
            }
            Point2D zoom = ViewPortOverview.this.getZoom();
            Rectangle shown = ViewPortOverview.this.viewport.getViewRect();
            int x = (int)((double)(p.x + this.dragOffset.x) / zoom.getX());
            int y = (int)((double)(p.y + this.dragOffset.y) / zoom.getY());
            ViewPortOverview.this.viewport.scrollRectToVisible(new Rectangle(x - shown.x, y - shown.y, shown.width, shown.height));
        }

        public void mouseMoved(MouseEvent e) {
            Point p = e.getPoint();
            int cursor = 0;
            if (ViewPortOverview.this.last != null && ViewPortOverview.this.last.contains(p)) {
                cursor = 13;
            }
            if (this.isResize(p)) {
                cursor = 5;
            }
            ViewPortOverview.this.setCursor(Cursor.getPredefinedCursor(cursor));
        }

        private boolean isResize(Point p) {
            Dimension dim = ViewPortOverview.this.getSize();
            return p.x > dim.width - 6 && p.y > dim.height - 6;
        }

        public void componentResized(ComponentEvent e) {
            ViewPortOverview.this.repaint();
        }
    }
}

