/*
 * Decompiled with CFR 0.152.
 */
package genj.util.swing;

import genj.util.ChangeSupport;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;

public class TextFieldWidget
extends JTextField {
    private boolean isTemplate = false;
    private boolean isSelectAllOnFocus = false;
    private ChangeSupport changeSupport = new ChangeSupport(this){

        public void fireChangeEvent() {
            TextFieldWidget.this.isTemplate = false;
            super.fireChangeEvent();
        }
    };
    private boolean blockSystemSelectionAccessViaToolkit = false;

    public TextFieldWidget() {
        this("", 0);
    }

    public TextFieldWidget(String text) {
        this(text, 0);
    }

    public TextFieldWidget(String text, int cols) {
        super(text, cols);
        this.setAlignmentX(0.0f);
        this.getDocument().addDocumentListener(this.changeSupport);
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    public TextFieldWidget setTemplate(boolean set) {
        this.isTemplate = set;
        return this;
    }

    public Dimension getMaximumSize() {
        return new Dimension(super.getMaximumSize().width, super.getPreferredSize().height);
    }

    public void setSelectAllOnFocus(boolean set) {
        this.isSelectAllOnFocus = set;
    }

    protected void processFocusEvent(FocusEvent e) {
        if (e.getID() == 1004 && (this.isTemplate || this.isSelectAllOnFocus)) {
            this.selectAll();
        }
        super.processFocusEvent(e);
    }

    public Toolkit getToolkit() {
        if (this.blockSystemSelectionAccessViaToolkit) {
            throw new HeadlessException("no access to system selection atm");
        }
        return super.getToolkit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectAll() {
        if (this.getDocument() != null) {
            this.setCaretPosition(this.getDocument().getLength());
            try {
                if (this.getToolkit().getSystemSelection() != null) {
                    this.blockSystemSelectionAccessViaToolkit = true;
                }
                this.moveCaretPosition(0);
            }
            finally {
                this.blockSystemSelectionAccessViaToolkit = false;
            }
        }
    }

    public String getText() {
        if (this.isTemplate) {
            return "";
        }
        return super.getText();
    }

    public boolean isEmpty() {
        return this.getText().trim().length() == 0;
    }

    public void setText(String txt) {
        super.setText(txt);
        this.setCaretPosition(0);
    }
}

