/*
 * Decompiled with CFR 0.152.
 */
package genj.util.swing;

import genj.util.GridBagHelper;
import genj.util.Trackable;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import javax.swing.UIManager;

public class ProgressWidget
extends JPanel {
    private static final String OPTION_CANCEL = UIManager.getString("OptionPane.cancelButtonText");
    private JProgressBar progress;
    private Trackable trackable;
    private Thread worker;
    private JLabel state;
    private Timer timer;

    public ProgressWidget(Trackable trAckable, Thread woRker) {
        this.trackable = trAckable;
        this.worker = woRker;
        GridBagHelper gh = new GridBagHelper(this).setInsets(new Insets(2, 2, 2, 2)).setParameter(17);
        this.state = new JLabel(" ", 0);
        gh.add(this.state, 0, 0);
        this.progress = new JProgressBar();
        gh.add(this.progress, 0, 1);
        this.timer = new Timer(100, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProgressWidget.this.progress.setValue(ProgressWidget.this.trackable.getProgress());
                ProgressWidget.this.state.setText(ProgressWidget.this.trackable.getState());
                if (!ProgressWidget.this.worker.isAlive()) {
                    ProgressWidget.this.timer.stop();
                }
            }
        });
    }

    public void addNotify() {
        this.timer.start();
        super.addNotify();
    }

    public void removeNotify() {
        this.timer.stop();
        this.trackable.cancelTrackable();
        super.removeNotify();
    }
}

