/*
 * Decompiled with CFR 0.152.
 */
package genj.util.swing;

import genj.util.swing.Action2;
import genj.util.swing.MenuHelper;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public class PopupWidget
extends JButton {
    private List items = new ArrayList();
    private boolean isFireOnClick = false;
    private JPopupMenu popup;

    public PopupWidget() {
        this((Icon)null);
    }

    public PopupWidget(Icon icon) {
        this(null, icon);
    }

    public PopupWidget(String text) {
        this(text, null);
    }

    public PopupWidget(String text, Icon icon) {
        this(text, icon, null);
    }

    public PopupWidget(String text, Icon icon, List actions) {
        super(text, icon);
        this.setModel(new Model());
        if (actions != null) {
            this.setActions(actions);
        }
        this.setFocusable(false);
        this.setMargin(new Insets(2, 2, 2, 2));
    }

    public void addNotify() {
        super.addNotify();
        if (this.getParent() instanceof JToolBar) {
            this.setMaximumSize(new Dimension(128, 128));
        }
    }

    protected JToolBar getToolBar() {
        if (!(this.getParent() instanceof JToolBar)) {
            return null;
        }
        return (JToolBar)this.getParent();
    }

    public void cancelPopup() {
        if (this.popup != null) {
            this.popup.setVisible(false);
            this.popup = null;
        }
    }

    public void showPopup() {
        this.cancelPopup();
        this.popup = this.createPopup();
        if (this.popup == null) {
            return;
        }
        int x = 0;
        int y = 0;
        JToolBar bar = this.getToolBar();
        if (bar == null) {
            x += this.getWidth();
        } else if (1 == bar.getOrientation()) {
            x += bar.getLocation().x == 0 ? this.getWidth() : -this.popup.getPreferredSize().width;
        } else {
            y += bar.getLocation().y == 0 ? this.getHeight() : -this.popup.getPreferredSize().height;
        }
        this.popup.show(this, x, y);
    }

    protected JPopupMenu createPopup() {
        List as = this.getActions();
        if (as.isEmpty()) {
            return null;
        }
        JPopupMenu popup = new JPopupMenu();
        if (as.size() > 16) {
            popup.setLayout(new GridLayout(0, (int)Math.ceil((float)as.size() / 16.0f)));
        }
        MenuHelper mh = new MenuHelper();
        mh.pushMenu(popup);
        mh.createItems(as);
        return popup;
    }

    public List getActions() {
        return this.items;
    }

    public void setActions(List actions) {
        this.items = actions;
    }

    public void setFocusable(boolean focusable) {
        try {
            super.setFocusable(focusable);
        }
        catch (Throwable t) {
            super.setRequestFocusEnabled(false);
        }
    }

    public void setFireOnClick(boolean set) {
        this.isFireOnClick = set;
    }

    private class Model
    extends DefaultButtonModel
    implements Runnable {
        boolean popupTriggered;

        private Model() {
        }

        public void setPressed(boolean b) {
            super.setPressed(b);
            if (b) {
                this.popupTriggered = true;
                SwingUtilities.invokeLater(this);
            }
        }

        public void run() {
            if (this.popupTriggered) {
                PopupWidget.this.showPopup();
            }
        }

        protected void fireActionPerformed(ActionEvent e) {
            if (PopupWidget.this.isFireOnClick) {
                this.popupTriggered = false;
                PopupWidget.this.cancelPopup();
                List as = PopupWidget.this.getActions();
                if (!as.isEmpty()) {
                    ((Action2)as.get(0)).trigger();
                }
            }
        }
    }
}

