/*
 * Decompiled with CFR 0.152.
 */
package genj.util.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class NestedBlockLayout
implements LayoutManager2,
Cloneable {
    private static final SAXException DONE = new SAXException("");
    private static final Logger LOG = Logger.getLogger("genj.util");
    private boolean invalidated = true;
    private Block root;
    private int padding = 1;

    private NestedBlockLayout(Block root) {
        this.root = root;
    }

    public NestedBlockLayout(String descriptor) {
        try {
            this.init(new StringReader(descriptor));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public NestedBlockLayout(Reader descriptor) throws IOException {
        this.init(descriptor);
    }

    public NestedBlockLayout(InputStream descriptor) throws IOException {
        this.init(new InputStreamReader(descriptor));
    }

    public Collection getCells() {
        return this.root.getCells(new ArrayList(10));
    }

    private void init(Reader descriptor) throws IOException {
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse(new InputSource(descriptor), (DefaultHandler)new DescriptorHandler());
        }
        catch (SAXException sax) {
            if (DONE == sax) {
                return;
            }
            throw new RuntimeException(sax);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
        }
    }

    public void addLayoutComponent(Component comp, Object key) {
        if (key instanceof Cell) {
            ((Cell)key).setContent(comp);
            return;
        }
        Cell cell = this.root.getCell(key != null ? key.toString() : null);
        if (cell != null) {
            cell.setContent(comp);
            return;
        }
        if (key == null) {
            throw new IllegalArgumentException("no available descriptor element - element qualifier required");
        }
        throw new IllegalArgumentException("element qualifier doesn't match any descriptor element");
    }

    public void addLayoutComponent(String element, Component comp) {
        this.addLayoutComponent(comp, element);
    }

    public void removeLayoutComponent(Component comp) {
        this.root.remove(comp);
    }

    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    public float getLayoutAlignmentX(Container target) {
        return 0.0f;
    }

    public float getLayoutAlignmentY(Container target) {
        return 0.0f;
    }

    public void invalidateLayout(Container target) {
        if (!this.invalidated) {
            this.root.invalidate(true);
            this.invalidated = true;
        }
    }

    public Dimension preferredLayoutSize(Container parent) {
        this.invalidated = false;
        return this.root.preferred();
    }

    public void layoutContainer(Container parent) {
        Insets insets = parent.getInsets();
        Rectangle in = new Rectangle(insets.left, insets.top, parent.getWidth() - insets.left - insets.right, parent.getHeight() - insets.top - insets.bottom);
        this.root.layout(in);
        this.invalidated = false;
    }

    public NestedBlockLayout copy() {
        try {
            NestedBlockLayout clone = (NestedBlockLayout)super.clone();
            clone.root = (Block)clone.root.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    public static class Cell
    extends Block {
        private String element;
        private Map attrs = new HashMap();
        private Component component;
        private Point grow = new Point();
        private int padding;
        private Point2D.Double staticWeight = new Point2D.Double();

        private Cell(String element, Attributes attributes, int padding) {
            super(attributes);
            String gy;
            String gx;
            String wy;
            this.element = element;
            this.padding = padding;
            int j = attributes.getLength();
            for (int i = 0; i < j; ++i) {
                this.attrs.put(attributes.getQName(i), attributes.getValue(i));
            }
            String wx = this.getAttribute("wx");
            if (wx != null) {
                this.staticWeight.x = Float.parseFloat(wx);
            }
            if ((wy = this.getAttribute("wy")) != null) {
                this.staticWeight.y = Float.parseFloat(wy);
            }
            if ((gx = this.getAttribute("gx")) != null) {
                this.grow.x = 1;
            }
            if ((gy = this.getAttribute("gy")) != null) {
                this.grow.y = 1;
            }
        }

        protected Object clone() {
            Cell clone = (Cell)super.clone();
            clone.component = null;
            return clone;
        }

        void setContent(Component component) {
            this.component = component;
        }

        public Collection getNestedLayouts() {
            ArrayList<NestedBlockLayout> result = new ArrayList<NestedBlockLayout>(this.subs.size());
            for (int i = 0; i < this.subs.size(); ++i) {
                result.add(new NestedBlockLayout((Block)this.subs.get(i)));
            }
            return result;
        }

        public String getElement() {
            return this.element;
        }

        public boolean isAttribute(String attr) {
            return this.attrs.containsKey(attr);
        }

        public String getAttribute(String attr) {
            return (String)this.attrs.get(attr);
        }

        boolean remove(Component component) {
            if (this.component == component) {
                this.component = null;
                this.invalidate(false);
                return true;
            }
            return false;
        }

        Dimension preferred() {
            if (this.preferred != null) {
                return this.preferred;
            }
            if (this.component == null || !this.component.isVisible()) {
                this.preferred = new Dimension();
            } else {
                this.preferred = new Dimension(this.component.getPreferredSize());
                this.preferred.width += this.padding * 2;
                this.preferred.height += this.padding * 2;
            }
            return this.preferred;
        }

        Point2D weight() {
            return this.staticWeight;
        }

        void layout(Rectangle in) {
            int extraY;
            if (this.component == null) {
                return;
            }
            Rectangle avail = new Rectangle(in.x + this.padding, in.y + this.padding, in.width - this.padding * 2, in.height - this.padding * 2);
            Dimension pref = this.preferred();
            Dimension max = this.component.getMaximumSize();
            if (this.grow.x != 0) {
                max.width = avail.width;
            } else if (this.staticWeight.x == 0.0) {
                max.width = pref.width;
            }
            if (this.grow.y != 0) {
                max.height = avail.height;
            } else if (this.staticWeight.y == 0.0) {
                max.height = pref.height;
            }
            int extraX = avail.width - max.width;
            if (extraX > 0) {
                avail.x += extraX / 2;
                avail.width = max.width;
            }
            if ((extraY = avail.height - max.height) > 0) {
                avail.y += extraY / 2;
                avail.height = max.height;
            }
            this.component.setBounds(avail);
        }

        Cell getCell(String elem) {
            return elem == null && this.component == null || this.element.equals(elem) ? this : null;
        }

        Collection getCells(Collection collect) {
            collect.add(this);
            return collect;
        }
    }

    private static class Column
    extends Block {
        Column(Attributes attributes) {
            super(attributes);
        }

        Block add(Block sub) {
            if (sub instanceof Column) {
                throw new IllegalArgumentException("column can't contain column");
            }
            super.add(sub);
            return sub;
        }

        Dimension preferred() {
            if (this.preferred != null) {
                return this.preferred;
            }
            this.preferred = new Dimension();
            for (int i = 0; i < this.subs.size(); ++i) {
                Dimension sub = ((Block)this.subs.get(i)).preferred();
                this.preferred.width = Math.max(this.preferred.width, sub.width);
                this.preferred.height += sub.height;
            }
            return this.preferred;
        }

        Point2D weight() {
            if (this.weight != null) {
                return this.weight;
            }
            this.weight = new Point2D.Double();
            for (int i = 0; i < this.subs.size(); ++i) {
                Point2D sub = ((Block)this.subs.get(i)).weight();
                this.weight.x = Math.max(this.weight.x, sub.getX());
                this.weight.y += sub.getY();
            }
            return this.weight;
        }

        void layout(Rectangle in) {
            double weight = 0.0;
            int spare = in.height;
            for (int i = 0; i < this.subs.size(); ++i) {
                Block sub = (Block)this.subs.get(i);
                spare -= sub.preferred().height;
                weight += sub.weight().getY();
            }
            double spareOverWeight = weight > 0.0 ? (double)spare / weight : 0.0;
            Rectangle avail = new Rectangle(in.x, in.y, 0, 0);
            for (int i = 0; i < this.subs.size(); ++i) {
                Block sub = (Block)this.subs.get(i);
                avail.width = in.width;
                avail.height = sub.preferred().height + (int)(sub.weight().getY() * spareOverWeight);
                sub.layout(avail);
                avail.y += avail.height;
            }
        }
    }

    private static class Row
    extends Block {
        Row(Attributes attributes) {
            super(attributes);
        }

        Block add(Block sub) {
            if (sub instanceof Row) {
                throw new IllegalArgumentException("row can't contain row");
            }
            super.add(sub);
            return sub;
        }

        Dimension preferred() {
            if (this.preferred != null) {
                return this.preferred;
            }
            this.preferred = new Dimension();
            for (int i = 0; i < this.subs.size(); ++i) {
                Dimension sub = ((Block)this.subs.get(i)).preferred();
                this.preferred.width += sub.width;
                this.preferred.height = Math.max(this.preferred.height, sub.height);
            }
            return this.preferred;
        }

        Point2D weight() {
            if (this.weight != null) {
                return this.weight;
            }
            this.weight = new Point2D.Double();
            for (int i = 0; i < this.subs.size(); ++i) {
                Block sub = (Block)this.subs.get(i);
                this.weight.x += sub.weight().getX();
                this.weight.y = Math.max(this.weight.y, sub.weight().getY());
            }
            return this.weight;
        }

        void layout(Rectangle in) {
            double weight = 0.0;
            int spare = in.width;
            for (int i = 0; i < this.subs.size(); ++i) {
                Block sub = (Block)this.subs.get(i);
                spare -= sub.preferred().width;
                weight += sub.weight().getX();
            }
            double spareOverWeight = weight > 0.0 ? (double)spare / weight : 0.0;
            Rectangle avail = new Rectangle(in.x, in.y, 0, 0);
            for (int i = 0; i < this.subs.size(); ++i) {
                Block sub = (Block)this.subs.get(i);
                avail.width = sub.preferred().width + (int)(sub.weight().getX() * spareOverWeight);
                avail.height = in.height;
                sub.layout(avail);
                avail.x += avail.width;
            }
        }
    }

    private static abstract class Block
    implements Cloneable {
        Dimension preferred;
        Point2D.Double weight;
        ArrayList subs = new ArrayList(16);

        Block(Attributes attributes) {
        }

        protected Object clone() {
            try {
                Block clone = (Block)super.clone();
                clone.subs = new ArrayList(this.subs.size());
                for (int i = 0; i < this.subs.size(); ++i) {
                    clone.subs.add(((Block)this.subs.get(i)).clone());
                }
                return clone;
            }
            catch (CloneNotSupportedException cnse) {
                throw new Error();
            }
        }

        boolean remove(Component component) {
            for (int i = 0; i < this.subs.size(); ++i) {
                Block sub = (Block)this.subs.get(i);
                if (!sub.remove(component)) continue;
                this.invalidate(false);
                return true;
            }
            return false;
        }

        Block add(Block block) {
            this.subs.add(block);
            this.invalidate(false);
            return block;
        }

        void invalidate(boolean recurse) {
            this.preferred = null;
            this.weight = null;
            if (recurse) {
                for (int i = 0; i < this.subs.size(); ++i) {
                    ((Block)this.subs.get(i)).invalidate(true);
                }
            }
        }

        abstract Point2D weight();

        abstract Dimension preferred();

        abstract void layout(Rectangle var1);

        Collection getCells(Collection collect) {
            for (int i = 0; i < this.subs.size(); ++i) {
                ((Block)this.subs.get(i)).getCells(collect);
            }
            return collect;
        }

        Cell getCell(String element) {
            Cell result = null;
            for (int i = 0; result == null && i < this.subs.size(); ++i) {
                Block sub = (Block)this.subs.get(i);
                result = sub.getCell(element);
            }
            return result;
        }
    }

    private class DescriptorHandler
    extends DefaultHandler {
        private Stack stack = new Stack();

        private DescriptorHandler() {
        }

        public InputSource resolveEntity(String publicId, String systemId) {
            throw new IllegalArgumentException("Request for resolveEntity " + publicId + "/" + systemId + " not allowed in layout descriptor");
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            Block block = this.getBlock(qName, attributes);
            if (this.stack.isEmpty()) {
                NestedBlockLayout.this.root = block;
            } else {
                Block parent = (Block)this.stack.peek();
                parent.add(block);
            }
            this.stack.add(block);
        }

        private Block getBlock(String element, Attributes attrs) {
            if ("row".equals(element)) {
                return new Row(attrs);
            }
            if ("col".equals(element)) {
                return new Column(attrs);
            }
            return new Cell(element, attrs, NestedBlockLayout.this.padding);
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.stack == null || this.stack.size() == 0) {
                throw new SAXException("unexpected /element");
            }
            Block block = (Block)this.stack.pop();
            if (this.stack.isEmpty()) {
                throw DONE;
            }
        }
    }
}

