/*
 * Decompiled with CFR 0.152.
 */
package genj.util.swing;

import genj.util.MnemonicAndText;
import genj.util.swing.Action2;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class MenuHelper {
    private Stack menus = new Stack();
    private Component target = null;

    public MenuHelper popMenu() {
        JMenu menu = (JMenu)this.menus.pop();
        if (menu.getMenuComponentCount() == 0) {
            menu.getParent().remove(menu);
        }
        return this;
    }

    public MenuHelper pushMenu(JPopupMenu popup) {
        this.menus.push(popup);
        return this;
    }

    public MenuHelper setTarget(Component set) {
        this.target = set;
        return this;
    }

    public JMenuBar createBar() {
        JMenuBar result = new JMenuBar();
        this.menus.push(result);
        return result;
    }

    public JMenu createMenu(String text) {
        return this.createMenu(text, null);
    }

    public JMenu createMenu(String text, Icon img) {
        Object menu;
        JMenu result = new JMenu();
        if (text != null && text.length() > 0) {
            MnemonicAndText mat = new MnemonicAndText(text);
            result.setText(mat.getText());
            result.setMnemonic(mat.getMnemonic());
        }
        if (img != null) {
            result.setIcon(img);
        }
        if ((menu = this.peekMenu()) instanceof JMenu) {
            ((JMenu)menu).add(result);
        }
        if (menu instanceof JPopupMenu) {
            ((JPopupMenu)menu).add(result);
        }
        if (menu instanceof JMenuBar) {
            ((JMenuBar)menu).add(result);
        }
        this.menus.push(result);
        return result;
    }

    public JPopupMenu createPopup() {
        JPopupMenu result = new JPopupMenu();
        this.pushMenu(result);
        return result;
    }

    public JPopupMenu createPopup(Component component) {
        final JPopupMenu result = this.createPopup();
        component.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                this.mouseReleased(e);
            }

            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    result.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        return result;
    }

    public JLabel createItem(String txt, ImageIcon img, boolean emphasized) {
        JLabel item = new JLabel(txt, img, 0);
        if (emphasized) {
            item.setFont(item.getFont().deriveFont(1));
        }
        this.createItem(item);
        return item;
    }

    private void createItem(Component item) {
        Object menu = this.peekMenu();
        if (menu instanceof JMenu) {
            ((JMenu)menu).add(item);
        }
        if (menu instanceof JPopupMenu) {
            ((JPopupMenu)menu).add(item);
        }
        if (menu instanceof JMenuBar) {
            ((JMenuBar)menu).add(item);
        }
    }

    public void createItems(List actions) {
        if (actions == null || actions.isEmpty()) {
            return;
        }
        this.createSeparator();
        Iterator it = actions.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (o instanceof Action2.Group) {
                this.createMenu(((Action2.Group)o).getName());
                this.createItems((List)o);
                this.popMenu();
                continue;
            }
            if (o instanceof List) {
                this.createSeparator();
                this.createItems((List)o);
                continue;
            }
            if (o instanceof Component) {
                this.createItem((Component)o);
                continue;
            }
            if (o instanceof Action2) {
                this.createItem((Action2)o);
                continue;
            }
            throw new IllegalArgumentException("type " + o.getClass() + " n/a");
        }
    }

    public JMenuItem createItem(Action2 action) {
        Object menu;
        if (action == Action2.NOOP) {
            this.createSeparator();
            return null;
        }
        JMenuItem result = new JMenuItem();
        result.setAction(action);
        if (action.getAccelerator() != null) {
            result.setAccelerator(action.getAccelerator());
        }
        if ((menu = this.peekMenu()) instanceof JMenu) {
            ((JMenu)menu).add(result);
        }
        if (menu instanceof JPopupMenu) {
            ((JPopupMenu)menu).add(result);
        }
        if (menu instanceof JMenuBar) {
            ((JMenuBar)menu).add(result);
        }
        if (this.target != null) {
            action.setTarget(this.target);
        }
        return result;
    }

    public MenuHelper createSeparator() {
        JPopupMenu pmenu;
        JMenu jmenu;
        int count;
        Object menu = this.peekMenu();
        if (menu instanceof JMenu && (count = (jmenu = (JMenu)menu).getMenuComponentCount()) > 0 && jmenu.getMenuComponent(count - 1).getClass() != JPopupMenu.Separator.class) {
            jmenu.addSeparator();
        }
        if (menu instanceof JPopupMenu && (count = (pmenu = (JPopupMenu)menu).getComponentCount()) > 0 && pmenu.getComponent(count - 1).getClass() != JPopupMenu.Separator.class) {
            pmenu.addSeparator();
        }
        return this;
    }

    private Object peekMenu() {
        if (this.menus.size() == 0) {
            return null;
        }
        return this.menus.peek();
    }
}

