/*
 * Decompiled with CFR 0.152.
 */
package genj.util.swing;

import genj.util.swing.ImageIcon;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ListSelectionWidget
extends JComponent {
    private JList lChoose;
    private List choices = new ArrayList();
    private Set selection = null;

    public ListSelectionWidget() {
        this.lChoose = new JList();
        this.lChoose.setCellRenderer(new Renderer());
        this.lChoose.setSelectionMode(0);
        this.lChoose.addMouseListener(new SelectionListener());
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.lChoose), "Center");
    }

    public Dimension getPreferredSize() {
        return new Dimension(64, 64);
    }

    private void update() {
        this.lChoose.setListData(this.choices.toArray(new Object[this.choices.size()]));
    }

    public void addChoice(Object choice) {
        this.choices.add(choice);
        this.update();
    }

    public void removeChoice(Object choice) {
        this.choices.remove(choice);
        this.update();
    }

    public List getChoices() {
        return Collections.unmodifiableList(this.choices);
    }

    public void setChoices(Object[] set) {
        this.choices.clear();
        this.choices.addAll(Arrays.asList(set));
        this.update();
    }

    public void setChoices(Collection c) {
        this.choices = new ArrayList(c);
        this.update();
    }

    public void setSelection(Set set) {
        this.selection = new HashSet(set);
        this.selection.retainAll(this.choices);
    }

    public Set getSelection() {
        if (this.selection == null) {
            this.selection = new HashSet();
        }
        return Collections.unmodifiableSet(this.selection);
    }

    public void up() {
        int row = this.lChoose.getSelectedIndex();
        if (row == -1 || row == 0) {
            return;
        }
        Object o = this.choices.get(row);
        this.choices.set(row, this.choices.get(row - 1));
        this.choices.set(row - 1, o);
        this.update();
        this.lChoose.setSelectedIndex(row - 1);
    }

    public void down() {
        int row = this.lChoose.getSelectedIndex();
        if (row == -1 || row == this.choices.size() - 1) {
            return;
        }
        Object o = this.choices.get(row);
        this.choices.set(row, this.choices.get(row + 1));
        this.choices.set(row + 1, o);
        this.update();
        this.lChoose.setSelectedIndex(row + 1);
    }

    protected String getText(Object choice) {
        return choice.toString();
    }

    protected ImageIcon getIcon(Object choice) {
        return null;
    }

    private class SelectionListener
    extends MouseAdapter {
        private SelectionListener() {
        }

        public void mousePressed(MouseEvent me) {
            if (ListSelectionWidget.this.selection == null) {
                return;
            }
            int pos = ListSelectionWidget.this.lChoose.locationToIndex(me.getPoint());
            if (pos == -1) {
                return;
            }
            Object choice = ListSelectionWidget.this.choices.get(pos);
            if (!ListSelectionWidget.this.selection.remove(choice)) {
                ListSelectionWidget.this.selection.add(choice);
            }
            ListSelectionWidget.this.lChoose.repaint(ListSelectionWidget.this.lChoose.getCellBounds(pos, pos));
        }
    }

    private class Renderer
    extends DefaultListCellRenderer {
        private JPanel panel = new JPanel();
        private JCheckBox check = new JCheckBox();

        private Renderer() {
            this.check.setOpaque(false);
            this.panel.setOpaque(false);
            this.panel.setLayout(new BorderLayout());
            this.panel.add((Component)this.check, "West");
            this.panel.add((Component)this, "Center");
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this.setText(ListSelectionWidget.this.getText(value));
            this.setIcon(ListSelectionWidget.this.getIcon(value));
            if (ListSelectionWidget.this.selection == null) {
                return this;
            }
            this.check.setSelected(ListSelectionWidget.this.selection.contains(value));
            return this.panel;
        }
    }
}

