/*
 * Decompiled with CFR 0.152.
 */
package genj.util.swing;

import genj.util.swing.Action2;
import genj.util.swing.ImageIcon;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JLabel;

public class LinkWidget
extends JLabel {
    private boolean hover = false;
    private Action2 action;
    private Color normal;

    public LinkWidget(Action2 action) {
        this(action.getText(), action.getImage());
        this.setToolTipText(action.getTip());
        this.action = action;
    }

    public LinkWidget(String text, Icon img) {
        super(text, img, 2);
        this.addMouseListener(new Callback());
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    public LinkWidget(ImageIcon img) {
        this(null, img);
    }

    public LinkWidget() {
        this(null, null);
    }

    protected void fireActionPerformed() {
        if (this.action != null) {
            this.action.actionPerformed(new ActionEvent(this, 0, ""));
        }
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!this.hover) {
            return;
        }
        g.setColor(this.getForeground());
        g.drawLine(1, this.getHeight() - 1, this.getWidth() - 1 - 1, this.getHeight() - 1);
    }

    private class Callback
    extends MouseAdapter {
        private Callback() {
        }

        public void mouseClicked(MouseEvent e) {
            LinkWidget.this.fireActionPerformed();
        }

        public void mouseExited(MouseEvent e) {
            LinkWidget.this.hover = false;
            LinkWidget.this.repaint();
        }

        public void mouseEntered(MouseEvent e) {
            LinkWidget.this.hover = true;
            LinkWidget.this.repaint();
        }
    }
}

