/*
 * Decompiled with CFR 0.152.
 */
package genj.util.swing;

import genj.util.Origin;
import genj.util.swing.ViewPortAdapter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.event.IIOReadUpdateListener;
import javax.imageio.stream.ImageInputStream;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ImageWidget
extends JPanel {
    private static final Logger LOG = Logger.getLogger("genj.util");
    private static final Worker WORKER = new Worker();
    private static final Map source2imgsoftref = new HashMap();
    private JScrollPane scroll = new JScrollPane();
    private Content content = new Content();
    private double zoom;

    public ImageWidget() {
        super(new BorderLayout());
        this.scroll = new JScrollPane(new ViewPortAdapter(this.content));
        this.add((Component)this.scroll, "Center");
    }

    public void setSource(Source source) {
        this.content.setSource(source);
    }

    public Source getSource() {
        return this.content.source;
    }

    public void setZoom(double zoom) {
        if (zoom < 0.0) {
            return;
        }
        this.zoom = zoom;
        this.content.revalidate();
        this.content.setToolTipText(zoom == 0.0 ? null : (int)(zoom * 100.0) + "%");
    }

    public double getZoom() {
        return this.zoom;
    }

    private static Image lookupCachedImage(Source source) {
        Image result = null;
        SoftReference ref = (SoftReference)source2imgsoftref.get(source);
        if (ref != null) {
            result = (Image)ref.get();
        }
        return result;
    }

    private static void keepCachedImage(Source source, Image img) {
        source2imgsoftref.put(source, new SoftReference<Image>(img));
    }

    private static class Worker
    implements Runnable {
        private Stack stack = new Stack();
        private Runnable current = null;

        Worker() {
            Thread t = new Thread(this);
            t.setPriority(5);
            t.setDaemon(true);
            t.start();
        }

        synchronized void add(Runnable r) {
            if (this.current != r && !this.stack.contains(r)) {
                this.stack.push(r);
            }
            this.notify();
        }

        public void run() {
            while (true) {
                try {
                    while (true) {
                        this.next();
                        this.current.run();
                        this.current = null;
                    }
                }
                catch (Throwable throwable) {
                    continue;
                }
                break;
            }
        }

        private synchronized void next() throws InterruptedException {
            while (true) {
                if (!this.stack.isEmpty()) {
                    this.current = (Runnable)this.stack.pop();
                    return;
                }
                this.wait();
            }
        }
    }

    public static class ByteArraySource
    extends Source {
        private byte[] data;

        public ByteArraySource(byte[] data) {
            super(data.length + " bytes");
            this.data = data;
        }

        protected InputStream open() throws IOException {
            return new ByteArrayInputStream(this.data);
        }

        public int hashCode() {
            return this.data.hashCode();
        }

        public boolean equals(Object obj) {
            return this.data == obj;
        }
    }

    public static class FileSource
    extends Source {
        private File file;

        public FileSource(File file) {
            super(file.getAbsolutePath());
            this.file = file;
        }

        protected InputStream open() throws IOException {
            return new FileInputStream(this.file);
        }

        public boolean equals(Object other) {
            if (!(other instanceof FileSource)) {
                return false;
            }
            FileSource that = (FileSource)other;
            return this.file.equals(that.file);
        }

        public int hashCode() {
            return this.file.hashCode();
        }
    }

    public static class RelativeSource
    extends Source {
        private Origin origin;

        public RelativeSource(Origin origin, String name) {
            super(name);
            this.origin = origin;
        }

        protected InputStream open() throws IOException {
            return this.origin.open(this.name);
        }

        public boolean equals(Object other) {
            if (!(other instanceof RelativeSource)) {
                return false;
            }
            RelativeSource that = (RelativeSource)other;
            return this.origin.equals(that.origin) && this.name.equals(that.name);
        }

        public int hashCode() {
            return this.origin.hashCode() + this.name.hashCode();
        }
    }

    public static abstract class Source {
        protected String name;

        private Source() {
        }

        public Source(String name) {
            this.name = name;
        }

        protected abstract InputStream open() throws IOException;

        public String toString() {
            return this.name != null ? this.name : super.toString();
        }
    }

    private class Content
    extends JComponent
    implements Runnable,
    IIOReadUpdateListener {
        private Source source = null;
        private Dimension cachedDimension;

        private Content() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (ImageWidget.lookupCachedImage(this.source) != null) {
                return;
            }
            InputStream in = null;
            ImageReader reader = null;
            try {
                in = this.source.open();
                ImageInputStream iin = ImageIO.createImageInputStream(in);
                Iterator<ImageReader> iter = ImageIO.getImageReaders(iin);
                if (!iter.hasNext()) {
                    throw new IOException("no suitable image reader for " + this.source);
                }
                reader = iter.next();
                reader.setInput(iin, false, false);
                reader.addIIOReadUpdateListener(this);
                reader.read(0, reader.getDefaultReadParam());
            }
            catch (Throwable t) {
                LOG.fine("Loading " + this.source + " failed with " + t.getMessage());
                ImageWidget.keepCachedImage(this.source, null);
            }
            finally {
                try {
                    in.close();
                }
                catch (Throwable t) {}
                try {
                    reader.dispose();
                }
                catch (Throwable t) {}
            }
        }

        private void setSource(Source source) {
            this.source = source;
            this.cachedDimension = null;
            this.revalidate();
        }

        private Image getCachedImage() {
            return ImageWidget.lookupCachedImage(this.source);
        }

        private Dimension getCachedImageSize() {
            if (this.cachedDimension == null) {
                boolean w = false;
                int h = 0;
                Image img = this.getCachedImage();
                if (img == null) {
                    WORKER.add(this);
                    return new Dimension(0, 0);
                }
                h = img.getHeight(null);
                this.cachedDimension = new Dimension(img.getWidth(null), h);
            }
            return new Dimension(this.cachedDimension);
        }

        protected void paintComponent(Graphics g) {
            double scale;
            if (this.source == null) {
                return;
            }
            Image img = this.getCachedImage();
            if (img == null) {
                WORKER.add(this);
                return;
            }
            Graphics2D g2d = (Graphics2D)g;
            if (ImageWidget.this.zoom == 0.0) {
                Dimension avail = this.getSize();
                scale = (double)avail.width / (double)this.getCachedImageSize().width;
            } else {
                scale = ImageWidget.this.zoom;
            }
            g2d.scale(scale, scale);
            g2d.drawImage(img, 0, 0, null);
        }

        public Dimension getPreferredSize() {
            double scale;
            if (this.source == null) {
                return new Dimension(0, 0);
            }
            Dimension dim = this.getCachedImageSize();
            if (ImageWidget.this.zoom == 0.0) {
                Dimension avail = ImageWidget.this.scroll.getSize();
                double zx = (double)avail.width / (double)dim.width;
                double zy = (double)avail.height / (double)dim.height;
                scale = Math.min(1.0, Math.min(zx, zy));
            } else {
                scale = ImageWidget.this.zoom;
            }
            dim.width = (int)((double)dim.width * scale);
            dim.height = (int)((double)dim.height * scale);
            return dim;
        }

        public void passComplete(ImageReader reader, BufferedImage img) {
        }

        public void thumbnailPassComplete(ImageReader reader, BufferedImage thumb) {
        }

        public void passStarted(ImageReader reader, BufferedImage img, int pass, int minPass, int maxPass, int minX, int minY, int periodX, int periodY, int[] bands) {
        }

        public void thumbnailPassStarted(ImageReader reader, BufferedImage thumb, int pass, int minPass, int maxPass, int minX, int minY, int periodX, int periodY, int[] bands) {
        }

        public void imageUpdate(ImageReader reader, BufferedImage img, int minX, int minY, int width, int height, int periodX, int periodY, int[] bands) {
            double scale;
            ImageWidget.keepCachedImage(this.source, img);
            int w = img.getWidth();
            int h = img.getHeight();
            if (this.cachedDimension == null || this.cachedDimension.width != w || this.cachedDimension.height != h) {
                this.cachedDimension = new Dimension(w, h);
                this.revalidate();
                return;
            }
            if (this.getWidth() == 0 || this.getHeight() == 0 || !this.isVisible()) {
                return;
            }
            width *= periodX;
            height *= periodY;
            Graphics2D g2d = (Graphics2D)this.getGraphics();
            if (ImageWidget.this.zoom == 0.0) {
                Dimension avail = this.getSize();
                scale = (double)avail.width / (double)this.getCachedImageSize().width;
            } else {
                scale = ImageWidget.this.zoom;
            }
            g2d.scale(scale, scale);
            try {
                g2d.drawImage(img, minX, minY, minX + width, minY + height, minX, minY, minX + width, minY + height, null);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }

        public void thumbnailUpdate(ImageReader source, BufferedImage thumb, int minX, int minY, int width, int height, int periodX, int periodY, int[] bands) {
        }
    }
}

