/*
 * Decompiled with CFR 0.152.
 */
package genj.util.swing;

import genj.util.ByteArray;
import genj.util.Dimension2d;
import genj.util.ImageSniffer;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.GrayFilter;

public class ImageIcon
extends javax.swing.ImageIcon {
    private Point dpi = null;
    private Map overlays = new WeakHashMap();

    public ImageIcon(Image copy) {
        super(copy);
    }

    public ImageIcon(String naMe, byte[] data) {
        super(data);
        if (this.getImageLoadStatus() != 8) {
            throw new RuntimeException("load status incomplete");
        }
        if (this.getIconHeight() < 0 || this.getIconWidth() < 0) {
            throw new RuntimeException("image with invalid width/height");
        }
        this.setDescription(naMe);
        this.dpi = new ImageSniffer(new ByteArrayInputStream(data)).getDPI();
    }

    public ImageIcon(Object from, String resource) {
        this(from.getClass(), resource);
    }

    public ImageIcon(Class from, String resource) {
        this(from.getName() + '#' + resource, from.getResourceAsStream(resource));
    }

    public ImageIcon(String name, InputStream in) {
        this(name, ImageIcon.read(name, in));
    }

    public Point getResolution() {
        return this.dpi;
    }

    public Dimension2D getSizeInInches() {
        if (this.dpi == null) {
            return null;
        }
        return new Dimension2d((double)this.getIconWidth() / (double)this.dpi.x, (double)this.getIconHeight() / (double)this.dpi.y);
    }

    public Dimension getSizeInPoints(Point dpiTarget) {
        Dimension2D sizeInInches = this.getSizeInInches();
        if (sizeInInches == null) {
            return new Dimension(this.getIconWidth(), this.getIconHeight());
        }
        return new Dimension((int)(sizeInInches.getWidth() * (double)dpiTarget.x), (int)(sizeInInches.getHeight() * (double)dpiTarget.y));
    }

    public ImageIcon paintIcon(Graphics g, int x, int y) {
        super.paintIcon(null, g, x, y);
        return this;
    }

    private static byte[] read(String name, InputStream in) {
        if (in == null) {
            throw new IllegalArgumentException("no stream for " + name);
        }
        try {
            return new ByteArray(in).getBytes();
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("can't read " + name + ": " + ex.getMessage());
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("interrupted while reading " + name);
        }
    }

    public ImageIcon getDisabled(int percentage) {
        GrayFilter filter = new GrayFilter(true, percentage);
        FilteredImageSource prod = new FilteredImageSource(this.getImage().getSource(), filter);
        Image grayImage = Toolkit.getDefaultToolkit().createImage(prod);
        ImageIcon result = new ImageIcon(grayImage);
        result.dpi = this.dpi;
        result.setDescription(this.getDescription());
        return result;
    }

    public ImageIcon getOverLayed(ImageIcon overlay) {
        ImageIcon result = (ImageIcon)this.overlays.get(overlay);
        if (result != null) {
            return result;
        }
        int height = Math.max(this.getIconHeight(), overlay.getIconHeight());
        int width = Math.max(this.getIconWidth(), overlay.getIconWidth());
        Image image1 = this.getImage();
        Image image2 = overlay.getImage();
        BufferedImage composite = new BufferedImage(width, height, 2);
        Graphics2D g = composite.createGraphics();
        g.setClip(0, 0, width, height);
        g.drawImage(image1, 0, 0, null);
        g.drawImage(image2, 0, 0, null);
        g.dispose();
        result = new ImageIcon(composite);
        result.dpi = this.dpi;
        result.setDescription(this.getDescription());
        this.overlays.put(overlay, result);
        return result;
    }
}

