/*
 * Decompiled with CFR 0.152.
 */
package genj.util.swing;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;

public class HeadlessLabel
extends JComponent {
    private int ICON_TEXT_GAP = 4;
    private String txt = "";
    private View view;
    private Icon icon;
    private float iconLocation = 0.0f;
    private boolean isOpaque = false;
    private Font font;

    public HeadlessLabel() {
    }

    public HeadlessLabel(Font font) {
        this.setFont(font);
    }

    public void setFont(Font set) {
        this.font = set;
    }

    public Font getFont() {
        if (this.font == null) {
            this.font = super.getFont();
        }
        return this.font;
    }

    public View setHTML(String set) {
        return this.setView(BasicHTML.createHTMLView(this, set));
    }

    public View setView(View set) {
        this.view = set;
        this.txt = "";
        return set;
    }

    public void setText(String set) {
        this.view = null;
        this.txt = set != null ? set : "";
    }

    public void setIcon(Icon icOn) {
        this.icon = icOn;
    }

    public boolean isOpaque() {
        return this.isOpaque;
    }

    public void setOpaque(boolean set) {
        this.isOpaque = set;
    }

    public void setIconLocation(float set) {
        this.iconLocation = set;
    }

    public Dimension getPreferredSize() {
        int height;
        int width;
        if (this.view != null) {
            width = (int)this.view.getPreferredSpan(0);
            height = (int)this.view.getPreferredSpan(1);
        } else {
            FontMetrics fm = this.getFontMetrics(this.getFont());
            width = fm.stringWidth(this.txt);
            height = fm.getHeight();
        }
        if (this.icon != null) {
            width += this.icon.getIconWidth();
            height = Math.max(height, this.icon.getIconHeight());
        }
        if ((this.view != null || this.txt.length() > 0) && this.icon != null) {
            width += this.ICON_TEXT_GAP;
        }
        return new Dimension(width, height);
    }

    public void paint(Graphics g) {
        Rectangle bounds = this.getBounds();
        bounds.x = 0;
        bounds.y = 0;
        if (this.isOpaque) {
            g.setColor(this.getBackground());
            g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
        }
        if (this.icon != null) {
            int w = this.icon.getIconWidth();
            int h = this.icon.getIconHeight();
            this.icon.paintIcon(null, g, 0, (int)(this.iconLocation * (float)(bounds.height - h)));
            bounds.x += w + this.ICON_TEXT_GAP;
            bounds.width -= w + this.ICON_TEXT_GAP;
        }
        g.setColor(this.getForeground());
        if (this.view != null) {
            this.view.setSize(bounds.width, bounds.height);
            this.view.paint(g, bounds);
        } else {
            Font font = this.getFont();
            g.setFont(font);
            g.drawString(this.txt, bounds.x, this.getFontMetrics(font).getMaxAscent());
        }
    }

    public float getAlignmentY() {
        return 0.0f;
    }

    public void validate() {
    }

    public void revalidate() {
    }

    public void repaint(long tm, int x, int y, int width, int height) {
    }

    public void repaint(Rectangle r) {
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }
}

