/*
 * Decompiled with CFR 0.152.
 */
package genj.util.swing;

import genj.util.EnvironmentChecker;
import genj.util.swing.Action2;
import genj.util.swing.ButtonHelper;
import genj.util.swing.FileChooser;
import genj.util.swing.TextFieldWidget;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;

public class FileChooserWidget
extends JPanel {
    private TextFieldWidget text = new TextFieldWidget("", 12);
    private Choose choose = new Choose();
    private String extensions;
    public static final String EXECUTABLES = "exe, bin, sh, cmd, bat";
    private String directory = EnvironmentChecker.getProperty((Object)this, "user.home", ".", "file chooser directory");
    private JComponent accessory;
    private List listeners = new ArrayList();
    private ActionListener actionProxy = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            FileChooserWidget.this.fireActionEvent();
        }
    };

    public FileChooserWidget() {
        this((String)null);
    }

    public void setEnabled(boolean set) {
        super.setEnabled(set);
        this.choose.setEnabled(set);
        this.text.setEnabled(set);
    }

    public FileChooserWidget(String extensions) {
        super(new BorderLayout());
        this.add("Center", this.text);
        this.add("East", new ButtonHelper().setInsets(0).create(this.choose));
        this.extensions = extensions;
    }

    private void fireActionEvent() {
        ActionEvent e = new ActionEvent(this, 0, "");
        ActionListener[] ls = this.listeners.toArray(new ActionListener[this.listeners.size()]);
        for (int i = 0; i < ls.length; ++i) {
            ls[i].actionPerformed(e);
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.text.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.text.removeChangeListener(l);
    }

    public void addActionListener(ActionListener l) {
        if (this.listeners.isEmpty()) {
            this.text.addActionListener(this.actionProxy);
        }
        this.listeners.add(l);
    }

    public void removeActionListener(ActionListener l) {
        this.listeners.remove(l);
        if (this.listeners.isEmpty()) {
            this.text.removeActionListener(this.actionProxy);
        }
    }

    public void setDirectory(String set) {
        this.directory = set;
    }

    public String getDirectory() {
        return this.directory;
    }

    public boolean isEmpty() {
        return this.text.isEmpty();
    }

    public void setTemplate(boolean set) {
        this.text.setTemplate(set);
    }

    public void setFile(String file) {
        this.text.setText(file != null ? file : "");
    }

    public void setFile(File file) {
        this.text.setText(file != null ? file.getPath() : "");
    }

    public File getFile() {
        return new File(this.text.getText());
    }

    public void setAccessory(JComponent set) {
        this.accessory = set;
    }

    public boolean requestFocusInWindow() {
        return this.text.requestFocusInWindow();
    }

    private class Choose
    extends Action2 {
        private Choose() {
            this.setText("...");
            this.setTarget(FileChooserWidget.this);
        }

        protected void execute() {
            FileChooser fc = new FileChooser(FileChooserWidget.this, FileChooserWidget.this.getName(), Action2.TXT_OK, FileChooserWidget.this.extensions, FileChooserWidget.this.directory);
            fc.setAccessory(FileChooserWidget.this.accessory);
            fc.showDialog();
            File file = fc.getSelectedFile();
            if (file != null) {
                FileChooserWidget.this.setFile(file);
                FileChooserWidget.this.directory = file.getParent();
                FileChooserWidget.this.fireActionEvent();
            }
        }
    }
}

