/*
 * Decompiled with CFR 0.152.
 */
package genj.util.swing;

import genj.util.WordBuffer;
import java.io.File;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class FileChooser
extends JFileChooser {
    private String command;
    private JComponent owner;

    public FileChooser(JComponent owner, String title, String command, String extensions, String baseDir) {
        super(baseDir != null ? baseDir : ".");
        this.setDialogTitle(title);
        this.owner = owner;
        this.command = command;
        if (extensions != null) {
            Filter filter = new Filter(extensions);
            this.addChoosableFileFilter(filter);
            this.setFileFilter(filter);
        }
    }

    public int showDialog() {
        int rc = this.showDialog(this.owner, this.command);
        if (rc != 0) {
            this.setSelectedFile(null);
        }
        return rc;
    }

    private class Filter
    extends FileFilter {
        private String[] exts;
        private String descr;

        private Filter(String extensions) {
            StringTokenizer tokens = new StringTokenizer(extensions, ",");
            this.exts = new String[tokens.countTokens()];
            if (this.exts.length == 0) {
                throw new IllegalArgumentException("extensions required");
            }
            WordBuffer buf = new WordBuffer(",");
            for (int i = 0; i < this.exts.length; ++i) {
                this.exts[i] = tokens.nextToken().toLowerCase().trim();
                buf.append("*." + this.exts[i]);
            }
            this.descr = buf.toString();
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String name = f.getName();
            int dot = name.lastIndexOf(46);
            if (dot < 0) {
                return false;
            }
            String ext = name.substring(dot + 1);
            for (int i = 0; i < this.exts.length; ++i) {
                if (!this.exts[i].equalsIgnoreCase(ext)) continue;
                return true;
            }
            return false;
        }

        public String getDescription() {
            return this.descr;
        }
    }
}

