/*
 * Decompiled with CFR 0.152.
 */
package genj.util.swing;

import genj.gedcom.GedcomException;
import genj.gedcom.MetaProperty;
import genj.gedcom.time.Calendar;
import genj.gedcom.time.PointInTime;
import genj.util.ChangeSupport;
import genj.util.WordBuffer;
import genj.util.swing.Action2;
import genj.util.swing.ChoiceWidget;
import genj.util.swing.NestedBlockLayout;
import genj.util.swing.PopupWidget;
import genj.util.swing.TextFieldWidget;
import genj.window.WindowManager;
import java.awt.Component;
import java.awt.Dimension;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;

public class DateWidget
extends JPanel {
    private static final NestedBlockLayout LAYOUT = new NestedBlockLayout("<row><x/><x/><x/><x/></row>");
    private PopupWidget widgetCalendar;
    private TextFieldWidget widgetDay;
    private TextFieldWidget widgetYear;
    private ChoiceWidget widgetMonth;
    private Calendar calendar;
    private ChangeSupport changeSupport = new ChangeSupport(this){

        protected void fireChangeEvent(Object source) {
            DateWidget.this.updateStatus();
            super.fireChangeEvent(source);
        }
    };

    public DateWidget() {
        this(new PointInTime());
    }

    public DateWidget(PointInTime pit) {
        String format;
        this.calendar = pit.getCalendar();
        ArrayList<SwitchCalendar> switches = new ArrayList<SwitchCalendar>(PointInTime.CALENDARS.length + 1);
        for (int s = 0; s < PointInTime.CALENDARS.length; ++s) {
            switches.add(new SwitchCalendar(PointInTime.CALENDARS[s]));
        }
        this.widgetCalendar = new PopupWidget();
        this.widgetCalendar.setActions(switches);
        this.widgetYear = new TextFieldWidget("", 6);
        this.widgetYear.setSelectAllOnFocus(true);
        this.widgetYear.addChangeListener(this.changeSupport);
        this.widgetMonth = new ChoiceWidget(new Object[0], null);
        this.widgetMonth.setIgnoreCase(true);
        this.widgetMonth.setSelectAllOnFocus(true);
        this.widgetMonth.addChangeListener(this.changeSupport);
        this.widgetDay = new TextFieldWidget("", 3);
        this.widgetDay.setSelectAllOnFocus(true);
        this.widgetDay.addChangeListener(this.changeSupport);
        this.setLayout(LAYOUT.copy());
        this.add(this.widgetCalendar);
        switch (new SimpleDateFormat().toPattern().charAt(0)) {
            case 'M': 
            case 'm': {
                format = "mmm/dd/yyyy";
                this.add(this.widgetMonth);
                this.add(this.widgetDay);
                this.add(this.widgetYear);
                break;
            }
            case 'D': 
            case 'd': {
                format = "dd.mmm.yyyy";
                this.add(this.widgetDay);
                this.add(this.widgetMonth);
                this.add(this.widgetYear);
                break;
            }
            default: {
                format = "yyyy-mmm-dd";
                this.add(this.widgetYear);
                this.add(this.widgetMonth);
                this.add(this.widgetDay);
            }
        }
        this.widgetDay.setToolTipText(format);
        this.widgetMonth.setToolTipText(format);
        this.widgetYear.setToolTipText(format);
        this.setValue(pit);
        this.updateStatus();
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    public void setValue(PointInTime pit) {
        this.calendar = pit.getCalendar();
        this.widgetCalendar.setToolTipText(this.calendar.getName());
        this.widgetYear.setText(this.calendar.getDisplayYear(pit.getYear()));
        this.widgetDay.setText(this.calendar.getDay(pit.getDay()));
        String[] months = this.calendar.getMonths(true);
        this.widgetMonth.setValues(Arrays.asList(months));
        try {
            this.widgetMonth.setSelectedItem(null);
            this.widgetMonth.setSelectedItem(months[pit.getMonth()]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        this.updateStatus();
        this.getComponent(1).requestFocusInWindow();
    }

    public PointInTime getValue() {
        int y;
        int m;
        int d;
        int u;
        block11: {
            String month;
            String year;
            d = u = Integer.MAX_VALUE;
            m = u;
            y = u;
            String day = this.widgetDay.getText().trim();
            if (day.length() > 0) {
                try {
                    d = Integer.parseInt(day) - 1;
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            if ((year = this.widgetYear.getText().trim()).length() > 0) {
                try {
                    y = this.calendar.getYear(year);
                }
                catch (GedcomException e) {
                    return null;
                }
            }
            if ((month = this.widgetMonth.getText()).length() > 0) {
                try {
                    m = Integer.parseInt(month) - 1;
                }
                catch (NumberFormatException e) {
                    String[] months = this.calendar.getMonths(true);
                    for (m = 0; m < months.length && !month.equalsIgnoreCase(months[m]); ++m) {
                    }
                    if (m != months.length) break block11;
                    return null;
                }
            }
        }
        PointInTime result = new PointInTime(d, m, y, this.calendar);
        if (d == u && m == u && y == u || result.isValid()) {
            return result;
        }
        return null;
    }

    private void updateStatus() {
        PointInTime value = this.getValue();
        if (value == null) {
            this.widgetCalendar.setEnabled(false);
            this.widgetCalendar.setIcon(MetaProperty.IMG_ERROR);
        } else {
            this.widgetCalendar.setEnabled(true);
            this.widgetCalendar.setIcon(this.calendar.getImage());
        }
    }

    public Dimension getMaximumSize() {
        return new Dimension(super.getMaximumSize().width, super.getPreferredSize().height);
    }

    public void requestFocus() {
        this.getComponent(1).requestFocus();
    }

    public boolean requestFocusInWindow() {
        return this.getComponent(1).requestFocusInWindow();
    }

    private class SwitchCalendar
    extends Action2 {
        private Calendar newCalendar;

        private SwitchCalendar(Calendar cal) {
            this.newCalendar = cal;
            this.setImage(this.newCalendar.getImage());
        }

        public String getText() {
            WordBuffer result = new WordBuffer();
            result.append(this.newCalendar.getName());
            result.setFiller(" - ");
            try {
                PointInTime pit = DateWidget.this.getValue().getPointInTime(this.newCalendar);
                result.append(pit.getDayOfWeek(true));
                result.append(pit);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return result.toString();
        }

        protected void execute() {
            PointInTime pit = DateWidget.this.getValue();
            if (pit != null) {
                try {
                    pit.set(this.newCalendar);
                }
                catch (GedcomException e) {
                    WindowManager wm = WindowManager.getInstance(DateWidget.this);
                    if (wm == null) {
                        Logger.getLogger("genj.util.swing").info(e.getMessage());
                    } else {
                        Action[] actions = new Action[]{Action2.ok(), new Action2(Calendar.TXT_CALENDAR_RESET)};
                        int rc = wm.openDialog(null, Calendar.TXT_CALENDAR_SWITCH, 0, e.getMessage(), actions, (Component)DateWidget.this);
                        if (rc == 0) {
                            return;
                        }
                    }
                    pit = new PointInTime(this.newCalendar);
                }
                DateWidget.this.setValue(pit);
            }
            DateWidget.this.updateStatus();
        }
    }
}

