/*
 * Decompiled with CFR 0.152.
 */
package genj.util.swing;

import genj.util.ChangeSupport;
import genj.util.EnvironmentChecker;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ChoiceWidget
extends JComboBox {
    private static final boolean IS_JAVA_15 = EnvironmentChecker.isJava15(null);
    private boolean blockAutoComplete = false;
    private Model model = new Model();
    private boolean isIgnoreCase = false;
    private ChangeSupport changeSupport = new ChangeSupport(this);
    private AutoCompleteSupport autoComplete;

    public ChoiceWidget() {
        this(new Object[0], null);
    }

    public ChoiceWidget(List values) {
        this(values.toArray(), null);
    }

    public ChoiceWidget(Object[] values, Object selection) {
        this.setEditable(true);
        this.setMaximumRowCount(8);
        this.setModel(this.model);
        this.model.setValues(values);
        this.setAlignmentX(0.0f);
        this.setSelectedItem(selection);
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    public void setValues(List values) {
        this.setValues(values.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValues(Object[] set) {
        try {
            this.blockAutoComplete = true;
            this.model.setValues(set);
        }
        finally {
            this.blockAutoComplete = false;
        }
    }

    public Dimension getPreferredSize() {
        Dimension result = super.getPreferredSize();
        result.width = Math.min(128, result.width);
        return result;
    }

    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, super.getPreferredSize().height);
    }

    public void setSelectAllOnFocus(boolean set) {
    }

    public String getText() {
        if (this.isEditable()) {
            return this.getEditor().getItem().toString();
        }
        return super.getSelectedItem().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(String text) {
        if (!this.isEditable) {
            throw new IllegalArgumentException("setText && !isEditable n/a");
        }
        this.model.setSelectedItem(null);
        try {
            this.blockAutoComplete = true;
            this.getTextEditor().setText(text);
        }
        finally {
            this.blockAutoComplete = false;
        }
    }

    public JTextField getTextEditor() {
        return (JTextField)this.getEditor().getEditorComponent();
    }

    public void setIgnoreCase(boolean set) {
        this.isIgnoreCase = set;
    }

    public void setPopupVisible(boolean v) {
        super.setPopupVisible(v);
        if (v) {
            String pre = this.getText();
            for (int i = 0; i < this.getItemCount(); ++i) {
                String item = this.getItemAt(i).toString();
                if (!item.regionMatches(true, 0, pre, 0, pre.length())) continue;
                this.setSelectedIndex(i);
                break;
            }
        }
    }

    public void requestFocus() {
        if (this.isEditable()) {
            this.getEditor().getEditorComponent().requestFocus();
        } else {
            super.requestFocus();
        }
    }

    public boolean requestFocusInWindow() {
        if (this.isEditable()) {
            return this.getEditor().getEditorComponent().requestFocusInWindow();
        }
        return super.requestFocusInWindow();
    }

    public void setEditor(ComboBoxEditor set) {
        if (!(set.getEditorComponent() instanceof JTextField)) {
            throw new IllegalArgumentException("Only JTextEditor editor components are allowed");
        }
        super.setEditor(set);
        if (this.autoComplete == null) {
            this.autoComplete = new AutoCompleteSupport();
        }
        this.autoComplete.attach(this.getTextEditor());
    }

    public void addActionListener(ActionListener l) {
        this.getEditor().addActionListener(l);
    }

    public void removeActionListener(ActionListener l) {
        this.getEditor().removeActionListener(l);
    }

    private class Model
    extends AbstractListModel
    implements ComboBoxModel {
        private Object[] values = new Object[0];
        private Object selection = null;

        private Model() {
        }

        private void setValues(Object[] set) {
            this.selection = null;
            if (this.values.length > 0) {
                this.fireIntervalRemoved(this, 0, this.values.length - 1);
            }
            this.values = set;
            if (this.values.length > 0) {
                this.fireIntervalAdded(this, 0, this.values.length - 1);
            }
        }

        public Object getSelectedItem() {
            return this.selection;
        }

        private String setSelectedPrefix(String prefix) {
            if (ChoiceWidget.this.isIgnoreCase) {
                prefix = prefix.toLowerCase();
            }
            for (int i = 0; i < this.values.length; ++i) {
                String value = this.values[i].toString();
                if (!(ChoiceWidget.this.isIgnoreCase ? value.toLowerCase() : value).startsWith(prefix)) continue;
                this.setSelectedItem(value);
                return value;
            }
            return "";
        }

        public void setSelectedItem(Object seLection) {
            this.selection = seLection;
            ChoiceWidget.this.blockAutoComplete = true;
            ChoiceWidget.this.getEditor().setItem(this.selection);
            ChoiceWidget.this.blockAutoComplete = false;
            ChoiceWidget.this.fireItemStateChanged(new ItemEvent(ChoiceWidget.this, 701, this.selection, 1));
            this.fireContentsChanged(this, -1, -1);
        }

        public Object getElementAt(int index) {
            return this.values[index];
        }

        public int getSize() {
            return this.values.length;
        }
    }

    private class AutoCompleteSupport
    extends KeyAdapter
    implements DocumentListener,
    ActionListener,
    FocusListener {
        private JTextField text;
        private Timer timer = new Timer(250, this);

        private AutoCompleteSupport() {
            this.timer.setRepeats(false);
        }

        private void attach(JTextField set) {
            if (this.text != null) {
                this.text.getDocument().removeDocumentListener(this);
                this.text.removeFocusListener(this);
                this.text.removeKeyListener(this);
            }
            this.text = set;
            this.text.getDocument().addDocumentListener(this);
            this.text.addFocusListener(this);
            this.text.addKeyListener(this);
        }

        public void removeUpdate(DocumentEvent e) {
            ChoiceWidget.this.changeSupport.fireChangeEvent();
            if (!ChoiceWidget.this.blockAutoComplete && ChoiceWidget.this.isEditable()) {
                this.timer.start();
            }
        }

        public void changedUpdate(DocumentEvent e) {
            ChoiceWidget.this.changeSupport.fireChangeEvent();
            if (!ChoiceWidget.this.blockAutoComplete && ChoiceWidget.this.isEditable()) {
                this.timer.start();
            }
        }

        public void insertUpdate(DocumentEvent e) {
            ChoiceWidget.this.changeSupport.fireChangeEvent();
            if (!ChoiceWidget.this.blockAutoComplete && ChoiceWidget.this.isEditable()) {
                this.timer.start();
            }
        }

        public void actionPerformed(ActionEvent e) {
            String prefix = this.text.getText();
            if (prefix.length() == 0) {
                return;
            }
            int caretPos = this.text.getCaretPosition();
            String match = ChoiceWidget.this.model.setSelectedPrefix(prefix);
            if (match.length() == 0) {
                return;
            }
            ChoiceWidget.this.blockAutoComplete = true;
            this.text.setText(prefix);
            ChoiceWidget.this.blockAutoComplete = false;
            this.text.setCaretPosition(caretPos);
            if (match.length() >= prefix.length() && ChoiceWidget.this.isShowing()) {
                ChoiceWidget.this.showPopup();
            }
        }

        public void focusGained(FocusEvent e) {
            if (this.text.getDocument() != null) {
                this.text.setCaretPosition(this.text.getDocument().getLength());
                this.text.moveCaretPosition(0);
            }
        }

        public void focusLost(FocusEvent e) {
            if (IS_JAVA_15) {
                ChoiceWidget.this.setPopupVisible(false);
            }
        }

        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10 && ChoiceWidget.this.isPopupVisible()) {
                ChoiceWidget.this.model.setSelectedItem(ChoiceWidget.this.model.getSelectedItem());
                ChoiceWidget.this.setPopupVisible(false);
            }
        }
    }
}

