/*
 * Decompiled with CFR 0.152.
 */
package genj.util.swing;

import genj.util.swing.Action2;
import genj.util.swing.ImageIcon;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

public class ButtonHelper {
    private Class buttonType = JButton.class;
    private Insets insets = null;
    private JComponent container = null;
    private ButtonGroup group = null;
    private int fontSize = -1;

    public ButtonHelper setButtonType(Class set) {
        this.buttonType = set;
        return this;
    }

    public ButtonHelper setInsets(Insets set) {
        this.insets = set;
        return this;
    }

    public ButtonHelper setInsets(int val) {
        this.insets = new Insets(val, val, val, val);
        return this;
    }

    public ButtonHelper setContainer(JComponent set) {
        this.container = set;
        return this;
    }

    public ButtonHelper setFontSize(int set) {
        this.fontSize = set;
        return this;
    }

    public ButtonGroup createGroup() {
        this.group = new ButtonGroup();
        return this.group;
    }

    public AbstractButton create(Action action, ImageIcon toggle, boolean state) {
        JToggleButton result = (JToggleButton)this.create(action, JToggleButton.class);
        result.setSelectedIcon(toggle);
        result.setSelected(state);
        return result;
    }

    public AbstractButton create(Action action) {
        return this.create(action, this.buttonType);
    }

    private AbstractButton create(Action action, Class type) {
        AbstractButton result;
        if (this.container instanceof JToolBar) {
            action.putValue("MnemonicKey", null);
        }
        if ((result = this.createButton(type)) instanceof JButton) {
            result.setVerticalTextPosition(3);
            result.setHorizontalTextPosition(0);
        }
        result.setAction(action);
        if (this.insets != null) {
            result.setMargin(this.insets);
        }
        if (this.fontSize > 0) {
            Font f = result.getFont();
            result.setFont(new Font(f.getName(), f.getStyle(), this.fontSize));
        }
        if (this.group != null) {
            this.group.add(result);
        }
        if (this.container != null) {
            if (action instanceof Action2) {
                ((Action2)action).setTarget(this.container);
            }
            this.container.add(result);
            if (this.container instanceof JToolBar) {
                result.setMaximumSize(new Dimension(128, 128));
            }
        }
        return result;
    }

    private AbstractButton createButton(Class type) {
        try {
            return (AbstractButton)type.newInstance();
        }
        catch (Throwable t) {
            throw new IllegalStateException("Couldn't create AbstractButton for " + this.buttonType);
        }
    }
}

