/*
 * Decompiled with CFR 0.152.
 */
package genj.util.swing;

import genj.util.MnemonicAndText;
import genj.util.Resources;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class Action2
extends AbstractAction
implements Runnable,
Cloneable {
    private static final String KEY_TEXT = "Name";
    private static final String KEY_OLDTEXT = "Name.old";
    private static final String KEY_SHORT_TEXT = "shortname";
    private static final String KEY_TIP = "ShortDescription";
    private static final String KEY_ENABLED = "enabled";
    private static final String KEY_MNEMONIC = "MnemonicKey";
    private static final String KEY_ICON = "SmallIcon";
    private static final Logger LOG = Logger.getLogger("genj.actions");
    public static final Action2 NOOP = new ActionNOOP();
    public static final int ASYNC_NOT_APPLICABLE = 0;
    public static final int ASYNC_SAME_INSTANCE = 1;
    public static final int ASYNC_NEW_INSTANCE = 2;
    private Component target;
    private KeyStroke accelerator;
    private int async = 0;
    private Thread thread;
    private Object threadLock = new Object();
    public static final String TXT_YES = UIManager.getString("OptionPane.yesButtonText");
    public static final String TXT_NO = UIManager.getString("OptionPane.noButtonText");
    public static final String TXT_OK = UIManager.getString("OptionPane.okButtonText");
    public static final String TXT_CANCEL = UIManager.getString("OptionPane.cancelButtonText");

    public Action2() {
    }

    public Action2(Resources resources, String text) {
        this(resources.getString(text));
    }

    public Action2(String text) {
        this.setText(text);
    }

    public Action2(String text, boolean enabled) {
        this(text);
        this.setEnabled(enabled);
    }

    public final void actionPerformed(ActionEvent e) {
        this.trigger();
    }

    public final void run() {
        this.trigger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean trigger() {
        boolean preExecuteResult;
        block16: {
            if (!this.isEnabled()) {
                throw new IllegalArgumentException("trigger() while !isEnabled");
            }
            if (this.async == 2) {
                try {
                    Action2 ad = (Action2)this.clone();
                    ad.setAsync(1);
                    return ad.trigger();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    this.handleThrowable("trigger", new RuntimeException("Couldn't clone instance of " + this.getClass().getName() + " for ASYNC_NEW_INSTANCE"));
                    return false;
                }
            }
            try {
                preExecuteResult = this.preExecute();
            }
            catch (Throwable t) {
                this.handleThrowable("preExecute", t);
                preExecuteResult = false;
            }
            if (preExecuteResult) {
                try {
                    if (this.async != 0) {
                        Object t = this.threadLock;
                        synchronized (t) {
                            this.getThread().start();
                            break block16;
                        }
                    }
                    this.execute();
                }
                catch (Throwable t) {
                    this.handleThrowable("execute(sync)", t);
                    preExecuteResult = false;
                }
            }
        }
        if (this.async == 0 || !preExecuteResult) {
            try {
                this.postExecute(preExecuteResult);
            }
            catch (Throwable t) {
                this.handleThrowable("postExecute", t);
            }
        }
        return preExecuteResult;
    }

    protected void setAsync(int set) {
        this.async = set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(boolean wait) {
        Thread cancel;
        Object object = this.threadLock;
        synchronized (object) {
            if (this.thread == null || !this.thread.isAlive()) {
                return;
            }
            cancel = this.thread;
            cancel.interrupt();
        }
        if (wait) {
            try {
                cancel.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Thread getThread() {
        if (this.async != 1) {
            return null;
        }
        Object object = this.threadLock;
        synchronized (object) {
            if (this.thread == null) {
                this.thread = new Thread(new CallAsyncExecute());
                this.thread.setPriority(5);
            }
            return this.thread;
        }
    }

    protected boolean preExecute() {
        return true;
    }

    protected void execute() {
    }

    protected final void sync() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.syncExecute();
        } else {
            SwingUtilities.invokeLater(new CallSyncExecute());
        }
    }

    protected void syncExecute() {
    }

    protected void postExecute(boolean preExecuteResult) {
    }

    protected void handleThrowable(String phase, Throwable t) {
        LogRecord record = new LogRecord(Level.WARNING, "Action failed in " + phase);
        record.setThrown(t);
        record.setSourceClassName(this.getClass().getName());
        record.setSourceMethodName(phase);
        LOG.log(record);
    }

    public Object getValue(String key) {
        if (KEY_TEXT.equals(key)) {
            return this.getText();
        }
        if (KEY_ICON.equals(key)) {
            return this.getImage();
        }
        if (KEY_TIP.equals(key)) {
            return this.getTip();
        }
        return super.getValue(key);
    }

    public Action2 setTarget(Component t) {
        this.target = t;
        return this;
    }

    public Component getTarget() {
        return this.target;
    }

    public Action2 setAccelerator(String s) {
        this.accelerator = KeyStroke.getKeyStroke(s);
        return this;
    }

    public Action2 setAccelerator(KeyStroke accelerator) {
        this.accelerator = accelerator;
        return this;
    }

    public Action2 setImage(Icon icon) {
        super.putValue(KEY_ICON, icon);
        return this;
    }

    public Action2 restoreText() {
        this.setText((String)super.getValue(KEY_OLDTEXT));
        return this;
    }

    public Action2 setText(String txt) {
        return this.setText(null, txt);
    }

    public Action2 setText(Resources resources, String txt) {
        if (resources != null) {
            txt = resources.getString(txt);
        }
        super.putValue(KEY_OLDTEXT, this.getText());
        if (txt != null && txt.length() > 0) {
            MnemonicAndText mat = new MnemonicAndText(txt);
            txt = mat.getText();
            this.setMnemonic(mat.getMnemonic());
        }
        super.putValue(KEY_TEXT, txt);
        return this;
    }

    public Action2 setMnemonic(char c) {
        super.putValue(KEY_MNEMONIC, c == '\u0000' ? null : new Integer(c));
        return this;
    }

    public String getText() {
        return (String)super.getValue(KEY_TEXT);
    }

    public Action2 setTip(String tip) {
        return this.setTip(null, tip);
    }

    public Action2 setTip(Resources resources, String tip) {
        if (resources != null) {
            tip = resources.getString(tip);
        }
        super.putValue(KEY_TIP, tip);
        return this;
    }

    public String getTip() {
        return (String)super.getValue(KEY_TIP);
    }

    public Icon getImage() {
        return (Icon)super.getValue(KEY_ICON);
    }

    public KeyStroke getAccelerator() {
        return this.accelerator;
    }

    public void install(JComponent into, int condition) {
        if (this.accelerator == null) {
            return;
        }
        InputMap inputs = into.getInputMap(condition);
        inputs.put(this.accelerator, this);
        into.getActionMap().put(this, this);
    }

    public static Action yes() {
        return new Action2(TXT_YES);
    }

    public static Action no() {
        return new Action2(TXT_NO);
    }

    public static Action ok() {
        return new Action2(TXT_OK);
    }

    public static Action cancel() {
        return new Action2(TXT_CANCEL);
    }

    public static Action[] yesNo() {
        return new Action[]{Action2.yes(), Action2.no()};
    }

    public static Action[] yesNoCancel() {
        return new Action[]{Action2.yes(), Action2.no(), Action2.cancel()};
    }

    public static Action[] okCancel() {
        return new Action[]{Action2.ok(), Action2.cancel()};
    }

    public static Action[] okAnd(Action action) {
        return new Action[]{Action2.ok(), action};
    }

    public static Action[] okOnly() {
        return new Action[]{Action2.ok()};
    }

    public static Action[] cancelOnly() {
        return new Action[]{Action2.cancel()};
    }

    public static class Group
    extends ArrayList {
        private String name;

        public Group(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    private static class ActionNOOP
    extends Action2 {
        private ActionNOOP() {
        }

        protected void execute() {
        }
    }

    private class CallSyncHandleThrowable
    implements Runnable {
        private Throwable t;

        protected CallSyncHandleThrowable(Throwable set) {
            this.t = set;
        }

        public void run() {
            try {
                Action2.this.handleThrowable("execute(async)", this.t);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private class CallSyncExecute
    implements Runnable {
        private CallSyncExecute() {
        }

        public void run() {
            try {
                Action2.this.syncExecute();
            }
            catch (Throwable t) {
                Action2.this.handleThrowable("syncExecute", t);
            }
        }
    }

    private class CallSyncPostExecute
    implements Runnable {
        private CallSyncPostExecute() {
        }

        public void run() {
            try {
                Action2.this.postExecute(true);
            }
            catch (Throwable t) {
                Action2.this.handleThrowable("postExecute", t);
            }
        }
    }

    private class CallAsyncExecute
    implements Runnable {
        private CallAsyncExecute() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Throwable thrown = null;
            try {
                Action2.this.execute();
            }
            catch (Throwable t) {
                thrown = t;
            }
            Object object = Action2.this.threadLock;
            synchronized (object) {
                Action2.this.thread = null;
            }
            if (thrown != null) {
                SwingUtilities.invokeLater(new CallSyncHandleThrowable(thrown));
            }
            SwingUtilities.invokeLater(new CallSyncPostExecute());
        }
    }
}

