/*
 * Decompiled with CFR 0.152.
 */
package genj.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;

public class Resources {
    private static Map instances = new HashMap();
    private Map key2string;
    private List keys;
    private String pkg;
    private WeakHashMap msgFormats = new WeakHashMap();

    public Resources(InputStream in) {
        this.key2string = new HashMap();
        this.keys = new ArrayList(1000);
        try {
            this.load(in);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static Resources get(Object packgeMember) {
        return Resources.get(Resources.calcPackage(packgeMember));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Resources get(String packge) {
        Map map = instances;
        synchronized (map) {
            Resources result = (Resources)instances.get(packge);
            if (result == null) {
                result = new Resources(packge);
                instances.put(packge, result);
            }
            return result;
        }
    }

    private static String calcPackage(Object object) {
        Class<?> clazz = object instanceof Class ? (Class<?>)object : object.getClass();
        String name = clazz.getName();
        int last = name.lastIndexOf(46);
        return last < 0 ? "" : name.substring(0, last);
    }

    private String calcFile(String pkg, String lang, String country) {
        String file = '/' + pkg.replace('.', '/') + "/resources";
        if (lang != null) {
            file = file + '_' + lang;
            if (country != null) {
                file = file + '_' + country;
            }
        }
        return file + ".properties";
    }

    private Resources(String pkg) {
        this.pkg = pkg;
    }

    public void load(InputStream in) throws IOException {
        Resources.load(in, this.keys, this.key2string);
    }

    private static String trimLeft(String s) {
        int pos;
        int len = s.length();
        for (pos = 0; pos < len && Character.isWhitespace(s.charAt(pos)); ++pos) {
        }
        return pos == 0 ? s : s.substring(pos);
    }

    private static void load(InputStream in, List keys, Map key2string) throws IOException {
        if (in == null) {
            throw new IOException("can't load resources from null");
        }
        try {
            String line;
            BufferedReader lines = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            String last = null;
            while ((line = lines.readLine()) != null) {
                String key;
                int i;
                String trimmed = Resources.trimLeft(line);
                if (trimmed.length() == 0) continue;
                if (last != null) {
                    if (trimmed.charAt(0) == '+') {
                        key2string.put(last, key2string.get(last) + "\n" + Resources.breakify(trimmed.substring(1)));
                        continue;
                    }
                    if (trimmed.charAt(0) == '&') {
                        key2string.put(last, key2string.get(last) + Resources.breakify(trimmed.substring(1)));
                        continue;
                    }
                    if (line.charAt(0) == ' ') {
                        String appendto = (String)key2string.get(last);
                        if (!appendto.endsWith(" ") && !appendto.endsWith("\n")) {
                            appendto = appendto + " ";
                        }
                        key2string.put(last, appendto + Resources.breakify(trimmed));
                        continue;
                    }
                }
                if (!Character.isLetter(line.charAt(0)) || (i = trimmed.indexOf(61)) < 0 || (key = trimmed.substring(0, i).trim()).indexOf(32) > 0) continue;
                String val = Resources.trimLeft(trimmed.substring(i + 1));
                keys.add(key);
                key = key.toLowerCase();
                key2string.put(key, Resources.breakify(val));
                last = key;
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new IOException(e.getMessage());
        }
    }

    private static String breakify(String string) {
        int i;
        while ((i = string.indexOf("\\n")) >= 0) {
            string = string.substring(0, i) + '\n' + string.substring(i + 2);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getKey2String() {
        if (this.key2string != null) {
            return this.key2string;
        }
        Resources resources = this;
        synchronized (resources) {
            if (this.key2string != null) {
                return this.key2string;
            }
            Locale locale = Locale.getDefault();
            HashMap tmpKey2Val = new HashMap();
            ArrayList tmpKeys = new ArrayList(100);
            try {
                Resources.load(this.getClass().getResourceAsStream(this.calcFile(this.pkg, null, null)), tmpKeys, tmpKey2Val);
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                Resources.load(this.getClass().getResourceAsStream(this.calcFile(this.pkg, locale.getLanguage(), null)), tmpKeys, tmpKey2Val);
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                Resources.load(this.getClass().getResourceAsStream(this.calcFile(this.pkg, locale.getLanguage(), locale.getCountry())), tmpKeys, tmpKey2Val);
            }
            catch (Throwable t) {
                // empty catch block
            }
            this.key2string = tmpKey2Val;
            this.keys = tmpKeys;
        }
        return this.key2string;
    }

    public boolean contains(String key) {
        return this.getString(key, false) != null;
    }

    public String getString(String key, boolean notNull) {
        String result = (String)this.getKey2String().get(key.toLowerCase());
        if (result == null && notNull) {
            result = key;
        }
        return result;
    }

    public String getString(String key) {
        return this.getString(key, true);
    }

    public String getString(String key, Object substitute) {
        return this.getString(key, new Object[]{substitute});
    }

    public String getString(String key, Object[] substitutes) {
        return this.getString(key, substitutes, true);
    }

    public String getString(String key, Object[] substitutes, boolean notNull) {
        MessageFormat format = (MessageFormat)this.msgFormats.get(key);
        if (format == null) {
            String string = this.getString(key, false);
            if (string == null) {
                return notNull ? key : null;
            }
            format = Resources.getMessageFormat(string);
            this.msgFormats.put(key, format);
        }
        return format.format(substitutes);
    }

    public static MessageFormat getMessageFormat(String pattern) {
        if (pattern.indexOf(39) >= 0) {
            StringBuffer buffer = new StringBuffer(pattern.length() + 8);
            int j = pattern.length();
            for (int i = 0; i < j; ++i) {
                char c = pattern.charAt(i);
                buffer.append(c);
                if (c != '\'') continue;
                buffer.append('\'');
            }
            pattern = buffer.toString();
        }
        return new MessageFormat(pattern);
    }

    public List getKeys() {
        this.getKey2String();
        return this.keys;
    }
}

