/*
 * Decompiled with CFR 0.152.
 */
package genj.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ReferenceSet {
    private Map key2references = new HashMap();
    private int size = 0;

    public Set getReferences(Object key) {
        if (key == null) {
            return Collections.EMPTY_SET;
        }
        Set references = (Set)this.key2references.get(key);
        if (references == null) {
            return Collections.EMPTY_SET;
        }
        return references;
    }

    public int getSize() {
        return this.size;
    }

    public int getSize(Object key) {
        if (key == null) {
            return 0;
        }
        Set references = (Set)this.key2references.get(key);
        if (references == null) {
            return 0;
        }
        return references.size();
    }

    public boolean add(Object key) {
        return this.add(key, null);
    }

    public boolean add(Object key, Object reference) {
        if (key == null) {
            return false;
        }
        HashSet<Object> references = (HashSet<Object>)this.key2references.get(key);
        if (references == null) {
            references = new HashSet<Object>();
            this.key2references.put(key, references);
        }
        if (reference == null) {
            return false;
        }
        if (!references.add(reference)) {
            return false;
        }
        ++this.size;
        return true;
    }

    public boolean remove(Object key, Object reference) {
        if (key == null) {
            return false;
        }
        Set references = (Set)this.key2references.get(key);
        if (references == null) {
            return false;
        }
        if (!references.remove(reference)) {
            return false;
        }
        --this.size;
        if (references.isEmpty()) {
            this.key2references.remove(key);
        }
        return true;
    }

    public List getKeys() {
        return this.getKeys(null);
    }

    public List getKeys(Comparator comparator) {
        ArrayList result = new ArrayList(this.key2references.keySet());
        if (comparator != null) {
            Collections.sort(result, comparator);
        } else {
            Collections.sort(result, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ReferenceSet.this.getSize(o1) - ReferenceSet.this.getSize(o2);
                }
            });
        }
        return result;
    }
}

