/*
 * Decompiled with CFR 0.152.
 */
package genj.util;

import genj.util.Dimension2d;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.geom.Dimension2D;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ImageSniffer {
    private String suffix = null;
    private int read = 0;
    protected Dimension dimension;
    protected Point dpi = new Point(72, 72);

    public ImageSniffer(File file) {
        try {
            FileInputStream in = new FileInputStream(file);
            this.init(in);
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public ImageSniffer(InputStream in) {
        this.init(in);
    }

    private void init(InputStream in) {
        try {
            int tag = (this.read(in) & 0xFF) << 8 | this.read(in) & 0xFF;
            switch (tag) {
                case 18249: {
                    this.sniffGif(in);
                    break;
                }
                case 35152: {
                    this.sniffPng(in);
                    break;
                }
                case 65496: {
                    this.sniffJpg(in);
                    break;
                }
                case 16973: {
                    this.sniffBmp(in);
                    break;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.dpi != null && (this.dpi.x <= 0 || this.dpi.y <= 0)) {
            this.dpi = null;
        }
        if (this.dimension != null && (this.dimension.width < 1 || this.dimension.height < 1)) {
            this.dimension = null;
        }
    }

    public String getSuffix() {
        return this.suffix;
    }

    public Point getDPI() {
        return this.dpi;
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public Dimension2D getDimensionInInches() {
        if (this.dpi == null || this.dimension == null) {
            return null;
        }
        return new Dimension2d((double)this.dimension.width / (double)this.dpi.x, (double)this.dimension.height / (double)this.dpi.y);
    }

    private void sniffGif(InputStream in) throws IOException {
        int F89A = this.string2int("F89a");
        int F87A = this.string2int("F87a");
        int magic = this.sniffIntBigEndian(in);
        if (magic != F89A && magic != F87A) {
            return;
        }
        this.dimension = new Dimension(this.sniffShortLittleEndian(in), this.sniffShortLittleEndian(in));
        this.suffix = "gif";
    }

    private void sniffPng(InputStream in) throws IOException {
        int IHDR = this.string2int("IHDR");
        int IDAT = this.string2int("IDAT");
        int IEND = this.string2int("IEND");
        int PHYS = this.string2int("pHYs");
        if (!this.sniff(in, new byte[]{78, 71, 13, 10, 26, 10})) {
            return;
        }
        int len = this.sniffIntBigEndian(in);
        int type = this.sniffIntBigEndian(in);
        if (IHDR != type) {
            return;
        }
        this.dimension = new Dimension(this.sniffIntBigEndian(in), this.sniffIntBigEndian(in));
        this.skip(len - 8 + 4, in);
        while (true) {
            len = this.sniffIntBigEndian(in);
            type = this.sniffIntBigEndian(in);
            if (IDAT == type || IEND == type) break;
            if (PHYS == type) {
                int x = this.sniffIntBigEndian(in);
                int y = this.sniffIntBigEndian(in);
                if (this.read(in) != 1) break;
                this.dpi = new Point((int)Math.round(2.54 * (double)x / 100.0), (int)Math.round(2.54 * (double)y / 100.0));
                break;
            }
            this.skip(len + 4, in);
        }
        this.suffix = "png";
    }

    private boolean sniffTiff(InputStream in) throws IOException {
        boolean intel;
        int start = this.read;
        switch (this.sniffShortLittleEndian(in)) {
            case 18761: {
                intel = true;
                break;
            }
            case 19789: {
                intel = false;
                break;
            }
            default: {
                return false;
            }
        }
        this.skip(2, in);
        this.skip(this.sniffInt(in, intel) - (this.read - start), in);
        int xres = 0;
        int yres = 0;
        int j = this.sniffShort(in, intel);
        block8: for (int i = 0; i < j; ++i) {
            int tag = this.sniffShort(in, intel);
            int format = this.sniffShort(in, intel);
            int components = this.sniffInt(in, intel);
            int value = this.sniffInt(in, intel);
            switch (tag) {
                case 282: {
                    xres = value;
                    continue block8;
                }
                case 283: {
                    yres = value;
                }
            }
        }
        if (xres < this.read - start || yres < this.read - start) {
            return false;
        }
        if (xres < yres) {
            this.skip(xres - (this.read - start), in);
            xres = this.sniffInt(in, intel) / this.sniffInt(in, intel);
            this.skip(yres - (this.read - start), in);
            yres = this.sniffInt(in, intel) / this.sniffInt(in, intel);
        } else {
            this.skip(yres - (this.read - start), in);
            yres = this.sniffInt(in, intel) / this.sniffInt(in, intel);
            this.skip(xres - (this.read - start), in);
            xres = this.sniffInt(in, intel) / this.sniffInt(in, intel);
        }
        this.dpi = new Point(xres, yres);
        return true;
    }

    private void sniffJpg(InputStream in) throws IOException {
        byte[] JFIF = "JFIF".getBytes();
        byte[] EXIF = "Exif".getBytes();
        block10: while (true) {
            int marker = this.sniffShortBigEndian(in);
            int size = this.sniffShortBigEndian(in) - 2;
            int start = this.read;
            switch (marker) {
                case 65505: {
                    if (!this.sniff(in, EXIF)) break;
                    this.skip(2, in);
                    this.sniffTiff(in);
                    break;
                }
                case 65504: {
                    if (!this.sniff(in, JFIF)) break;
                    this.skip(3, in);
                    switch (this.read(in)) {
                        case 1: {
                            this.dpi = new Point(this.sniffShortBigEndian(in), this.sniffShortBigEndian(in));
                            break;
                        }
                        case 2: {
                            this.dpi = new Point((int)((float)this.sniffShortBigEndian(in) * 2.54f), (int)((float)this.sniffShortBigEndian(in) * 2.54f));
                        }
                    }
                    break;
                }
                case 65472: 
                case 65473: 
                case 65474: 
                case 65475: 
                case 65477: 
                case 65478: 
                case 65479: 
                case 65481: 
                case 65482: 
                case 65483: 
                case 65484: 
                case 65485: 
                case 65486: 
                case 65487: {
                    this.read(in);
                    this.dimension = new Dimension(this.sniffShortBigEndian(in), this.sniffShortBigEndian(in));
                    this.read(in);
                    break;
                }
                case 65497: {
                    break block10;
                }
                default: {
                    if ((marker & 0xFF00) == 65280) break;
                    return;
                }
            }
            this.skip(size - (this.read - start), in);
        }
        this.suffix = "jpg";
    }

    private void sniffBmp(InputStream in) throws IOException {
        this.skip(16, in);
        this.dimension = new Dimension(this.sniffIntLittleEndian(in), this.sniffIntLittleEndian(in));
        this.skip(2, in);
        int bitsPerPixel = this.sniffShortLittleEndian(in);
        if (bitsPerPixel != 1 && bitsPerPixel != 4 && bitsPerPixel != 8 && bitsPerPixel != 16 && bitsPerPixel != 24 && bitsPerPixel != 32) {
            return;
        }
        this.skip(8, in);
        this.dpi = new Point((int)Math.round(2.54 * (double)this.sniffIntLittleEndian(in) / 100.0), (int)Math.round(2.54 * (double)this.sniffIntLittleEndian(in) / 100.0));
        this.suffix = "bmp";
    }

    private int read(InputStream in) throws IOException {
        ++this.read;
        return in.read();
    }

    private void skip(int num, InputStream in) throws IOException {
        this.read += num;
        in.skip(num);
    }

    private boolean sniff(InputStream in, byte[] magic) throws IOException {
        for (int m = 0; m < magic.length; ++m) {
            int i = this.read(in);
            if (i != -1 && i == magic[m]) continue;
            return false;
        }
        return true;
    }

    private boolean sniff(InputStream in, String magic) throws IOException {
        return this.sniff(in, magic.getBytes());
    }

    private int sniffInt(InputStream in, boolean intel) throws IOException {
        return intel ? this.sniffIntLittleEndian(in) : this.sniffIntBigEndian(in);
    }

    private int sniffIntBigEndian(InputStream in) throws IOException {
        return (this.read(in) & 0xFF) << 24 | (this.read(in) & 0xFF) << 16 | (this.read(in) & 0xFF) << 8 | this.read(in) & 0xFF;
    }

    private int sniffIntLittleEndian(InputStream in) throws IOException {
        return this.read(in) & 0xFF | (this.read(in) & 0xFF) << 8 | (this.read(in) & 0xFF) << 16 | (this.read(in) & 0xFF) << 24;
    }

    private int sniffShort(InputStream in, boolean intel) throws IOException {
        return intel ? this.sniffShortLittleEndian(in) : this.sniffShortBigEndian(in);
    }

    private int sniffShortBigEndian(InputStream in) throws IOException {
        return (this.read(in) & 0xFF) << 8 | this.read(in) & 0xFF;
    }

    private int sniffShortLittleEndian(InputStream in) throws IOException {
        return this.read(in) & 0xFF | (this.read(in) & 0xFF) << 8;
    }

    private int string2int(String s) {
        if (s.length() != 4) {
            throw new IllegalArgumentException();
        }
        return (s.charAt(0) & 0xFF) << 24 | (s.charAt(1) & 0xFF) << 16 | (s.charAt(2) & 0xFF) << 8 | s.charAt(3) & 0xFF;
    }
}

