/*
 * Decompiled with CFR 0.152.
 */
package genj.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLClassLoader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EnvironmentChecker {
    private static Logger LOG = Logger.getLogger("genj.util");
    private static final String[] SYSTEM_PROPERTIES = new String[]{"java.vendor", "java.vendor.url", "java.version", "java.class.version", "os.name", "os.arch", "os.version", "browser", "browser.vendor", "browser.version", "user.name", "user.dir", "user.home", "all.home", "user.home.genj", "all.home.genj"};
    private static final Set NOOVERRIDE = new HashSet();

    public static boolean isJava14(Object receipient) {
        String version = EnvironmentChecker.getProperty(receipient, "java.version", "", "Checking Java VM version");
        return !version.startsWith("1.1") && !version.startsWith("1.2") && !version.startsWith("1.3");
    }

    public static boolean isJava15(Object receipient) {
        String version = EnvironmentChecker.getProperty(receipient, "java.version", "", "Checking Java VM version");
        return version.startsWith("1.5") || version.startsWith("1.6");
    }

    public static boolean isMac() {
        return EnvironmentChecker.getProperty((Object)EnvironmentChecker.class, "mrj.version", null, "isMac()") != null;
    }

    public static boolean isWindows() {
        return EnvironmentChecker.getProperty((Object)EnvironmentChecker.class, "os.name", "", "isWindows()").indexOf("Windows") > -1;
    }

    private static String getDatePattern(int format) {
        try {
            return ((SimpleDateFormat)DateFormat.getDateInstance(format)).toPattern();
        }
        catch (Throwable t) {
            return "?";
        }
    }

    public static void log() {
        for (int i = 0; i < SYSTEM_PROPERTIES.length; ++i) {
            String key = SYSTEM_PROPERTIES[i];
            String msg = key + " = " + EnvironmentChecker.getProperty((Object)(class$genj$util$EnvironmentChecker == null ? EnvironmentChecker.class$("genj.util.EnvironmentChecker") : class$genj$util$EnvironmentChecker), SYSTEM_PROPERTIES[i], "", "check system props");
            if (NOOVERRIDE.contains(key)) {
                msg = msg + " (no override)";
            }
            LOG.info(msg);
        }
        LOG.info("Locale = " + Locale.getDefault());
        LOG.info("DateFormat (short) = " + EnvironmentChecker.getDatePattern(3));
        LOG.info("DateFormat (medium) = " + EnvironmentChecker.getDatePattern(2));
        LOG.info("DateFormat (long) = " + EnvironmentChecker.getDatePattern(1));
        LOG.info("DateFormat (full) = " + EnvironmentChecker.getDatePattern(0));
        try {
            String cpath = EnvironmentChecker.getProperty((Object)EnvironmentChecker.class, "java.class.path", "", "check classpath");
            StringTokenizer tokens = new StringTokenizer(cpath, System.getProperty("path.separator"), false);
            while (tokens.hasMoreTokens()) {
                String entry = tokens.nextToken();
                String stat = EnvironmentChecker.checkClasspathEntry(entry) ? " (does exist)" : "";
                LOG.info("Classpath = " + entry + stat);
            }
            for (ClassLoader cl = EnvironmentChecker.class.getClassLoader(); cl != null; cl = cl.getParent()) {
                if (cl instanceof URLClassLoader) {
                    LOG.info("URLClassloader " + cl + Arrays.asList(((URLClassLoader)cl).getURLs()));
                    continue;
                }
                LOG.info("Classloader " + cl);
            }
            Runtime r = Runtime.getRuntime();
            LOG.log(Level.INFO, "Memory Max={0}/Total={1}/Free={2}", new Long[]{new Long(r.maxMemory()), new Long(r.totalMemory()), new Long(r.freeMemory())});
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "unexpected exception in log()", t);
        }
    }

    private static boolean checkClasspathEntry(String entry) {
        try {
            return new File(entry).exists();
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static String getProperty(Object receipient, String key, String fallback, String msg) {
        return EnvironmentChecker.getProperty(receipient, new String[]{key}, fallback, msg);
    }

    public static String getProperty(Object receipient, String[] keys, String fallback, String msg) {
        String key = null;
        try {
            for (int i = 0; i < keys.length; ++i) {
                key = keys[i];
                int pf = key.indexOf(47);
                if (pf < 0) {
                    pf = key.length();
                }
                String postfix = key.substring(pf);
                String val = System.getProperty(key = key.substring(0, pf));
                if (val == null) continue;
                LOG.finer("Using system-property " + key + '=' + val + " (" + msg + ')');
                return val + postfix;
            }
        }
        catch (Throwable t) {
            LOG.log(Level.INFO, "Couldn't access system property " + key + " (" + t.getMessage() + ")");
        }
        if (fallback != null) {
            LOG.fine("Using fallback for system-property " + key + '=' + fallback + " (" + msg + ')');
        }
        return fallback;
    }

    public static void loadSystemProperties(InputStream in) throws IOException {
        try {
            Properties props = new Properties();
            props.load(in);
            Iterator<Object> keys = props.keySet().iterator();
            while (keys.hasNext()) {
                String key = keys.next().toString();
                if (System.getProperty(key) != null) continue;
                EnvironmentChecker.setProperty(key, props.getProperty(key));
            }
        }
        catch (Throwable t) {
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new IOException("unexpected throwable " + t.getMessage());
        }
    }

    private static void setProperty(String key, String val) {
        String old = System.getProperty(key);
        if (old == null) {
            System.setProperty(key, val);
        } else {
            NOOVERRIDE.add(key);
        }
    }

    static {
        try {
            EnvironmentChecker.loadSystemProperties(new FileInputStream(new File("system.properties")));
        }
        catch (IOException e) {
            // empty catch block
        }
        if (EnvironmentChecker.isWindows()) {
            String QUERY = "reg query \"HKLM\\SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\ProfileList\"";
            Pattern PATTERN = Pattern.compile(".*AllUsersProfile\tREG_SZ\t(.*)");
            Object value = null;
            try {
                String line;
                Process process = Runtime.getRuntime().exec(QUERY);
                BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((line = in.readLine()) != null) {
                    Matcher match = PATTERN.matcher(line);
                    if (!match.matches()) continue;
                    File home = new File(new File(System.getProperty("user.home")).getParent(), match.group(1));
                    if (!home.isDirectory()) break;
                    EnvironmentChecker.setProperty("all.home", home.getAbsolutePath());
                    break;
                }
                in.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        try {
            File home = new File(System.getProperty("user.home"));
            File dotgenj = new File(home, ".genj");
            File appdata = new File(home, "Application Data");
            File user_home_genj = !EnvironmentChecker.isWindows() || dotgenj.isDirectory() || !appdata.isDirectory() ? dotgenj : new File(appdata, "GenJ");
            EnvironmentChecker.setProperty("user.home.genj", user_home_genj.getAbsolutePath());
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            File app_data;
            if (EnvironmentChecker.isWindows() && (app_data = new File(System.getProperty("all.home"), "Application Data")).isDirectory()) {
                EnvironmentChecker.setProperty("all.home.genj", new File(app_data, "GenJ").getAbsolutePath());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

