/*
 * Decompiled with CFR 0.152.
 */
package genj.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ChangeSupport
implements DocumentListener,
ChangeListener,
ActionListener {
    private List listeners = new LinkedList();
    private Object source;
    private boolean hasChanged = false;

    public ChangeSupport(Object source) {
        this.source = source;
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    public void setChanged(boolean set) {
        this.hasChanged = set;
        if (set) {
            this.fireChangeEvent();
        }
    }

    public void addChangeListener(ChangeListener l) {
        if (this.listeners.isEmpty()) {
            this.hasChanged = false;
        }
        this.listeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    public void removeAllChangeListeners() {
        this.listeners.clear();
    }

    public void fireChangeEvent() {
        this.fireChangeEvent(this.source);
    }

    protected void fireChangeEvent(Object source) {
        this.hasChanged = true;
        ChangeEvent e = new ChangeEvent(source);
        Iterator it = new ArrayList(this.listeners).iterator();
        while (it.hasNext()) {
            ((ChangeListener)it.next()).stateChanged(e);
        }
    }

    public void stateChanged(ChangeEvent e) {
        this.fireChangeEvent(e.getSource());
    }

    public void changedUpdate(DocumentEvent e) {
        this.fireChangeEvent();
    }

    public void insertUpdate(DocumentEvent e) {
        this.fireChangeEvent();
    }

    public void removeUpdate(DocumentEvent e) {
        this.fireChangeEvent();
    }

    public void actionPerformed(ActionEvent e) {
        this.fireChangeEvent(e.getSource());
    }
}

