/*
 * Decompiled with CFR 0.152.
 */
package genj.tree;

import genj.renderer.BlueprintList;
import genj.renderer.BlueprintManager;
import genj.tree.TreeMetrics;
import genj.tree.TreeView;
import genj.util.Resources;
import genj.util.swing.Action2;
import genj.util.swing.ButtonHelper;
import genj.util.swing.ColorsWidget;
import genj.util.swing.FontChooser;
import genj.util.swing.ListWidget;
import genj.util.swing.NestedBlockLayout;
import genj.view.Settings;
import genj.view.ViewManager;
import java.awt.Color;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.ListModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TreeViewSettings
extends JTabbedPane
implements Settings {
    private TreeView view;
    private JSpinner[] spinners = new JSpinner[5];
    private ColorsWidget colorWidget;
    private BlueprintList blueprintList;
    private Resources resources = Resources.get(this);
    private JCheckBox checkBending = new JCheckBox(this.resources.getString("bend"));
    private JCheckBox checkAntialiasing = new JCheckBox(this.resources.getString("antialiasing"));
    private JCheckBox checkAdjustFonts = new JCheckBox(this.resources.getString("adjustfonts"));
    private JCheckBox checkMarrSymbols = new JCheckBox(this.resources.getString("marrsymbols"));
    private Action2 bookmarkUp = new ActionMove(-1);
    private Action2 bookmarkDown = new ActionMove(1);
    private Action2 bookmarkDelete = new ActionDelete();
    private FontChooser fontChooser = new FontChooser();
    private JList bookmarkList;

    public void init(ViewManager manager) {
        JPanel options = new JPanel(new NestedBlockLayout("<col><check gx=\"1\"/><check gx=\"1\"/><check gx=\"1\"/><check gx=\"1\"/><font gx=\"1\"/><row><label/><spinner/></row><row><label/><spinner/></row><row><label/><spinner/></row><row><label/><spinner/></row><row><label/><spinner/></row></col>"));
        this.checkBending.setToolTipText(this.resources.getString("bend.tip"));
        this.checkAntialiasing.setToolTipText(this.resources.getString("antialiasing.tip"));
        this.checkAdjustFonts.setToolTipText(this.resources.getString("adjustfonts.tip"));
        this.checkMarrSymbols.setToolTipText(this.resources.getString("marrsymbols.tip"));
        options.add(this.checkBending);
        options.add(this.checkAntialiasing);
        options.add(this.checkAdjustFonts);
        options.add(this.checkMarrSymbols);
        options.add(this.fontChooser);
        this.spinners[0] = this.createSpinner("indiwidth", options, 1.0, 16.0);
        this.spinners[1] = this.createSpinner("indiheight", options, 0.4, 16.0);
        this.spinners[2] = this.createSpinner("famwidth", options, 1.0, 16.0);
        this.spinners[3] = this.createSpinner("famheight", options, 0.4, 16.0);
        this.spinners[4] = this.createSpinner("padding", options, 1.0, 4.0);
        this.colorWidget = new ColorsWidget();
        this.blueprintList = new BlueprintList(BlueprintManager.getInstance());
        Box bookmarks = new Box(1);
        this.bookmarkList = new ListWidget();
        this.bookmarkList.setSelectionMode(0);
        bookmarks.add(new JScrollPane(this.bookmarkList));
        JPanel bookmarkActions = new JPanel();
        ButtonHelper bh = new ButtonHelper().setContainer(bookmarkActions);
        bh.create(this.bookmarkUp);
        bh.create(this.bookmarkDown);
        bh.create(this.bookmarkDelete);
        this.bookmarkList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                int i = TreeViewSettings.this.bookmarkList.getSelectedIndex();
                int n = TreeViewSettings.this.bookmarkList.getModel().getSize();
                TreeViewSettings.this.bookmarkUp.setEnabled(i > 0);
                TreeViewSettings.this.bookmarkDown.setEnabled(i >= 0 && i < n - 1);
                TreeViewSettings.this.bookmarkDelete.setEnabled(i >= 0);
            }
        });
        bookmarks.add(bookmarkActions);
        this.add(this.resources.getString("page.main"), options);
        this.add(this.resources.getString("page.colors"), this.colorWidget);
        this.add(this.resources.getString("page.bookmarks"), bookmarks);
        this.add(this.resources.getString("page.blueprints"), this.blueprintList);
    }

    private JSpinner createSpinner(String key, Container c, double min, double max) {
        JSpinner result = new JSpinner(new SpinnerNumberModel(1.0, min, max, 0.1));
        JSpinner.NumberEditor editor = new JSpinner.NumberEditor(result, "##0.0");
        result.setEditor(editor);
        result.addChangeListener(editor);
        result.setToolTipText(this.resources.getString("info." + key + ".tip"));
        c.add(new JLabel(this.resources.getString("info." + key)));
        c.add(result);
        return result;
    }

    public void setView(JComponent viEw) {
        this.view = (TreeView)viEw;
        this.blueprintList.setGedcom(this.view.getModel().getGedcom());
    }

    public void apply() {
        this.view.getModel().setBendArcs(this.checkBending.isSelected());
        this.view.setAntialiasing(this.checkAntialiasing.isSelected());
        this.view.setAdjustFonts(this.checkAdjustFonts.isSelected());
        this.view.setContentFont(this.fontChooser.getSelectedFont());
        this.view.getModel().setMarrSymbols(this.checkMarrSymbols.isSelected());
        Iterator colors = this.view.colors.keySet().iterator();
        while (colors.hasNext()) {
            String key = colors.next().toString();
            this.view.colors.put(key, this.colorWidget.getColor(key));
        }
        ArrayList bookmarks = new ArrayList();
        ListModel list = this.bookmarkList.getModel();
        for (int i = 0; i < list.getSize(); ++i) {
            bookmarks.add(list.getElementAt(i));
        }
        this.view.getModel().setBookmarks(bookmarks);
        this.view.getModel().setMetrics(new TreeMetrics((int)((Double)this.spinners[0].getModel().getValue() * 10.0), (int)((Double)this.spinners[1].getModel().getValue() * 10.0), (int)((Double)this.spinners[2].getModel().getValue() * 10.0), (int)((Double)this.spinners[3].getModel().getValue() * 10.0), (int)((Double)this.spinners[4].getModel().getValue() * 10.0)));
        this.view.setBlueprints(this.blueprintList.getSelection());
    }

    public void reset() {
        this.checkBending.setSelected(this.view.getModel().isBendArcs());
        this.checkAntialiasing.setSelected(this.view.isAntialising());
        this.checkAdjustFonts.setSelected(this.view.isAdjustFonts());
        this.fontChooser.setSelectedFont(this.view.getContentFont());
        this.checkMarrSymbols.setSelected(this.view.getModel().isMarrSymbols());
        this.colorWidget.removeAllColors();
        Iterator keys = this.view.colors.keySet().iterator();
        while (keys.hasNext()) {
            String key = keys.next().toString();
            String name = this.resources.getString("color." + key);
            Color color = (Color)this.view.colors.get(key);
            this.colorWidget.addColor(key, name, color);
        }
        this.bookmarkList.setModel(new DefaultComboBoxModel<Object>(this.view.getModel().getBookmarks().toArray()));
        TreeMetrics m = this.view.getModel().getMetrics();
        int[] values = new int[]{m.wIndis, m.hIndis, m.wFams, m.hFams, m.pad};
        for (int i = 0; i < values.length; ++i) {
            this.spinners[i].setValue(new Double((double)values[i] * 0.1));
        }
        this.blueprintList.setSelection(this.view.getBlueprints());
    }

    public JComponent getEditor() {
        return this;
    }

    private class ActionDelete
    extends Action2 {
        private ActionDelete() {
            this.setText(TreeViewSettings.this.resources.getString("bookmark.del"));
            this.setEnabled(false);
        }

        protected void execute() {
            int i = TreeViewSettings.this.bookmarkList.getSelectedIndex();
            if (i >= 0) {
                ((DefaultComboBoxModel)TreeViewSettings.this.bookmarkList.getModel()).removeElementAt(i);
            }
        }
    }

    private class ActionMove
    extends Action2 {
        private int by;

        private ActionMove(int how) {
            this.setText(TreeViewSettings.this.resources.getString("bookmark.move." + how));
            this.setEnabled(false);
            this.by = how;
        }

        protected void execute() {
            int i = TreeViewSettings.this.bookmarkList.getSelectedIndex();
            DefaultComboBoxModel model = (DefaultComboBoxModel)TreeViewSettings.this.bookmarkList.getModel();
            Object bookmark = model.getElementAt(i);
            model.removeElementAt(i);
            model.insertElementAt(bookmark, i + this.by);
            TreeViewSettings.this.bookmarkList.setSelectedIndex(i + this.by);
        }
    }
}

