/*
 * Decompiled with CFR 0.152.
 */
package genj.tree;

import genj.print.Printer;
import genj.renderer.EntityRenderer;
import genj.tree.ContentRenderer;
import genj.tree.TreeView;
import genj.util.swing.UnitGraphics;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;

public class TreeViewPrinter
implements Printer {
    private TreeView tree;
    private EntityRenderer indiRenderer;
    private EntityRenderer famRenderer;

    public void setView(JComponent view) {
        this.tree = (TreeView)view;
        this.indiRenderer = this.tree.createEntityRenderer("INDI");
        this.famRenderer = this.tree.createEntityRenderer("FAM");
    }

    public Dimension calcSize(Dimension2D pageSizeInInches, Point dpi) {
        Rectangle mmbounds = this.tree.getModel().getBounds();
        return new Dimension((int)Math.ceil((double)((float)mmbounds.width * 0.1f / 2.54f) / pageSizeInInches.getWidth()), (int)Math.ceil((double)((float)mmbounds.height * 0.1f / 2.54f) / pageSizeInInches.getHeight()));
    }

    public void renderPage(Graphics2D g, Point page, Dimension2D pageSizeInInches, Point dpi, boolean preview) {
        UnitGraphics ug = new UnitGraphics(g, dpi.x, dpi.y);
        ug.setColor(Color.LIGHT_GRAY);
        ug.draw(new Rectangle2D.Double(0.0, 0.0, pageSizeInInches.getWidth(), pageSizeInInches.getHeight()), 0.0, 0.0);
        ug.translate((double)(-page.x) * pageSizeInInches.getWidth(), (double)(-page.y) * pageSizeInInches.getHeight());
        UnitGraphics graphics = new UnitGraphics(g, (double)((float)dpi.x / 2.54f) * 0.1, (double)((float)dpi.y / 2.54f) * 0.1);
        ContentRenderer renderer = new ContentRenderer();
        renderer.cArcs = Color.black;
        renderer.cFamShape = Color.black;
        renderer.cIndiShape = Color.black;
        renderer.selection = null;
        if (!preview) {
            renderer.indiRenderer = this.indiRenderer.setResolution(dpi);
            renderer.famRenderer = this.famRenderer.setResolution(dpi);
        }
        renderer.render(graphics, this.tree.getModel());
    }
}

