/*
 * Decompiled with CFR 0.152.
 */
package genj.tree;

import genj.common.SelectEntityWidget;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyXRef;
import genj.io.Filter;
import genj.renderer.Blueprint;
import genj.renderer.BlueprintManager;
import genj.renderer.EntityRenderer;
import genj.renderer.Options;
import genj.tree.Bookmark;
import genj.tree.ContentRenderer;
import genj.tree.Images;
import genj.tree.Model;
import genj.tree.ModelListener;
import genj.tree.TreeMetrics;
import genj.tree.TreeNode;
import genj.util.Registry;
import genj.util.Resources;
import genj.util.swing.Action2;
import genj.util.swing.ButtonHelper;
import genj.util.swing.ImageIcon;
import genj.util.swing.PopupWidget;
import genj.util.swing.SliderWidget;
import genj.util.swing.UnitGraphics;
import genj.util.swing.ViewPortAdapter;
import genj.util.swing.ViewPortOverview;
import genj.view.ActionProvider;
import genj.view.ContextProvider;
import genj.view.ContextSelectionEvent;
import genj.view.ToolBarSupport;
import genj.view.ViewContext;
import genj.view.ViewManager;
import genj.window.WindowBroadcastEvent;
import genj.window.WindowBroadcastListener;
import genj.window.WindowManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TreeView
extends JPanel
implements ContextProvider,
WindowBroadcastListener,
ToolBarSupport,
ActionProvider,
Filter {
    private static final ImageIcon BOOKMARK_ICON = new ImageIcon(TreeView.class, "images/Bookmark.gif");
    private Resources resources = Resources.get(this);
    private final Point DPI;
    private final Point2D DPMM;
    private Model model;
    private ViewManager manager;
    private Content content;
    private Overview overview;
    private ContentRenderer contentRenderer;
    private Entity currentEntity = null;
    private double zoom = 1.0;
    private SliderWidget sliderZoom;
    private String title;
    private Registry registry;
    private boolean isAntialiasing = false;
    private boolean isAdjustFonts = false;
    Map colors = new HashMap();
    private Map tag2blueprint = new HashMap();
    private Map tag2renderer = new HashMap();
    private Font contentFont = new Font("SansSerif", 0, 12);
    private Point2D.Double center = new Point2D.Double(0.0, 0.0);

    public TreeView(String titl, Gedcom gedcom, Registry regIstry, ViewManager manAger) {
        this.registry = regIstry;
        this.title = titl;
        this.manager = manAger;
        this.DPI = Options.getInstance().getDPI();
        this.DPMM = new Point2D.Float((float)this.DPI.x / 2.54f / 10.0f, (float)this.DPI.y / 2.54f / 10.0f);
        this.colors.put("background", Color.WHITE);
        this.colors.put("indis", Color.BLACK);
        this.colors.put("fams", Color.DARK_GRAY);
        this.colors.put("arcs", Color.BLUE);
        this.colors.put("selects", Color.RED);
        this.colors = this.registry.get("color", this.colors);
        this.contentFont = this.registry.get("font", this.contentFont);
        this.isAdjustFonts = this.registry.get("adjust", this.isAdjustFonts);
        BlueprintManager bpm = BlueprintManager.getInstance();
        for (int t = 0; t < Gedcom.ENTITIES.length; ++t) {
            String tag = Gedcom.ENTITIES[t];
            this.tag2blueprint.put(tag, bpm.getBlueprint(gedcom.getOrigin(), tag, this.registry.get("blueprint." + tag, "")));
        }
        this.model = new Model(gedcom);
        this.model.setVertical(this.registry.get("vertical", true));
        this.model.setFamilies(this.registry.get("families", true));
        this.model.setBendArcs(this.registry.get("bend", true));
        this.model.setMarrSymbols(this.registry.get("marrs", true));
        TreeMetrics defm = this.model.getMetrics();
        this.model.setMetrics(new TreeMetrics(this.registry.get("windis", defm.wIndis), this.registry.get("hindis", defm.hIndis), this.registry.get("wfams", defm.wFams), this.registry.get("hfams", defm.hFams), this.registry.get("pad", defm.pad)));
        this.isAntialiasing = this.registry.get("antial", false);
        this.model.setHideAncestorsIDs(this.registry.get("hide.ancestors", new ArrayList()));
        this.model.setHideDescendantsIDs(this.registry.get("hide.descendants", new ArrayList()));
        Entity root = gedcom.getEntity(this.registry.get("root", ""));
        if (root == null) {
            root = gedcom.getFirstEntity("INDI");
        }
        this.model.setRoot(root);
        try {
            this.currentEntity = gedcom.getEntity(this.registry.get("current", (String)null));
        }
        catch (Exception e) {
            this.currentEntity = this.model.getRoot();
        }
        String[] bs = this.registry.get("bookmarks", new String[0]);
        ArrayList<Bookmark> bookmarks = new ArrayList<Bookmark>();
        for (int i = 0; i < bs.length; ++i) {
            try {
                bookmarks.add(new Bookmark(this, gedcom, bs[i]));
                continue;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        this.model.setBookmarks(bookmarks);
        this.contentRenderer = new ContentRenderer();
        this.content = new Content();
        JScrollPane scroll = new JScrollPane(new ViewPortAdapter(this.content));
        this.overview = new Overview(scroll);
        this.overview.setVisible(this.registry.get("overview", false));
        this.overview.setSize(this.registry.get("overview", new Dimension(64, 64)));
        this.zoom = Math.max(0.1, Math.min(1.0, (double)this.registry.get("zoom", 1.0f)));
        this.add(this.overview);
        this.add(scroll);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TreeView.this.scrollToCurrent();
            }
        });
    }

    public void removeNotify() {
        this.registry.put("overview", this.overview.isVisible());
        this.registry.put("overview", this.overview.getSize());
        this.registry.put("zoom", (float)this.zoom);
        this.registry.put("vertical", this.model.isVertical());
        this.registry.put("families", this.model.isFamilies());
        this.registry.put("bend", this.model.isBendArcs());
        this.registry.put("marrs", this.model.isMarrSymbols());
        TreeMetrics m = this.model.getMetrics();
        this.registry.put("windis", m.wIndis);
        this.registry.put("hindis", m.hIndis);
        this.registry.put("wfams", m.wFams);
        this.registry.put("hfams", m.hFams);
        this.registry.put("pad", m.pad);
        this.registry.put("antial", this.isAntialiasing);
        this.registry.put("font", this.contentFont);
        this.registry.put("adjust", this.isAdjustFonts);
        this.registry.put("color", this.colors);
        for (int t = 0; t < Gedcom.ENTITIES.length; ++t) {
            String tag = Gedcom.ENTITIES[t];
            this.registry.put("blueprint." + tag, this.getBlueprint(tag).getName());
        }
        if (this.model.getRoot() != null) {
            this.registry.put("root", this.model.getRoot().getId());
        }
        if (this.currentEntity != null) {
            this.registry.put("current", this.currentEntity.getId());
        }
        Object[] bs = new String[this.model.getBookmarks().size()];
        Iterator it = this.model.getBookmarks().iterator();
        int b = 0;
        while (it.hasNext()) {
            bs[b] = it.next().toString();
            ++b;
        }
        this.registry.put("bookmarks", bs);
        this.registry.put("hide.ancestors", this.model.getHideAncestorsIDs());
        this.registry.put("hide.descendants", this.model.getHideDescendantsIDs());
        super.removeNotify();
    }

    public ViewContext getContext() {
        return new ViewContext(this.model.getGedcom());
    }

    public void doLayout() {
        int w = this.getWidth();
        int h = this.getHeight();
        Component[] cs = this.getComponents();
        for (int c = 0; c < cs.length; ++c) {
            if (cs[c] == this.overview) continue;
            cs[c].setBounds(0, 0, w, h);
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(480, 480);
    }

    public boolean isOptimizedDrawingEnabled() {
        return !this.overview.isVisible();
    }

    public boolean isAntialising() {
        return this.isAntialiasing;
    }

    public void setAntialiasing(boolean set) {
        if (this.isAntialiasing == set) {
            return;
        }
        this.isAntialiasing = set;
        this.repaint();
    }

    public boolean isAdjustFonts() {
        return this.isAdjustFonts;
    }

    public void setAdjustFonts(boolean set) {
        if (this.isAdjustFonts == set) {
            return;
        }
        this.isAdjustFonts = set;
        this.tag2renderer.clear();
        this.repaint();
    }

    public Font getContentFont() {
        return this.contentFont;
    }

    public void setContentFont(Font set) {
        if (this.contentFont.equals(set)) {
            return;
        }
        this.contentFont = set;
        this.tag2renderer.clear();
        this.repaint();
    }

    Map getBlueprints() {
        return this.tag2blueprint;
    }

    void setBlueprints(Map set) {
        this.tag2blueprint = set;
        this.tag2renderer.clear();
        this.repaint();
    }

    public Model getModel() {
        return this.model;
    }

    public boolean handleBroadcastEvent(WindowBroadcastEvent event) {
        ContextSelectionEvent cse = ContextSelectionEvent.narrow(event, this.model.getGedcom());
        if (cse == null) {
            return true;
        }
        ViewContext context = cse.getContext();
        Entity entity = context.getEntity();
        Property prop = context.getProperty();
        if (entity == null) {
            return true;
        }
        if (prop instanceof Entity) {
            prop = null;
        }
        if (cse.isActionPerformed() && prop == null && (cse.isOutbound() || !(cse.getSource() instanceof Content))) {
            this.setRoot(entity);
            return true;
        }
        if (prop instanceof PropertyXRef && ((PropertyXRef)prop).isValid()) {
            entity = ((PropertyXRef)prop).getTargetEntity();
            prop = null;
        }
        if (entity != this.currentEntity) {
            this.setCurrent(entity);
        }
        return true;
    }

    void setCurrent(Entity entity) {
        if (!(entity instanceof Indi) && !(entity instanceof Fam)) {
            return;
        }
        TreeNode node = this.model.getNode(entity);
        if (node == null) {
            return;
        }
        this.currentEntity = entity;
        this.scrollTo(node.pos);
        this.content.repaint();
        this.overview.repaint();
    }

    private void scrollTo(Point p) {
        this.center.setLocation(p);
        Rectangle b = this.model.getBounds();
        Dimension d = this.getSize();
        this.content.scrollRectToVisible(new Rectangle((int)((p.getX() - b.getMinX()) * (this.DPMM.getX() * this.zoom)) - d.width / 2, (int)((p.getY() - b.getMinY()) * (this.DPMM.getY() * this.zoom)) - d.height / 2, d.width, d.height));
    }

    private void scrollToCurrent() {
        if (this.currentEntity == null) {
            this.currentEntity = this.model.getRoot();
        }
        if (this.currentEntity == null) {
            return;
        }
        TreeNode node = this.model.getNode(this.currentEntity);
        if (node == null) {
            this.currentEntity = null;
            this.scrollToCurrent();
            return;
        }
        this.scrollTo(node.pos);
    }

    public void populate(JToolBar bar) {
        this.sliderZoom = new SliderWidget(1, 100, (int)(this.zoom * 100.0));
        this.sliderZoom.addChangeListener(new ZoomGlue());
        this.sliderZoom.setAlignmentX(0.0f);
        bar.add(this.sliderZoom);
        ButtonHelper bh = new ButtonHelper().setContainer(bar).setInsets(0);
        bh.create(new ActionOverview(), null, this.overview.isVisible());
        bar.addSeparator();
        bh.create(new ActionOrientation(), Images.imgVert, this.model.isVertical());
        bh.create(new ActionFamsAndSpouses(), Images.imgDoFams, this.model.isFamilies());
        bh.create(new ActionFoldSymbols(), null, this.model.isFoldSymbols());
        bar.addSeparator();
        PopupWidget pb = new PopupWidget("", BOOKMARK_ICON){

            public List getActions() {
                return TreeView.this.model.getBookmarks();
            }
        };
        pb.setToolTipText(this.resources.getString("bookmark.tip"));
        bar.add(pb);
    }

    public List createActions(Property[] properties, ViewManager manager) {
        return null;
    }

    public List createActions(Entity entity, ViewManager manager) {
        if (!(entity instanceof Indi) && !(entity instanceof Fam)) {
            return null;
        }
        ArrayList<Action2> result = new ArrayList<Action2>(2);
        result.add(new ActionRoot(entity));
        result.add(new ActionBookmark(entity, false));
        return result;
    }

    public List createActions(Gedcom gedcom, ViewManager manager) {
        return null;
    }

    public List createActions(Property property, ViewManager manager) {
        return null;
    }

    public void setRoot(Entity root) {
        if (!(root instanceof Indi) && !(root instanceof Fam)) {
            return;
        }
        this.currentEntity = root;
        this.model.setRoot(root);
    }

    private Point view2model(Point pos) {
        Rectangle bounds = this.model.getBounds();
        return new Point((int)Math.rint((double)pos.x / (this.DPMM.getX() * this.zoom) + bounds.getMinX()), (int)Math.rint((double)pos.y / (this.DPMM.getY() * this.zoom) + bounds.getMinY()));
    }

    Blueprint getBlueprint(String tag) {
        Blueprint result = (Blueprint)this.tag2blueprint.get(tag);
        if (result == null) {
            result = BlueprintManager.getInstance().getBlueprint(this.model.getGedcom().getOrigin(), tag, "");
            this.tag2blueprint.put(tag, result);
        }
        return result;
    }

    private EntityRenderer getEntityRenderer(String tag) {
        EntityRenderer result = (EntityRenderer)this.tag2renderer.get(tag);
        if (result == null) {
            result = this.createEntityRenderer(tag);
            result.setResolution(this.DPI);
            result.setScaleFonts(this.isAdjustFonts);
            this.tag2renderer.put(tag, result);
        }
        return result;
    }

    EntityRenderer createEntityRenderer(String tag) {
        return new EntityRenderer(this.getBlueprint(tag), this.contentFont);
    }

    public boolean checkFilter(Property prop) {
        if (!(prop instanceof Entity)) {
            return true;
        }
        Entity ent = (Entity)prop;
        Set ents = this.model.getEntities();
        if (ent instanceof Indi) {
            return ents.contains(ent);
        }
        if (ent instanceof Fam) {
            boolean b = ents.contains(ent);
            if (this.model.isFamilies() || b) {
                return b;
            }
            Fam fam = (Fam)ent;
            boolean father = ents.contains(fam.getHusband());
            boolean mother = ents.contains(fam.getWife());
            boolean child = false;
            Indi[] children = fam.getChildren();
            for (int i = 0; !child && i < children.length; ++i) {
                if (!ents.contains(children[i])) continue;
                child = true;
            }
            return father && mother || father && child || mother && child;
        }
        if (this.model.getGedcom().getSubmitter() == ent) {
            return true;
        }
        Entity[] refs = PropertyXRef.getReferences(ent);
        for (int r = 0; r < refs.length; ++r) {
            if (!ents.contains(refs[r])) continue;
            return true;
        }
        return false;
    }

    public String getFilterName() {
        return this.model.getEntities().size() + " nodes in " + this.title;
    }

    private class ActionBookmark
    extends Action2 {
        private Entity entity;

        private ActionBookmark(Entity e, boolean local) {
            this.entity = e;
            if (local) {
                this.setText(TreeView.this.resources, "bookmark.add");
                this.setImage(BOOKMARK_ICON);
            } else {
                this.setText(TreeView.this.resources.getString("bookmark.in", TreeView.this.title));
                this.setImage(Images.imgView);
            }
        }

        protected void execute() {
            String name = "";
            if (this.entity instanceof Indi) {
                name = ((Indi)this.entity).getName();
            }
            if (this.entity instanceof Fam) {
                Indi husb = ((Fam)this.entity).getHusband();
                Indi wife = ((Fam)this.entity).getWife();
                if (husb != null && wife != null) {
                    name = husb.getName() + " & " + wife.getName();
                }
            }
            if ((name = WindowManager.getInstance(this.getTarget()).openDialog(null, TreeView.this.title, 3, TreeView.this.resources.getString("bookmark.name"), name, (Component)TreeView.this)) == null) {
                return;
            }
            TreeView.this.model.addBookmark(new Bookmark(TreeView.this, name, this.entity));
        }
    }

    private class ActionChooseRoot
    extends Action2 {
        private ActionChooseRoot() {
            this.setText(TreeView.this.resources, "select.root");
        }

        protected void execute() {
            SelectEntityWidget select = new SelectEntityWidget(TreeView.this.model.getGedcom(), "INDI", null);
            int rc = WindowManager.getInstance(this.getTarget()).openDialog("select.root", this.getText(), 3, select, Action2.okCancel(), (Component)TreeView.this);
            if (rc == 0) {
                TreeView.this.setRoot(select.getSelection());
            }
        }
    }

    private class ActionFoldSymbols
    extends Action2 {
        private ActionFoldSymbols() {
            super.setImage(Images.imgFoldSymbols);
            super.setTip(TreeView.this.resources, "foldsymbols.tip");
        }

        protected void execute() {
            TreeView.this.model.setFoldSymbols(!TreeView.this.model.isFoldSymbols());
            TreeView.this.scrollToCurrent();
        }
    }

    private class ActionFamsAndSpouses
    extends Action2 {
        private ActionFamsAndSpouses() {
            super.setImage(Images.imgDontFams);
            super.setTip(TreeView.this.resources, "families.tip");
        }

        protected void execute() {
            TreeView.this.model.setFamilies(!TreeView.this.model.isFamilies());
            TreeView.this.scrollToCurrent();
        }
    }

    private class ActionOrientation
    extends Action2 {
        private ActionOrientation() {
            super.setImage(Images.imgHori);
            super.setTip(TreeView.this.resources, "orientation.tip");
        }

        protected void execute() {
            TreeView.this.model.setVertical(!TreeView.this.model.isVertical());
            TreeView.this.scrollToCurrent();
        }
    }

    private class ActionRoot
    extends Action2 {
        private Entity root;

        private ActionRoot(Entity entity) {
            this.root = entity;
            this.setText(TreeView.this.resources.getString("root", TreeView.this.title));
            this.setImage(Images.imgView);
        }

        protected void execute() {
            TreeView.this.setRoot(this.root);
        }
    }

    private class ActionOverview
    extends Action2 {
        private ActionOverview() {
            this.setImage(Images.imgOverview);
            this.setTip(TreeView.this.resources, "overview.tip");
        }

        protected void execute() {
            TreeView.this.overview.setVisible(!TreeView.this.overview.isVisible());
        }
    }

    private class ZoomGlue
    implements ChangeListener {
        private ZoomGlue() {
        }

        public void stateChanged(ChangeEvent e) {
            TreeView.this.zoom = (double)TreeView.this.sliderZoom.getValue() * 0.01;
            TreeView.this.content.invalidate();
            TreeView.this.validate();
            TreeView.this.scrollToCurrent();
            TreeView.this.repaint();
        }
    }

    private class Content
    extends JComponent
    implements ModelListener,
    MouseListener,
    ContextProvider {
        private Content() {
            this.addMouseListener(this);
        }

        public void addNotify() {
            super.addNotify();
            TreeView.this.model.addListener(this);
        }

        public void removeNotify() {
            TreeView.this.model.removeListener(this);
            super.removeNotify();
        }

        public ViewContext getContext() {
            ViewContext result;
            if (TreeView.this.currentEntity == null) {
                result = new ViewContext(TreeView.this.model.getGedcom());
                result.addAction(new ActionChooseRoot());
            } else {
                result = new ViewContext(TreeView.this.currentEntity);
                result.addAction(new ActionBookmark(TreeView.this.currentEntity, true));
            }
            return result;
        }

        public void structureChanged(Model model) {
            this.invalidate();
            TreeView.this.validate();
            this.repaint();
            TreeView.this.scrollToCurrent();
        }

        public void nodesChanged(Model model, Collection nodes) {
            this.repaint();
        }

        public Dimension getPreferredSize() {
            Rectangle bounds = TreeView.this.model.getBounds();
            double w = ((RectangularShape)bounds).getWidth() * (TreeView.this.DPMM.getX() * TreeView.this.zoom);
            double h = ((RectangularShape)bounds).getHeight() * (TreeView.this.DPMM.getY() * TreeView.this.zoom);
            return new Dimension((int)w, (int)h);
        }

        public void paint(Graphics g) {
            g.setColor((Color)TreeView.this.colors.get("background"));
            Rectangle r = g.getClipBounds();
            g.fillRect(r.x, r.y, r.width, r.height);
            UnitGraphics gw = new UnitGraphics(g, TreeView.this.DPMM.getX() * TreeView.this.zoom, TreeView.this.DPMM.getY() * TreeView.this.zoom);
            gw.setAntialiasing(TreeView.this.isAntialiasing);
            ((TreeView)TreeView.this).contentRenderer.cIndiShape = (Color)TreeView.this.colors.get("indis");
            ((TreeView)TreeView.this).contentRenderer.cFamShape = (Color)TreeView.this.colors.get("fams");
            ((TreeView)TreeView.this).contentRenderer.cArcs = (Color)TreeView.this.colors.get("arcs");
            ((TreeView)TreeView.this).contentRenderer.cSelectedShape = (Color)TreeView.this.colors.get("selects");
            ((TreeView)TreeView.this).contentRenderer.selection = TreeView.this.currentEntity;
            ((TreeView)TreeView.this).contentRenderer.indiRenderer = TreeView.this.getEntityRenderer("INDI");
            ((TreeView)TreeView.this).contentRenderer.famRenderer = TreeView.this.getEntityRenderer("FAM");
            TreeView.this.contentRenderer.render(gw, TreeView.this.model);
        }

        public void mousePressed(MouseEvent e) {
            Point p = TreeView.this.view2model(e.getPoint());
            Object content = TreeView.this.model.getContentAt(p.x, p.y);
            if (content == null) {
                TreeView.this.currentEntity = null;
                this.repaint();
                TreeView.this.overview.repaint();
                return;
            }
            if (content instanceof Entity) {
                TreeView.this.currentEntity = (Entity)content;
                this.repaint();
                TreeView.this.overview.repaint();
                WindowManager.broadcast(new ContextSelectionEvent(new ViewContext(TreeView.this.currentEntity), this));
                return;
            }
            if (content instanceof Runnable) {
                ((Runnable)content).run();
                return;
            }
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent evt) {
        }
    }

    private class Overview
    extends ViewPortOverview
    implements ModelListener {
        private Overview(JScrollPane scroll) {
            super(scroll.getViewport());
            super.setSize(new Dimension(TreeView.this.getWidth() / 4, TreeView.this.getHeight() / 4));
        }

        public void addNotify() {
            super.addNotify();
            TreeView.this.model.addListener(this);
        }

        public void removeNotify() {
            TreeView.this.model.removeListener(this);
            super.removeNotify();
        }

        public void setSize(int width, int height) {
            width = Math.max(32, width);
            height = Math.max(32, height);
            super.setSize(width, height);
        }

        protected void renderContent(Graphics g, double zoomx, double zoomy) {
            g.setColor(Color.WHITE);
            Rectangle r = g.getClipBounds();
            g.fillRect(r.x, r.y, r.width, r.height);
            UnitGraphics gw = new UnitGraphics(g, TreeView.this.DPMM.getX() * zoomx * TreeView.this.zoom, TreeView.this.DPMM.getY() * zoomy * TreeView.this.zoom);
            ((TreeView)TreeView.this).contentRenderer.cIndiShape = Color.BLACK;
            ((TreeView)TreeView.this).contentRenderer.cFamShape = Color.BLACK;
            ((TreeView)TreeView.this).contentRenderer.cArcs = Color.LIGHT_GRAY;
            ((TreeView)TreeView.this).contentRenderer.cSelectedShape = Color.RED;
            ((TreeView)TreeView.this).contentRenderer.selection = TreeView.this.currentEntity;
            ((TreeView)TreeView.this).contentRenderer.indiRenderer = null;
            ((TreeView)TreeView.this).contentRenderer.famRenderer = null;
            TreeView.this.contentRenderer.render(gw, TreeView.this.model);
            gw.popTransformation();
        }

        public void nodesChanged(Model arg0, Collection arg1) {
            this.repaint();
        }

        public void structureChanged(Model arg0) {
            this.repaint();
        }
    }
}

