/*
 * Decompiled with CFR 0.152.
 */
package genj.tree;

import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.tree.TreeNode;
import genj.tree.TreeView;
import genj.util.swing.Action2;

public class Bookmark
extends Action2 {
    private TreeView tree;
    private String name;
    private Entity entity;

    Bookmark(TreeView t, Gedcom ged, String s) throws IllegalArgumentException {
        int at = s.indexOf(35);
        if (at < 0) {
            throw new IllegalArgumentException("id#expected name");
        }
        this.tree = t;
        this.name = s.substring(at + 1);
        String id = s.substring(0, at);
        this.entity = ged.getEntity(id);
        if (!(this.entity instanceof Indi) && !(this.entity instanceof Fam)) {
            throw new IllegalArgumentException("id " + id + " doesn't point to Indi or Fam");
        }
        this.setText(this.name);
        this.setImage(Gedcom.getEntityImage(this.entity.getTag()));
    }

    public Bookmark(TreeView t, String n, Entity e) {
        this.tree = t;
        this.name = n;
        this.entity = e;
        this.setText(this.name);
        this.setImage(Gedcom.getEntityImage(this.entity.getTag()));
    }

    public String getName() {
        return this.name;
    }

    public Entity getEntity() {
        return this.entity;
    }

    protected void execute() {
        TreeNode node = this.tree.getModel().getNode(this.entity);
        if (node != null) {
            this.tree.setCurrent(this.entity);
        } else {
            this.tree.setRoot(this.entity);
        }
    }

    public String toString() {
        return this.entity.getId() + '#' + this.name;
    }
}

