/*
 * Decompiled with CFR 0.152.
 */
package genj.timeline;

import genj.almanac.Almanac;
import genj.gedcom.PropertyEvent;
import genj.gedcom.TagPath;
import genj.timeline.TimelineView;
import genj.util.Resources;
import genj.util.swing.ColorsWidget;
import genj.util.swing.ImageIcon;
import genj.util.swing.ListSelectionWidget;
import genj.util.swing.NestedBlockLayout;
import genj.view.Settings;
import genj.view.ViewManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Iterator;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.SpinnerNumberModel;

public class TimelineViewSettings
extends JTabbedPane
implements Settings {
    private Resources resources = Resources.get(this);
    private TimelineView view;
    private ListSelectionWidget pathsList = new ListSelectionWidget(){

        protected ImageIcon getIcon(Object choice) {
            TagPath path = (TagPath)choice;
            return ((TimelineViewSettings)TimelineViewSettings.this).view.getModel().gedcom.getGrammar().getMeta(path).getImage();
        }
    };
    private ListSelectionWidget almanacCategories = new ListSelectionWidget(){

        protected String getText(Object choice) {
            return "<html><body>" + choice + "</body></html>";
        }
    };
    private JCheckBox checkTags = new JCheckBox(this.resources.getString("info.show.tags"));
    private JCheckBox checkDates = new JCheckBox(this.resources.getString("info.show.dates"));
    private JCheckBox checkGrid = new JCheckBox(this.resources.getString("info.show.grid"));
    private JSpinner spinCmBefEvent;
    private JSpinner spinCmAftEvent;
    private ColorsWidget colorWidget;

    public void init(ViewManager manager) {
        JPanel panelOptions = new JPanel(new NestedBlockLayout("<col><check gx=\"1\"/><check gx=\"1\"/><check gx=\"1\"/><row><label/><spin/></row><row><label/><spin/></row></col>"));
        panelOptions.add(this.checkTags);
        panelOptions.add(this.checkDates);
        panelOptions.add(this.checkGrid);
        this.spinCmBefEvent = this.createSpinner(0.1, 2.0, this.resources.getString("info.befevent.tip"));
        panelOptions.add(new JLabel(this.resources.getString("info.befevent")));
        panelOptions.add(this.spinCmBefEvent);
        this.spinCmAftEvent = this.createSpinner(2.0, 9.0, this.resources.getString("info.aftevent.tip"));
        panelOptions.add(new JLabel(this.resources.getString("info.aftevent")));
        panelOptions.add(this.spinCmAftEvent);
        JPanel panelMain = new JPanel(new BorderLayout());
        panelMain.add((Component)new JLabel(this.resources.getString("info.events")), "North");
        panelMain.add((Component)this.pathsList, "Center");
        panelMain.add((Component)panelOptions, "South");
        JPanel panelEvents = new JPanel(new BorderLayout());
        panelEvents.add((Component)this.almanacCategories, "Center");
        this.colorWidget = new ColorsWidget();
        this.add(this.resources.getString("page.main"), panelMain);
        this.add(this.resources.getString("page.colors"), this.colorWidget);
        this.add(this.resources.getString("page.almanac"), panelEvents);
    }

    private JSpinner createSpinner(double min, double max, String tip) {
        JSpinner result = new JSpinner(new SpinnerNumberModel(min, min, max, 0.1));
        JSpinner.NumberEditor editor = new JSpinner.NumberEditor(result, "##0.0");
        result.setEditor(editor);
        result.addChangeListener(editor);
        result.setToolTipText(tip);
        return result;
    }

    public void apply() {
        this.view.getModel().setPaths(this.pathsList.getSelection());
        this.view.setPaintTags(this.checkTags.isSelected());
        this.view.setPaintDates(this.checkDates.isSelected());
        this.view.setPaintGrid(this.checkGrid.isSelected());
        this.view.setCMPerEvents((Double)this.spinCmBefEvent.getModel().getValue(), (Double)this.spinCmAftEvent.getModel().getValue());
        Iterator colors = this.view.colors.keySet().iterator();
        while (colors.hasNext()) {
            String key = colors.next().toString();
            this.view.colors.put(key, this.colorWidget.getColor(key));
        }
        this.view.setAlmanacCategories(this.almanacCategories.getSelection());
    }

    public void setView(JComponent viEw) {
        this.view = (TimelineView)viEw;
    }

    public void reset() {
        this.pathsList.setChoices(PropertyEvent.getTagPaths(this.view.getModel().gedcom));
        this.pathsList.setSelection(this.view.getModel().getPaths());
        this.checkTags.setSelected(this.view.isPaintTags());
        this.checkDates.setSelected(this.view.isPaintDates());
        this.checkGrid.setSelected(this.view.isPaintGrid());
        this.spinCmBefEvent.setValue(new Double(this.view.getCmBeforeEvents()));
        this.spinCmAftEvent.setValue(new Double(this.view.getCmAfterEvents()));
        this.colorWidget.removeAllColors();
        Iterator keys = this.view.colors.keySet().iterator();
        while (keys.hasNext()) {
            String key = keys.next().toString();
            String name = this.resources.getString("color." + key);
            Color color = (Color)this.view.colors.get(key);
            this.colorWidget.addColor(key, name, color);
        }
        Almanac almanac = Almanac.getInstance();
        almanac.waitLoaded();
        List cats = almanac.getCategories();
        this.almanacCategories.setChoices(cats);
        this.almanacCategories.setSelection(this.view.getAlmanacCategories());
    }

    public JComponent getEditor() {
        return this;
    }
}

