/*
 * Decompiled with CFR 0.152.
 */
package genj.timeline;

import genj.almanac.Almanac;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.time.PointInTime;
import genj.renderer.Options;
import genj.timeline.ContentRenderer;
import genj.timeline.Model;
import genj.timeline.RulerRenderer;
import genj.util.Registry;
import genj.util.Resources;
import genj.util.WordBuffer;
import genj.util.swing.SliderWidget;
import genj.util.swing.UnitGraphics;
import genj.util.swing.ViewPortAdapter;
import genj.view.ContextProvider;
import genj.view.ContextSelectionEvent;
import genj.view.ToolBarSupport;
import genj.view.ViewContext;
import genj.view.ViewManager;
import genj.window.WindowBroadcastEvent;
import genj.window.WindowBroadcastListener;
import genj.window.WindowManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TimelineView
extends JPanel
implements WindowBroadcastListener,
ToolBarSupport {
    private final Point DPI;
    private final Point2D DPC;
    private Resources resources = Resources.get(this);
    Map colors = new HashMap();
    private Model model;
    private Content content;
    private Set selectedEvents = new HashSet();
    private Ruler ruler;
    private SliderWidget sliderCmPerYear;
    private JScrollPane scrollContent;
    private RulerRenderer rulerRenderer = new RulerRenderer();
    private ContentRenderer contentRenderer = new ContentRenderer();
    private List ignoredAlmanacCategories = new ArrayList();
    static final double MIN_CM_PER_YEAR = 0.1;
    static final double DEF_CM_PER_YEAR = 1.0;
    static final double MAX_CM_PER_YEAR = 10.0;
    static final double MIN_CM_BEF_EVENT = 0.1;
    static final double DEF_CM_BEF_EVENT = 0.5;
    static final double MAX_CM_BEF_EVENT = 2.0;
    static final double MIN_CM_AFT_EVENT = 2.0;
    static final double DEF_CM_AFT_EVENT = 2.0;
    static final double MAX_CM_AFT_EVENT = 9.0;
    private double cmPerYear = 1.0;
    private double cmBefEvent = 0.5;
    private double cmAftEvent = 2.0;
    private double centeredYear = 0.0;
    private boolean isPaintDates = true;
    private boolean isPaintGrid = false;
    private boolean isPaintTags = true;
    private Registry regstry;
    private ViewManager manager;
    private ModelListener callback = new ModelListener();

    public TimelineView(String title, Gedcom gedcom, Registry registry, ViewManager mgr) {
        this.manager = mgr;
        this.DPI = Options.getInstance().getDPI();
        this.DPC = new Point2D.Float((float)this.DPI.x / 2.54f, (float)this.DPI.y / 2.54f);
        this.regstry = registry;
        this.cmPerYear = Math.max(0.1, Math.min(10.0, (double)this.regstry.get("cmperyear", 1.0f)));
        this.cmBefEvent = Math.max(0.1, Math.min(2.0, (double)this.regstry.get("cmbefevent", 0.5f)));
        this.cmAftEvent = Math.max(2.0, Math.min(9.0, (double)this.regstry.get("cmaftevent", 2.0f)));
        this.isPaintDates = this.regstry.get("paintdates", true);
        this.isPaintGrid = this.regstry.get("paintgrid", false);
        this.isPaintTags = this.regstry.get("painttags", false);
        this.colors.put("background", Color.WHITE);
        this.colors.put("text", Color.BLACK);
        this.colors.put("tag", Color.GREEN);
        this.colors.put("date", Color.GRAY);
        this.colors.put("timespan", Color.BLUE);
        this.colors.put("grid", Color.LIGHT_GRAY);
        this.colors.put("selected", Color.RED);
        this.colors = this.regstry.get("color", this.colors);
        String[] ignored = this.regstry.get("almanac.ignore", new String[0]);
        for (int i = 0; i < ignored.length; ++i) {
            this.ignoredAlmanacCategories.add(ignored[i]);
        }
        this.model = new Model(gedcom, this.regstry.get("filter", (String[])null));
        this.model.setTimePerEvent(this.cmBefEvent / this.cmPerYear, this.cmAftEvent / this.cmPerYear);
        this.content = new Content();
        this.ruler = new Ruler();
        this.scrollContent = new JScrollPane(new ViewPortAdapter(this.content));
        this.scrollContent.setColumnHeaderView(new ViewPortAdapter(this.ruler));
        this.scrollContent.getHorizontalScrollBar().addAdjustmentListener(new ChangeCenteredYear());
        this.setLayout(new BorderLayout());
        this.add((Component)this.scrollContent, "Center");
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TimelineView.this.centeredYear = TimelineView.this.regstry.get("centeryear", 0.0f);
                TimelineView.this.scroll2year(TimelineView.this.centeredYear);
            }
        });
    }

    public void addNotify() {
        super.addNotify();
        this.model.addListener(this.callback);
    }

    public void removeNotify() {
        this.model.removeListener(this.callback);
        this.regstry.put("cmperyear", (float)Math.rint(this.cmPerYear * 10.0) / 10.0f);
        this.regstry.put("cmbefevent", (float)this.cmBefEvent);
        this.regstry.put("cmaftevent", (float)this.cmAftEvent);
        this.regstry.put("paintdates", this.isPaintDates);
        this.regstry.put("paintgrid", this.isPaintGrid);
        this.regstry.put("painttags", this.isPaintTags);
        this.regstry.put("filter", this.model.getPaths());
        this.regstry.put("centeryear", (float)this.centeredYear);
        this.regstry.put("color", this.colors);
        Object[] ignored = new String[this.ignoredAlmanacCategories.size()];
        for (int i = 0; i < ignored.length; ++i) {
            ignored[i] = this.ignoredAlmanacCategories.get(i).toString();
        }
        this.regstry.put("almanac.ignore", ignored);
        super.removeNotify();
    }

    public Dimension getPreferredSize() {
        return new Dimension(480, 256);
    }

    public Model getModel() {
        return this.model;
    }

    public Set getAlmanacCategories() {
        HashSet result = new HashSet(Almanac.getInstance().getCategories());
        result.removeAll(this.ignoredAlmanacCategories);
        return result;
    }

    public void setAlmanacCategories(Set set) {
        this.ignoredAlmanacCategories.clear();
        this.ignoredAlmanacCategories.addAll(Almanac.getInstance().getCategories());
        this.ignoredAlmanacCategories.removeAll(set);
        this.repaint();
    }

    public boolean isPaintTags() {
        return this.isPaintTags;
    }

    public void setPaintTags(boolean set) {
        this.isPaintTags = set;
        this.repaint();
    }

    public boolean isPaintDates() {
        return this.isPaintDates;
    }

    public void setPaintDates(boolean set) {
        this.isPaintDates = set;
        this.repaint();
    }

    public boolean isPaintGrid() {
        return this.isPaintGrid;
    }

    public void setPaintGrid(boolean set) {
        this.isPaintGrid = set;
        this.repaint();
    }

    public void setCMPerEvents(double before, double after) {
        this.cmBefEvent = before;
        this.cmAftEvent = after;
        this.model.setTimePerEvent(this.cmBefEvent / this.cmPerYear, this.cmAftEvent / this.cmPerYear);
    }

    public double getCmBeforeEvents() {
        return this.cmBefEvent;
    }

    public double getCmAfterEvents() {
        return this.cmAftEvent;
    }

    public void populate(JToolBar bar) {
        int value = (int)(Math.log((this.cmPerYear - 0.1) / 9.9 * Math.exp(10.0)) * 10.0);
        this.sliderCmPerYear = new SliderWidget(1, 100, Math.min(100, Math.max(1, value)));
        this.sliderCmPerYear.setToolTipText(this.resources.getString("view.peryear.tip"));
        this.sliderCmPerYear.addChangeListener(new ChangeCmPerYear());
        bar.add(this.sliderCmPerYear);
    }

    public boolean handleBroadcastEvent(WindowBroadcastEvent event) {
        ContextSelectionEvent cse = ContextSelectionEvent.narrow(event, this.model.gedcom);
        if (event.isOutbound() || cse == null) {
            return true;
        }
        this.selectedEvents = this.model.getEvents(cse.getContext());
        this.content.repaint();
        return false;
    }

    protected Model.Event getEventAt(Point pos) {
        double year = this.pixel2year(pos.x);
        int layer = pos.y / (this.getFontMetrics(this.getFont()).getHeight() + 1);
        return this.model.getEvent(year, layer);
    }

    protected double pixel2year(int x) {
        return this.model.min + (double)x / (this.DPC.getX() * this.cmPerYear);
    }

    protected void scroll2year(double year) {
        this.centeredYear = year;
        int x = (int)((year - this.model.min) * this.DPC.getX() * this.cmPerYear) - this.scrollContent.getViewport().getWidth() / 2;
        this.scrollContent.getHorizontalScrollBar().setValue(x);
    }

    protected void makeVisible(Model.Event event) {
        double min = this.model.min + (double)this.scrollContent.getHorizontalScrollBar().getValue() / this.DPC.getX() / this.cmPerYear;
        double max = min + (double)this.scrollContent.getViewport().getWidth() / this.DPC.getX() / this.cmPerYear;
        if (event.to > max || event.from < min) {
            this.scroll2year(event.from);
        }
    }

    private class ModelListener
    implements Model.Listener {
        private ModelListener() {
        }

        public void dataChanged() {
            TimelineView.this.repaint();
        }

        public void structureChanged() {
            TimelineView.this.ruler.revalidate();
            TimelineView.this.content.revalidate();
            TimelineView.this.repaint();
        }
    }

    private class ChangeCmPerYear
    implements ChangeListener {
        private ChangeCmPerYear() {
        }

        public void stateChanged(ChangeEvent e) {
            TimelineView.this.cmPerYear = 0.1 + Math.exp((double)TimelineView.this.sliderCmPerYear.getValue() * 0.1) / Math.exp(10.0) * 9.9;
            TimelineView.this.model.setTimePerEvent(TimelineView.this.cmBefEvent / TimelineView.this.cmPerYear, TimelineView.this.cmAftEvent / TimelineView.this.cmPerYear);
        }
    }

    private class ChangeCenteredYear
    implements AdjustmentListener {
        private ChangeCenteredYear() {
        }

        public void adjustmentValueChanged(AdjustmentEvent e) {
            if (TimelineView.this.scrollContent.getHorizontalScrollBar().getValueIsAdjusting()) {
                int x = TimelineView.this.scrollContent.getHorizontalScrollBar().getValue() + TimelineView.this.scrollContent.getViewport().getWidth() / 2;
                TimelineView.this.centeredYear = TimelineView.this.pixel2year(x);
            } else {
                TimelineView.this.scroll2year(TimelineView.this.centeredYear);
            }
        }
    }

    private class Content
    extends JComponent
    implements MouseListener,
    ContextProvider {
        private Content() {
            this.addMouseListener(this);
        }

        public ViewContext getContext() {
            ViewContext ctx = new ViewContext(((TimelineView)TimelineView.this).model.gedcom);
            Iterator events = TimelineView.this.selectedEvents.iterator();
            while (events.hasNext()) {
                Model.Event event = (Model.Event)events.next();
                ctx.addProperty(event.pe);
            }
            return ctx;
        }

        public Dimension getPreferredSize() {
            return new Dimension((int)((((TimelineView)TimelineView.this).model.max - ((TimelineView)TimelineView.this).model.min) * TimelineView.this.DPC.getX() * TimelineView.this.cmPerYear), ((TimelineView)TimelineView.this).model.layers.size() * (this.getFontMetrics(this.getFont()).getHeight() + 1));
        }

        protected void paintComponent(Graphics g) {
            ((TimelineView)TimelineView.this).contentRenderer.selection = TimelineView.this.selectedEvents;
            ((TimelineView)TimelineView.this).contentRenderer.cBackground = (Color)TimelineView.this.colors.get("background");
            ((TimelineView)TimelineView.this).contentRenderer.cText = (Color)TimelineView.this.colors.get("text");
            ((TimelineView)TimelineView.this).contentRenderer.cDate = (Color)TimelineView.this.colors.get("date");
            ((TimelineView)TimelineView.this).contentRenderer.cTag = (Color)TimelineView.this.colors.get("tag");
            ((TimelineView)TimelineView.this).contentRenderer.cTimespan = (Color)TimelineView.this.colors.get("timespan");
            ((TimelineView)TimelineView.this).contentRenderer.cGrid = (Color)TimelineView.this.colors.get("grid");
            ((TimelineView)TimelineView.this).contentRenderer.cSelected = (Color)TimelineView.this.colors.get("selected");
            ((TimelineView)TimelineView.this).contentRenderer.paintDates = TimelineView.this.isPaintDates;
            ((TimelineView)TimelineView.this).contentRenderer.paintGrid = TimelineView.this.isPaintGrid;
            ((TimelineView)TimelineView.this).contentRenderer.paintTags = TimelineView.this.isPaintTags;
            UnitGraphics graphics = new UnitGraphics(g, TimelineView.this.DPC.getX() * TimelineView.this.cmPerYear, this.getFontMetrics(this.getFont()).getHeight() + 1);
            graphics.translate(-((TimelineView)TimelineView.this).model.min, 0.0);
            TimelineView.this.contentRenderer.render(graphics, TimelineView.this.model);
        }

        public void mouseClicked(MouseEvent e) {
            Model.Event hit;
            if (e.getButton() != 1) {
                return;
            }
            if (!e.isShiftDown()) {
                TimelineView.this.selectedEvents.clear();
            }
            if ((hit = TimelineView.this.getEventAt(e.getPoint())) != null) {
                TimelineView.this.selectedEvents.add(hit);
                WindowManager.broadcast(new ContextSelectionEvent(this.getContext(), this));
            }
            this.repaint();
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }
    }

    private class Ruler
    extends JComponent
    implements MouseMotionListener,
    ChangeListener {
        private Ruler() {
        }

        public void addNotify() {
            super.addNotify();
            this.addMouseMotionListener(this);
            Almanac.getInstance().addChangeListener(this);
            ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
        }

        public void removeNotify() {
            this.removeMouseMotionListener(this);
            Almanac.getInstance().removeChangeListener(this);
            super.removeNotify();
        }

        public void stateChanged(ChangeEvent e) {
            this.repaint();
        }

        protected void paintComponent(Graphics g) {
            ((TimelineView)TimelineView.this).rulerRenderer.cBackground = (Color)TimelineView.this.colors.get("background");
            ((TimelineView)TimelineView.this).rulerRenderer.cTick = ((TimelineView)TimelineView.this).rulerRenderer.cText = (Color)TimelineView.this.colors.get("text");
            ((TimelineView)TimelineView.this).rulerRenderer.cTimespan = (Color)TimelineView.this.colors.get("timespan");
            ((TimelineView)TimelineView.this).rulerRenderer.acats = TimelineView.this.getAlmanacCategories();
            UnitGraphics graphics = new UnitGraphics(g, TimelineView.this.DPC.getX() * TimelineView.this.cmPerYear, this.getFontMetrics(this.getFont()).getHeight() + 1);
            graphics.translate(-((TimelineView)TimelineView.this).model.min, 0.0);
            TimelineView.this.rulerRenderer.render(graphics, TimelineView.this.model);
        }

        public Dimension getPreferredSize() {
            return new Dimension(((TimelineView)TimelineView.this).content.getPreferredSize().width, this.getFontMetrics(this.getFont()).getHeight() + 1);
        }

        public void mouseDragged(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
            double year = TimelineView.this.pixel2year(e.getPoint().x);
            PointInTime when = Model.toPointInTime(year);
            int days = (int)Math.ceil(5.0 / TimelineView.this.DPC.getX() / TimelineView.this.cmPerYear * 365.0);
            WordBuffer text = new WordBuffer();
            int cursor = 0;
            try {
                Iterator almanac = Almanac.getInstance().getEvents(when, days, TimelineView.this.getAlmanacCategories());
                if (almanac.hasNext()) {
                    text.append("<html><body>");
                    for (int i = 0; i < 10 && almanac.hasNext(); ++i) {
                        text.append("<div width=\"" + TimelineView.this.getWidth() / 2 + "\">");
                        text.append(almanac.next());
                        text.append("</div>");
                    }
                    text.append("</body></html>");
                    cursor = 2;
                }
            }
            catch (GedcomException ex) {
                // empty catch block
            }
            this.setCursor(Cursor.getPredefinedCursor(cursor));
            this.setToolTipText(text.length() == 0 ? null : text.toString());
        }
    }
}

