/*
 * Decompiled with CFR 0.152.
 */
package genj.timeline;

import genj.almanac.Almanac;
import genj.almanac.Event;
import genj.gedcom.GedcomException;
import genj.gedcom.time.PointInTime;
import genj.timeline.ContentRenderer;
import genj.timeline.Model;
import genj.util.swing.UnitGraphics;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.Set;

public class RulerRenderer
extends ContentRenderer {
    Color cTick = null;
    Set acats = null;
    private Shape tickMark;
    private Shape eventMark;

    public void render(UnitGraphics graphics, Model model) {
        this.init(graphics);
        FontMetrics fm = graphics.getFontMetrics();
        double from = Math.ceil(model.min);
        double to = Math.floor(model.max);
        double width = (double)fm.stringWidth(" 0000 ") * this.dotSize.x;
        this.renderBackground(graphics, model);
        this.renderYear(graphics, model, fm, from, 0.0);
        this.renderYear(graphics, model, fm, to, 1.0);
        this.renderSpan(graphics, model, fm, from += width, to += -width, width);
        this.renderAlmanac(graphics);
    }

    private void renderAlmanac(UnitGraphics g) {
        g.setColor(this.cTimespan);
        Rectangle2D clip = g.getClip();
        PointInTime from = Model.toPointInTime(clip.getX());
        PointInTime to = Model.toPointInTime(clip.getMaxX());
        double timePerPixel = this.dotSize.x;
        Iterator almanac = Almanac.getInstance().getEvents(from, to, this.acats);
        double last = 0.0;
        while (almanac.hasNext()) {
            Event event = (Event)almanac.next();
            try {
                PointInTime time = event.getTime();
                double year = Model.toDouble(time, false);
                if (!(year - last >= timePerPixel)) continue;
                g.draw(this.eventMark, year, 0.0, false);
                last = year;
            }
            catch (GedcomException e) {}
        }
    }

    private void renderSpan(UnitGraphics g, Model model, FontMetrics fm, double from, double to, double width) {
        if (to - from < width || to - from < 1.0) {
            return;
        }
        Rectangle2D clip = g.getClip();
        if (!clip.intersects(from, 0.0, to - from, 1.0)) {
            return;
        }
        double year = Math.rint((from + to) / 2.0);
        if (year - from < width / 2.0 || to - year < width / 2.0) {
            return;
        }
        this.renderYear(g, model, fm, year, 0.5);
        this.renderSpan(g, model, fm, year + width / 2.0, to, width);
        this.renderSpan(g, model, fm, from, year - width / 2.0, width);
    }

    private void renderYear(UnitGraphics g, Model model, FontMetrics fm, double year, double align) {
        g.setColor(this.cTick);
        g.draw(this.tickMark, year, 1.0, true);
        g.setColor(this.cText);
        g.draw(Integer.toString((int)year), year, 1.0, align, 1.0);
    }

    protected void init(UnitGraphics graphics) {
        super.init(graphics);
        GeneralPath gp = new GeneralPath();
        gp.moveTo((float)(0.0 * this.dotSize.x), (float)(0.0 * this.dotSize.y));
        gp.lineTo((float)(3.0 * this.dotSize.x), (float)(-3.0 * this.dotSize.y));
        gp.lineTo((float)(-3.0 * this.dotSize.x), (float)(-3.0 * this.dotSize.y));
        gp.closePath();
        this.tickMark = gp;
        this.eventMark = new Line2D.Double(0.0, 0.0, 0.0, 5.0 * this.dotSize.y);
    }
}

