/*
 * Decompiled with CFR 0.152.
 */
package genj.timeline;

import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.GedcomListener;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyEvent;
import genj.gedcom.PropertyName;
import genj.gedcom.TagPath;
import genj.gedcom.time.Calendar;
import genj.gedcom.time.GregorianCalendar;
import genj.gedcom.time.PointInTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import spin.Spin;

class Model
implements GedcomListener {
    Gedcom gedcom;
    double max = Double.NaN;
    double min = Double.NaN;
    private Set paths = new HashSet();
    private Set tags = new HashSet();
    private static final String[] DEFAULT_PATHS = new String[]{"INDI:BIRT", "FAM:MARR", "INDI:RESI", "INDI:EMIG"};
    List layers;
    double timeBeforeEvent = 0.5;
    double timeAfterEvent = 2.0;
    private List listeners = new ArrayList(1);
    static /* synthetic */ Class class$genj$gedcom$PropertyEvent;

    Model(Gedcom ged, String[] paths) {
        if (paths == null) {
            paths = DEFAULT_PATHS;
        }
        this.setPathsInternally(Arrays.asList(paths));
        this.gedcom = ged;
        this.createEvents();
    }

    void addListener(Listener listener) {
        this.listeners.add(listener);
        if (this.listeners.size() == 1) {
            this.gedcom.addGedcomListener((GedcomListener)Spin.over(this));
        }
    }

    void removeListener(Listener listener) {
        this.listeners.remove(listener);
        if (this.listeners.isEmpty()) {
            this.gedcom.removeGedcomListener((GedcomListener)Spin.over(this));
        }
    }

    void setTimePerEvent(double before, double after) {
        if (this.timeBeforeEvent == before && this.timeAfterEvent == after) {
            return;
        }
        this.timeBeforeEvent = before;
        this.timeAfterEvent = after;
        if (this.layers != null) {
            this.layoutEvents();
        }
    }

    static double toDouble(PointInTime pit, boolean roundUp) throws GedcomException {
        GregorianCalendar calendar = PointInTime.GREGORIAN;
        if (pit.getCalendar() != calendar) {
            pit = pit.getPointInTime(calendar);
        }
        int year = pit.getYear();
        double result = year;
        int month = pit.getMonth();
        if (month == Integer.MAX_VALUE) {
            return roundUp ? result + 1.0 : result;
        }
        double months = calendar.getMonths();
        result += (double)month / months;
        int day = pit.getDay();
        if (day == Integer.MAX_VALUE) {
            return roundUp ? result + 1.0 / months : result;
        }
        double days = ((Calendar)calendar).getDays(month, year);
        return result += (double)day / months / days;
    }

    static PointInTime toPointInTime(double year) {
        GregorianCalendar calendar = PointInTime.GREGORIAN;
        int months = calendar.getMonths();
        int y = (int)Math.floor(year);
        int m = (int)Math.floor(year % 1.0 * (double)months);
        int days = ((Calendar)calendar).getDays(m, y);
        int d = (int)Math.floor(year % 1.0 * (double)months % 1.0 * (double)days);
        return new PointInTime(d, m, y);
    }

    protected Event getEvent(double year, int layer) {
        Iterator events = ((List)this.layers.get(layer)).iterator();
        while (events.hasNext()) {
            Event event = (Event)events.next();
            if (!(event.from - this.timeBeforeEvent < year) || !(year < event.to + this.timeAfterEvent)) continue;
            return event;
        }
        return null;
    }

    protected Set getEvents(Context context) {
        HashSet<Event> propertyHits = new HashSet<Event>();
        HashSet<Event> entityHits = new HashSet<Event>();
        Property[] props = context.getProperties();
        Entity[] ents = context.getEntities();
        for (int l = 0; l < this.layers.size(); ++l) {
            Iterator events = ((List)this.layers.get(l)).iterator();
            while (events.hasNext()) {
                Event event = (Event)events.next();
                for (int j = 0; j < ents.length; ++j) {
                    if (ents[j] != event.getEntity()) continue;
                    entityHits.add(event);
                }
                for (int i = 0; i < props.length; ++i) {
                    if (event.getProperty() != props[i] && !event.getProperty().contains(props[i])) continue;
                    propertyHits.add(event);
                }
            }
        }
        return propertyHits.isEmpty() ? entityHits : propertyHits;
    }

    public Set getPaths() {
        return Collections.unmodifiableSet(this.paths);
    }

    public void setPaths(Collection set) {
        this.setPathsInternally(set);
        this.createEvents();
    }

    private void setPathsInternally(Collection set) {
        this.paths.clear();
        this.tags.clear();
        Iterator it = set.iterator();
        while (it.hasNext()) {
            Object next;
            block3: {
                next = it.next();
                try {
                    if (next instanceof TagPath) break block3;
                    next = new TagPath(next.toString());
                }
                catch (IllegalArgumentException e) {
                    continue;
                }
            }
            this.paths.add(next);
            this.tags.add(((TagPath)next).getLast());
        }
    }

    private void fireStructureChanged() {
        for (int l = this.listeners.size() - 1; l >= 0; --l) {
            ((Listener)this.listeners.get(l)).structureChanged();
        }
    }

    private void fireDataChanged() {
        for (int l = this.listeners.size() - 1; l >= 0; --l) {
            ((Listener)this.listeners.get(l)).dataChanged();
        }
    }

    private final void contentEvents(Entity entity) {
        for (int l = 0; l < this.layers.size(); ++l) {
            List layer = (List)this.layers.get(l);
            Iterator events = layer.iterator();
            while (events.hasNext()) {
                Event event = (Event)events.next();
                if (event.pe.getEntity() != entity) continue;
                event.content();
            }
        }
    }

    private final void layoutEvents() {
        this.min = Double.MAX_VALUE;
        this.max = -1.7976931348623157E308;
        List old = this.layers;
        this.layers = new ArrayList(10);
        for (int l = 0; l < old.size(); ++l) {
            List layer = (List)old.get(l);
            Iterator events = layer.iterator();
            while (events.hasNext()) {
                Event event = (Event)events.next();
                this.insertEvent(event);
            }
        }
        this.max += this.timeAfterEvent;
        this.min -= this.timeBeforeEvent;
        this.fireStructureChanged();
    }

    private final void createEvents() {
        this.min = Double.MAX_VALUE;
        this.max = -1.7976931348623157E308;
        this.layers = new ArrayList(10);
        if (this.gedcom != null) {
            this.createEventsFrom(this.gedcom.getEntities("INDI").iterator());
            this.createEventsFrom(this.gedcom.getEntities("FAM").iterator());
        }
        this.max += this.timeAfterEvent;
        this.min -= this.timeBeforeEvent;
        this.fireStructureChanged();
    }

    private final void createEventsFrom(Iterator es) {
        while (es.hasNext()) {
            Entity e = (Entity)es.next();
            List ps = e.getProperties(class$genj$gedcom$PropertyEvent == null ? Model.class$("genj.gedcom.PropertyEvent") : class$genj$gedcom$PropertyEvent);
            for (int j = 0; j < ps.size(); ++j) {
                PropertyEvent pe = (PropertyEvent)ps.get(j);
                if (!this.tags.contains(pe.getTag())) continue;
                this.createEventFrom(pe);
            }
        }
    }

    private final void createEventFrom(PropertyEvent pe) {
        PropertyDate pd = pe.getDate();
        if (pd == null || !pd.isValid()) {
            return;
        }
        try {
            this.insertEvent(new Event(pe, pd));
        }
        catch (GedcomException gedcomException) {
            // empty catch block
        }
    }

    private final void insertEvent(Event e) {
        this.min = Math.min(Math.floor(e.from), this.min);
        this.max = Math.max(Math.ceil(e.to), this.max);
        for (int l = 0; l < this.layers.size(); ++l) {
            List layer = (List)this.layers.get(l);
            if (!this.insertEvent(e, layer)) continue;
            return;
        }
        LinkedList<Event> layer = new LinkedList<Event>();
        this.layers.add(layer);
        layer.add(e);
    }

    private final boolean insertEvent(Event candidate, List layer) {
        ListIterator<Event> events = layer.listIterator();
        do {
            Event event = (Event)events.next();
            if (candidate.to + this.timeAfterEvent < event.from - this.timeBeforeEvent) {
                events.previous();
                events.add(candidate);
                return true;
            }
            if (!(candidate.from - this.timeBeforeEvent < event.to + this.timeAfterEvent)) continue;
            return false;
        } while (events.hasNext());
        events.add(candidate);
        return true;
    }

    public void gedcomEntityAdded(Gedcom gedcom, Entity entity) {
        this.createEvents();
    }

    public void gedcomEntityDeleted(Gedcom gedcom, Entity entity) {
        this.createEvents();
    }

    public void gedcomPropertyAdded(Gedcom gedcom, Property property, int pos, Property added) {
        this.gedcomPropertyDeleted(gedcom, added, -1, added);
    }

    public void gedcomPropertyChanged(Gedcom gedcom, Property property) {
        this.gedcomPropertyDeleted(gedcom, property, -1, property);
    }

    public void gedcomPropertyDeleted(Gedcom gedcom, Property property, int pos, Property deleted) {
        if (deleted instanceof PropertyDate) {
            this.createEvents();
        } else if (deleted instanceof PropertyName) {
            this.contentEvents(property.getEntity());
            this.fireDataChanged();
        }
    }

    static interface Listener {
        public void dataChanged();

        public void structureChanged();
    }

    class Event {
        double from;
        double to;
        PropertyEvent pe;
        PropertyDate pd;
        String content;

        Event(PropertyEvent propEvent, PropertyDate propDate) throws GedcomException {
            this.pe = propEvent;
            this.pd = propDate;
            this.from = Model.toDouble(propDate.getStart(), propDate.getFormat() == PropertyDate.AFTER);
            double d = this.to = propDate.isRange() ? Model.toDouble(propDate.getEnd(), false) : this.from;
            if (this.from > this.to) {
                throw new GedcomException("");
            }
            this.content();
        }

        private final void content() {
            Entity e = this.pe.getEntity();
            this.content = e.toString();
        }

        public String toString() {
            return this.content;
        }

        Entity getEntity() {
            return this.pe.getEntity();
        }

        PropertyEvent getProperty() {
            return this.pe;
        }
    }
}

