/*
 * Decompiled with CFR 0.152.
 */
package genj.timeline;

import genj.gedcom.PropertyDate;
import genj.renderer.Options;
import genj.timeline.Model;
import genj.util.swing.ImageIcon;
import genj.util.swing.UnitGraphics;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ContentRenderer {
    protected Point2D.Double dotSize = new Point2D.Double();
    protected GeneralPath fromMark;
    protected GeneralPath toMark;
    boolean paintTags = false;
    boolean paintDates = true;
    boolean paintGrid = false;
    Set selection = new HashSet();
    Color cBackground = null;
    Color cText = null;
    Color cTag = null;
    Color cDate = null;
    Color cTimespan = null;
    Color cGrid = null;
    Color cSelected = null;

    public void render(UnitGraphics graphics, Model model) {
        this.init(graphics);
        this.renderBackground(graphics, model);
        this.renderGrid(graphics, model);
        this.renderLayers(graphics, model);
    }

    protected void renderBackground(UnitGraphics g, Model model) {
        if (this.cBackground == null) {
            return;
        }
        g.setColor(this.cBackground);
        Rectangle2D.Double r = new Rectangle2D.Double(model.min, 0.0, model.max - model.min, 1024.0);
        g.draw(r, 0.0, 0.0, true);
    }

    private final void renderGrid(UnitGraphics g, Model model) {
        if (!this.paintGrid) {
            return;
        }
        g.setColor(this.cGrid);
        Rectangle2D r = g.getClip();
        int layers = model.layers.size();
        double from = Math.floor(r.getMinX());
        double to = Math.ceil(r.getMaxX());
        for (double year = from; year <= to; year += 1.0) {
            g.draw(year, 0.0, year, layers);
        }
    }

    private final void renderLayers(UnitGraphics g, Model model) {
        Rectangle2D clip = g.getClip();
        List layers = model.layers;
        for (int l = 0; l < layers.size(); ++l) {
            if ((double)l < Math.floor(clip.getMinY()) || (double)l > Math.ceil(clip.getMaxY())) continue;
            List layer = (List)layers.get(l);
            this.renderEvents(g, model, layer, l);
        }
    }

    private final void renderEvents(UnitGraphics g, Model model, List layer, int level) {
        Rectangle2D clip = g.getClip();
        Iterator events = layer.iterator();
        Model.Event event = (Model.Event)events.next();
        while (true) {
            Model.Event next;
            Model.Event event2 = next = events.hasNext() ? (Model.Event)events.next() : null;
            if ((next == null || next.from > clip.getMinX()) && event.from < clip.getMaxX()) {
                this.renderEvent(g, model, event, next, level);
            }
            if (next == null) break;
            event = next;
        }
    }

    private final void renderEvent(UnitGraphics g, Model model, Model.Event event, Model.Event next, int level) {
        boolean em = this.selection.contains(event);
        FontMetrics fm = g.getFontMetrics();
        g.setColor(this.cTimespan);
        PropertyDate.Format format = event.pd.getFormat();
        if (format == PropertyDate.AFTER || format == PropertyDate.FROM) {
            g.draw(this.fromMark, event.from, (double)(level + 1), true);
        } else if (format == PropertyDate.BEFORE || format == PropertyDate.TO) {
            g.draw(this.toMark, event.from, (double)(level + 1), true);
        } else {
            g.draw(this.fromMark, event.from, (double)(level + 1), true);
            g.draw(event.from, (double)(level + 1) - this.dotSize.y, event.to, (double)(level + 1) - this.dotSize.y);
            g.draw(this.toMark, event.to, (double)(level + 1), true);
        }
        g.pushClip(event.from, level, next == null ? 2.147483647E9 : next.from, level + 1);
        ImageIcon img = event.pe.getImage(false);
        g.draw(img, event.from, (double)level + 0.5, 0.0, 0.5);
        int dx = img.getIconWidth() + 2;
        if (this.paintTags) {
            String tag = event.pe.getTag();
            g.setColor(this.cTag);
            g.draw(tag, event.from, level + 1, 0.0, 1.0, dx, 0);
            dx += fm.stringWidth(tag) + fm.charWidth(' ');
        }
        g.setFont(Options.getInstance().getDefaultFont());
        g.setColor(em ? this.cSelected : this.cText);
        String txt = event.content;
        g.draw(txt, event.from, level + 1, 0.0, 1.0, dx, 0);
        dx += fm.stringWidth(txt) + fm.charWidth(' ');
        if (this.paintDates) {
            String date = " (" + event.pd.getDisplayValue() + ')';
            g.setColor(this.cDate);
            g.draw(date, event.from, level + 1, 0.0, 1.0, dx, 0);
        }
        g.popClip();
    }

    protected void init(UnitGraphics graphics) {
        this.dotSize.setLocation(1.0 / graphics.getUnit().getX(), 1.0 / graphics.getUnit().getY());
        this.fromMark = new GeneralPath();
        this.fromMark.moveTo((float)(3.0 * this.dotSize.x), (float)(-1.0 * this.dotSize.y));
        this.fromMark.lineTo((float)(-1.0 * this.dotSize.x), (float)(-5.0 * this.dotSize.y));
        this.fromMark.lineTo((float)(-1.0 * this.dotSize.x), (float)(3.0 * this.dotSize.y));
        this.fromMark.closePath();
        this.toMark = new GeneralPath();
        this.toMark.moveTo((float)(-3.0 * this.dotSize.x), (float)(-1.0 * this.dotSize.y));
        this.toMark.lineTo((float)(1.0 * this.dotSize.x), (float)(-6.0 * this.dotSize.y));
        this.toMark.lineTo((float)(1.0 * this.dotSize.x), (float)(4.0 * this.dotSize.y));
        this.toMark.closePath();
    }
}

