/*
 * Decompiled with CFR 0.152.
 */
package genj.table;

import genj.common.PathTreeWidget;
import genj.gedcom.Gedcom;
import genj.gedcom.Grammar;
import genj.gedcom.Property;
import genj.gedcom.TagPath;
import genj.table.TableView;
import genj.util.GridBagHelper;
import genj.util.Resources;
import genj.util.swing.Action2;
import genj.util.swing.ButtonHelper;
import genj.util.swing.ImageIcon;
import genj.util.swing.ListSelectionWidget;
import genj.view.Settings;
import genj.view.ViewManager;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TableViewSettings
extends JPanel
implements Settings {
    private JComboBox cTypes;
    private PathTreeWidget pathTree;
    private ListSelectionWidget pathList;
    private TableView table;
    private Resources resources = Resources.get(this);

    public void init(ViewManager manager) {
        GridBagHelper gh = new GridBagHelper(this);
        this.cTypes = new JComboBox();
        for (int i = 0; i < Gedcom.ENTITIES.length; ++i) {
            this.cTypes.addItem(Gedcom.getName(Gedcom.ENTITIES[i], true));
        }
        this.cTypes.addActionListener(new ActionChooseEntity());
        this.pathTree = new PathTreeWidget();
        PathTreeWidget.Listener plistener = new PathTreeWidget.Listener(){

            public void handleSelection(TagPath path, boolean on) {
                if (!on) {
                    TableViewSettings.this.pathList.removeChoice(path);
                } else {
                    TableViewSettings.this.pathList.addChoice(path);
                }
            }
        };
        this.pathTree.addListener(plistener);
        this.pathList = new ListSelectionWidget(){

            protected ImageIcon getIcon(Object choice) {
                TagPath path = (TagPath)choice;
                return Grammar.V55.getMeta(path).getImage();
            }
        };
        ButtonHelper bh = new ButtonHelper().setInsets(0);
        AbstractButton bUp = bh.create(new ActionUpDown(true));
        AbstractButton bDown = bh.create(new ActionUpDown(false));
        gh.add(new JLabel(this.resources.getString("info.entities")), 0, 1, 1, 1);
        gh.add(this.cTypes, 1, 1, 2, 1, 17);
        gh.add(new JLabel(this.resources.getString("info.columns")), 0, 2, 1, 1);
        gh.add(this.pathTree, 1, 2, 2, 2, 68);
        gh.add(new JLabel(this.resources.getString("info.order")), 0, 4, 1, 1);
        gh.add(bUp, 0, 5, 1, 1, 1);
        gh.add(bDown, 0, 6, 1, 1, 1);
        gh.add(this.pathList, 1, 4, 2, 4, 68);
    }

    public void setView(JComponent view) {
        this.table = (TableView)view;
        this.cTypes.setSelectedItem(Gedcom.getName(this.table.getMode().getTag(), true));
    }

    public void apply() {
        String tag = Gedcom.ENTITIES[this.cTypes.getSelectedIndex()];
        List choices = this.pathList.getChoices();
        TagPath[] paths = choices.toArray(new TagPath[choices.size()]);
        this.table.getMode(tag).setPaths(paths);
    }

    public void reset() {
        String tag = Gedcom.ENTITIES[this.cTypes.getSelectedIndex()];
        Object[] selectedPaths = this.table.getMode(tag).getPaths();
        TagPath[] usedPaths = this.table.gedcom.getGrammar().getAllPaths(tag, Property.class);
        this.pathTree.setPaths(usedPaths, (TagPath[])selectedPaths);
        this.pathList.setChoices(selectedPaths);
    }

    public JComponent getEditor() {
        return this;
    }

    private class ActionUpDown
    extends Action2 {
        private boolean up;

        protected ActionUpDown(boolean up) {
            this.up = up;
            if (up) {
                this.setText(TableViewSettings.this.resources, "info.up");
            } else {
                this.setText(TableViewSettings.this.resources, "info.down");
            }
        }

        public void execute() {
            if (this.up) {
                TableViewSettings.this.pathList.up();
            } else {
                TableViewSettings.this.pathList.down();
            }
        }
    }

    private class ActionChooseEntity
    extends Action2 {
        private ActionChooseEntity() {
        }

        public void execute() {
            if (TableViewSettings.this.table == null) {
                return;
            }
            TableViewSettings.this.table.setMode(TableViewSettings.this.table.getMode(Gedcom.ENTITIES[TableViewSettings.this.cTypes.getSelectedIndex()]));
            TableViewSettings.this.reset();
        }
    }
}

