/*
 * Decompiled with CFR 0.152.
 */
package genj.table;

import genj.gedcom.Property;
import genj.gedcom.PropertySimpleValue;
import genj.print.Printer;
import genj.renderer.PropertyRenderer;
import genj.table.TableView;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.geom.Dimension2D;
import javax.swing.JComponent;
import javax.swing.table.TableModel;

public class TableViewPrinter
implements Printer {
    private int pad = 2;
    private int[] rowHeights;
    private int[] colWidths;
    private int[] colsOnPage;
    private int[] rowsOnPage;
    private int headerHeight;
    private int pageWidth;
    private int pageHeight;
    private TableView table;
    private Font font = new Font("SansSerif", 0, 8);
    private FontRenderContext context = new FontRenderContext(null, false, true);
    private Property header = new PropertySimpleValue();
    private int maxColumnWidth = 25;

    public int getMaxColumnWidth() {
        return this.maxColumnWidth;
    }

    public void setMaxColumnWidth(int set) {
        this.maxColumnWidth = Math.max(1, Math.min(100, set));
    }

    public void setView(JComponent view) {
        this.table = (TableView)view;
    }

    public Dimension calcSize(Dimension2D pageSizeInInches, Point dpi) {
        int col;
        TableModel model = this.table.getModel();
        this.pageWidth = (int)Math.ceil(pageSizeInInches.getWidth() * (double)dpi.x);
        this.pageHeight = (int)Math.ceil(pageSizeInInches.getHeight() * (double)dpi.y);
        this.headerHeight = 0;
        this.rowHeights = new int[model.getRowCount()];
        this.colWidths = new int[model.getColumnCount()];
        for (int col2 = 0; col2 < this.colWidths.length; ++col2) {
            this.header.setValue(model.getColumnName(col2));
            this.calcSize(-1, col2, this.header, dpi);
        }
        boolean height = false;
        for (int row = 0; row < this.rowHeights.length; ++row) {
            for (col = 0; col < this.colWidths.length; ++col) {
                this.calcSize(row, col, (Property)model.getValueAt(row, col), dpi);
            }
        }
        int pagesx = 1;
        int pagesy = 1;
        this.colsOnPage = new int[this.colWidths.length];
        this.rowsOnPage = new int[this.rowHeights.length];
        int width = 0;
        for (col = 0; col < this.colWidths.length; ++col) {
            if (width + this.colWidths[col] > this.pageWidth) {
                width = 0;
                ++pagesx;
            }
            int n = pagesx - 1;
            this.colsOnPage[n] = this.colsOnPage[n] + 1;
            width += this.colWidths[col] + this.pad;
        }
        int height2 = this.headerHeight + this.pad;
        for (int row = 0; row < this.rowHeights.length; ++row) {
            if (height2 + this.rowHeights[row] > this.pageHeight) {
                height2 = this.headerHeight + this.pad;
                ++pagesy;
            }
            int n = pagesy - 1;
            this.rowsOnPage[n] = this.rowsOnPage[n] + 1;
            height2 += this.rowHeights[row] + this.pad;
        }
        return new Dimension(pagesx, pagesy);
    }

    private void calcSize(int row, int col, Property prop, Point dpi) {
        if (prop == null) {
            return;
        }
        Dimension2D dim = PropertyRenderer.get(prop).getSize(this.font, this.context, prop, 10, dpi);
        if (row < 0) {
            this.headerHeight = this.max(dim.getHeight(), this.headerHeight, this.pageHeight - this.headerHeight - this.pad);
        } else {
            this.rowHeights[row] = this.max(dim.getHeight(), this.rowHeights[row], this.pageHeight - this.headerHeight - this.pad);
        }
        this.colWidths[col] = this.max(dim.getWidth(), this.colWidths[col], this.pageWidth * this.maxColumnWidth / 100);
    }

    private int max(double one, int two, int limit) {
        return Math.min(limit, (int)Math.max(Math.ceil(one), (double)two));
    }

    public void renderPage(Graphics2D g, Point page, Dimension2D pageSizeInInches, Point dpi, boolean preview) {
        if (this.colsOnPage[page.x] == 0) {
            return;
        }
        g.scale((float)dpi.x / 72.0f, (float)dpi.y / 72.0f);
        g.setColor(Color.BLACK);
        g.setFont(this.font);
        TableModel model = this.table.getModel();
        int scol = 0;
        int cols = 0;
        for (int c = 0; c < page.x; ++c) {
            scol += this.colsOnPage[c];
        }
        cols = this.colsOnPage[page.x];
        int x = 0;
        for (int col = 0; col < cols; ++col) {
            Rectangle r = new Rectangle(x, 0, this.colWidths[scol + col], this.headerHeight);
            this.header.setValue(model.getColumnName(scol + col));
            this.render(g, r, this.header, dpi);
            x = (int)((double)x + (r.getWidth() + (double)this.pad));
            if (col >= cols - 1) continue;
            g.drawLine(x - this.pad / 2, 0, x - this.pad / 2, this.pageHeight);
        }
        g.drawLine(0, this.headerHeight + this.pad / 2, this.pageWidth, this.headerHeight + this.pad / 2);
        if (this.rowsOnPage.length > 0) {
            int rows = this.rowsOnPage[page.y];
            int srow = 0;
            for (int r = 0; r < page.y; ++r) {
                srow += this.rowsOnPage[r];
            }
            int y = this.headerHeight + this.pad;
            for (int row = 0; row < rows; ++row) {
                int x2 = 0;
                for (int col = 0; col < cols; ++col) {
                    Rectangle r = new Rectangle(x2, y, this.colWidths[scol + col], this.rowHeights[srow + row]);
                    this.render(g, r, (Property)model.getValueAt(srow + row, scol + col), dpi);
                    x2 += this.colWidths[scol + col] + this.pad;
                }
                y += this.rowHeights[srow + row] + this.pad;
                if (row >= rows - 1) continue;
                g.drawLine(0, y - this.pad / 2, this.pageWidth, y - this.pad / 2);
            }
        }
    }

    private void render(Graphics2D g, Rectangle r, Property prop, Point dpi) {
        if (prop == null) {
            return;
        }
        Shape clip = g.getClip();
        g.clip(r);
        PropertyRenderer.get(prop).render(g, r, prop, 10, dpi);
        g.setClip(clip);
    }
}

