/*
 * Decompiled with CFR 0.152.
 */
package genj.table;

import genj.common.AbstractPropertyTableModel;
import genj.common.PropertyTableWidget;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomListener;
import genj.gedcom.Property;
import genj.gedcom.TagPath;
import genj.util.Registry;
import genj.util.Resources;
import genj.util.swing.Action2;
import genj.util.swing.ButtonHelper;
import genj.view.ToolBarSupport;
import genj.view.ViewManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.InputMap;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.table.TableModel;

public class TableView
extends JPanel
implements ToolBarSupport {
    private static final Logger LOG = Logger.getLogger("genj.table");
    private Resources resources = Resources.get(this);
    Gedcom gedcom;
    private ViewManager manager;
    private Registry registry;
    private String title;
    PropertyTableWidget propertyTable;
    private GedcomListener listener;
    private Map modes = new HashMap();
    private Mode currentMode;

    public TableView(String titl, Gedcom gedcom, Registry registry, ViewManager mgr) {
        this.modes.put("INDI", new Mode("INDI", new String[]{"INDI", "INDI:NAME", "INDI:SEX", "INDI:BIRT:DATE", "INDI:BIRT:PLAC", "INDI:FAMS", "INDI:FAMC", "INDI:OBJE:FILE"}));
        this.modes.put("FAM", new Mode("FAM", new String[]{"FAM", "FAM:MARR:DATE", "FAM:MARR:PLAC", "FAM:HUSB", "FAM:WIFE", "FAM:CHIL"}));
        this.modes.put("OBJE", new Mode("OBJE", new String[]{"OBJE", "OBJE:TITL"}));
        this.modes.put("NOTE", new Mode("NOTE", new String[]{"NOTE", "NOTE:NOTE"}));
        this.modes.put("SOUR", new Mode("SOUR", new String[]{"SOUR", "SOUR:TITL", "SOUR:TEXT"}));
        this.modes.put("SUBM", new Mode("SUBM", new String[]{"SUBM", "SUBM:NAME"}));
        this.modes.put("REPO", new Mode("REPO", new String[]{"REPO", "REPO:NAME", "REPO:NOTE"}));
        this.currentMode = this.getMode("INDI");
        this.gedcom = gedcom;
        this.registry = registry;
        this.title = titl;
        this.manager = mgr;
        this.loadProperties();
        this.propertyTable = new PropertyTableWidget(null);
        this.propertyTable.setAutoResize(false);
        this.setLayout(new BorderLayout());
        this.add((Component)this.propertyTable, "Center");
        new NextMode(true).install(this, 2);
        new NextMode(false).install(this, 2);
    }

    TableModel getModel() {
        return this.propertyTable.getTableModel();
    }

    public Dimension getPreferredSize() {
        return new Dimension(480, 320);
    }

    public void addNotify() {
        super.addNotify();
        Mode set = this.currentMode;
        this.currentMode = null;
        this.setMode(set);
    }

    public void removeNotify() {
        this.saveProperties();
        super.removeNotify();
        this.propertyTable.setModel(null);
    }

    Mode getMode() {
        return this.currentMode;
    }

    Mode getMode(String tag) {
        Mode mode = (Mode)this.modes.get(tag);
        if (mode == null) {
            mode = new Mode(tag, new String[0]);
            this.modes.put(tag, mode);
        }
        return mode;
    }

    void setMode(Mode set) {
        if (this.currentMode != null) {
            this.currentMode.save(this.registry);
        }
        this.currentMode = set;
        this.propertyTable.setModel(new Model(this.currentMode));
        this.propertyTable.setColumnLayout(this.currentMode.layout);
    }

    public void populate(JToolBar bar) {
        ButtonHelper bh = new ButtonHelper().setInsets(0).setContainer(bar);
        InputMap inputs = this.getInputMap(2);
        boolean j = true;
        for (int i = 0; i < Gedcom.ENTITIES.length; ++i) {
            String tag = Gedcom.ENTITIES[i];
            SwitchMode change = new SwitchMode(this.getMode(tag));
            bh.create(change);
        }
    }

    private void loadProperties() {
        Iterator it = this.modes.values().iterator();
        while (it.hasNext()) {
            Mode mode = (Mode)it.next();
            mode.load(this.registry);
        }
        String tag = this.registry.get("mode", "");
        if (this.modes.containsKey(tag)) {
            this.currentMode = this.getMode(tag);
        }
    }

    private void saveProperties() {
        this.registry.put("mode", this.currentMode.getTag());
        Iterator it = this.modes.values().iterator();
        while (it.hasNext()) {
            Mode mode = (Mode)it.next();
            mode.save(this.registry);
        }
    }

    class Mode {
        private String tag;
        private String[] defaults;
        private TagPath[] paths;
        private String layout;

        private Mode(String t, String[] d) {
            this.tag = t;
            this.defaults = d;
            this.paths = TagPath.toArray(this.defaults);
        }

        private void load(Registry r) {
            String[] ps = r.get(this.tag + ".paths", (String[])null);
            if (ps != null) {
                this.paths = TagPath.toArray(ps);
            }
            this.layout = r.get(this.tag + ".layout", (String)null);
        }

        void setPaths(TagPath[] set) {
            this.paths = set;
            if (TableView.this.currentMode == this) {
                TableView.this.setMode(TableView.this.currentMode);
            }
        }

        TagPath[] getPaths() {
            return this.paths;
        }

        private void save(Registry r) {
            if (TableView.this.currentMode == this) {
                this.layout = TableView.this.propertyTable.getColumnLayout();
            }
            TableView.this.registry.put(this.tag + ".paths", this.paths);
            TableView.this.registry.put(this.tag + ".layout", this.layout);
        }

        String getTag() {
            return this.tag;
        }
    }

    private class Model
    extends AbstractPropertyTableModel {
        private Mode mode;
        private List rows;

        private Model(Mode set) {
            this.mode = set;
        }

        public Gedcom getGedcom() {
            return TableView.this.gedcom;
        }

        public int getNumCols() {
            return this.mode.getPaths().length;
        }

        public int getNumRows() {
            if (this.rows == null) {
                this.rows = new ArrayList(TableView.this.gedcom.getEntities(this.mode.getTag()));
            }
            return this.rows.size();
        }

        public TagPath getPath(int col) {
            return this.mode.getPaths()[col];
        }

        public Property getProperty(int row) {
            this.getNumRows();
            Property result = (Property)this.rows.get(row);
            if (result == null) {
                return result;
            }
            if (result.getEntity() == null) {
                result = null;
                this.rows.set(row, null);
            }
            return result;
        }

        public void gedcomEntityAdded(Gedcom gedcom, Entity entity) {
            if (!this.mode.getTag().equals(entity.getTag())) {
                return;
            }
            this.rows.add(entity);
            this.fireRowsAdded(this.rows.size() - 1, this.rows.size() - 1);
        }

        public void gedcomEntityDeleted(Gedcom gedcom, Entity entity) {
            if (!this.mode.getTag().equals(entity.getTag())) {
                return;
            }
            for (int i = 0; i < this.rows.size(); ++i) {
                if (this.rows.get(i) != entity) continue;
                this.rows.remove(i);
                this.fireRowsDeleted(i, i);
                return;
            }
            LOG.warning("got notified that entity " + entity.getId() + " was deleted but it wasn't in rows in the first place");
        }

        public void gedcomPropertyAdded(Gedcom gedcom, Property property, int pos, Property added) {
            this.invalidate(gedcom, property.getEntity(), property.getPath());
        }

        public void gedcomPropertyChanged(Gedcom gedcom, Property property) {
            this.invalidate(gedcom, property.getEntity(), property.getPath());
        }

        public void gedcomPropertyDeleted(Gedcom gedcom, Property property, int pos, Property deleted) {
            this.invalidate(gedcom, property.getEntity(), new TagPath(property.getPath(), deleted.getTag()));
        }

        private void invalidate(Gedcom gedcom, Entity entity, TagPath path) {
            if (!this.mode.getTag().equals(entity.getTag())) {
                return;
            }
            TagPath[] paths = this.mode.getPaths();
            for (int i = 0; i < paths.length; ++i) {
                if (!paths[i].equals(path)) continue;
                for (int j = 0; j < this.rows.size(); ++j) {
                    if (this.rows.get(j) != entity) continue;
                    this.fireRowsChanged(j, j, i);
                    return;
                }
            }
        }
    }

    private class SwitchMode
    extends Action2 {
        private Mode mode;

        SwitchMode(Mode mode) {
            this.mode = mode;
            this.setTip(TableView.this.resources.getString("mode.tip", Gedcom.getName(mode.getTag(), true)));
            this.setImage(Gedcom.getEntityImage(mode.getTag()));
        }

        public void execute() {
            TableView.this.setMode(this.mode);
        }
    }

    private class NextMode
    extends Action2 {
        private int dir;

        private NextMode(boolean left) {
            int vk;
            if (left) {
                vk = 37;
                this.dir = -1;
            } else {
                vk = 39;
                this.dir = 1;
            }
            this.setAccelerator(KeyStroke.getKeyStroke(vk, 128));
        }

        protected void execute() {
            int next = -1;
            int j = Gedcom.ENTITIES.length;
            for (int i = 0; i < j; ++i) {
                next = (i + j + this.dir) % Gedcom.ENTITIES.length;
                if (TableView.this.currentMode == TableView.this.getMode(Gedcom.ENTITIES[i])) break;
            }
            TableView.this.setMode(TableView.this.getMode(Gedcom.ENTITIES[next]));
        }
    }
}

