/*
 * Decompiled with CFR 0.152.
 */
package genj.search;

import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomListener;
import genj.gedcom.Grammar;
import genj.gedcom.MetaProperty;
import genj.gedcom.Property;
import genj.gedcom.TagPath;
import genj.search.Hit;
import genj.search.Matcher;
import genj.search.RegExMatcher;
import genj.search.SimpleMatcher;
import genj.util.GridBagHelper;
import genj.util.Registry;
import genj.util.Resources;
import genj.util.swing.Action2;
import genj.util.swing.ButtonHelper;
import genj.util.swing.ChoiceWidget;
import genj.util.swing.HeadlessLabel;
import genj.util.swing.ImageIcon;
import genj.util.swing.PopupWidget;
import genj.view.ContextProvider;
import genj.view.ContextSelectionEvent;
import genj.view.ToolBarSupport;
import genj.view.ViewContext;
import genj.view.ViewManager;
import genj.window.WindowManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import spin.Spin;

public class SearchView
extends JPanel
implements ToolBarSupport {
    private static final String OPEN = "<font color=red>";
    private static final String CLOSE = "</font>";
    private static final String NEWLINE = "<br>";
    private static final int MAX_HITS = 255;
    private static final String[] DEFAULT_VALUES = new String[]{"M(a|e)(i|y)er", "San.+Francisco", "^(M|F)"};
    private static final String[] DEFAULT_PATHS = new String[]{"INDI", "INDI:NAME", "INDI:BIRT", "INDI:OCCU", "INDI:NOTE", "INDI:RESI", "FAM"};
    private static final int MAX_OLD = 16;
    static Resources resources = Resources.get(SearchView.class);
    private Gedcom gedcom;
    private Registry registry;
    private ViewManager manager;
    private Results results = new Results();
    private ResultWidget listResults = new ResultWidget();
    private HeadlessLabel viewFactory = new HeadlessLabel(this.listResults.getFont());
    private ChoiceWidget choicePath;
    private ChoiceWidget choiceValue;
    private JCheckBox checkRegExp;
    private JLabel labelCount;
    private LinkedList oldPaths;
    private LinkedList oldValues;
    private AbstractButton bSearch;
    private AbstractButton bStop;
    private static final ImageIcon IMG_START = new ImageIcon(SearchView.class, "Start.gif");
    private static final ImageIcon IMG_STOP = new ImageIcon(SearchView.class, "Stop.gif");

    public SearchView(Gedcom geDcom, Registry reGistry, ViewManager maNager) {
        this.gedcom = geDcom;
        this.registry = reGistry;
        this.manager = maNager;
        this.oldPaths = new LinkedList<String>(Arrays.asList(this.registry.get("old.paths", DEFAULT_PATHS)));
        this.oldValues = new LinkedList<String>(Arrays.asList(this.registry.get("old.values", DEFAULT_VALUES)));
        boolean useRegEx = this.registry.get("regexp", false);
        ActionListener aclick = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SearchView.this.bStop.doClick();
                SearchView.this.bSearch.doClick();
            }
        };
        JLabel labelValue = new JLabel(resources.getString("label.value"));
        this.checkRegExp = new JCheckBox(resources.getString("label.regexp"), useRegEx);
        this.choiceValue = new ChoiceWidget(this.oldValues);
        this.choiceValue.addActionListener(aclick);
        PopupWidget popupPatterns = new PopupWidget("...", null, this.createPatternActions());
        popupPatterns.setMargin(new Insets(0, 0, 0, 0));
        JLabel labelPath = new JLabel(resources.getString("label.path"));
        this.choicePath = new ChoiceWidget(this.oldPaths);
        this.choicePath.addActionListener(aclick);
        PopupWidget popupPaths = new PopupWidget("...", null, this.createPathActions());
        popupPaths.setMargin(new Insets(0, 0, 0, 0));
        this.labelCount = new JLabel();
        JPanel paneCriteria = new JPanel();
        try {
            paneCriteria.setFocusCycleRoot(true);
        }
        catch (Throwable t) {
            // empty catch block
        }
        GridBagHelper gh = new GridBagHelper(paneCriteria);
        gh.add(labelValue, 0, 0, 2, 1, 0, new Insets(0, 0, 0, 8));
        gh.add(this.checkRegExp, 2, 0, 1, 1, 17);
        gh.add(this.labelCount, 3, 0, 1, 1);
        gh.add(popupPatterns, 0, 1, 1, 1);
        gh.add(this.choiceValue, 1, 1, 3, 1, 17, new Insets(3, 3, 3, 3));
        gh.add(labelPath, 0, 2, 4, 1, 17);
        gh.add(popupPaths, 0, 3, 1, 1);
        gh.add(this.choicePath, 1, 3, 3, 1, 17, new Insets(0, 3, 3, 3));
        this.setLayout(new BorderLayout());
        this.add("North", paneCriteria);
        this.add("Center", new JScrollPane(this.listResults));
        this.choiceValue.requestFocusInWindow();
    }

    public void addNotify() {
        this.gedcom.addGedcomListener((GedcomListener)Spin.over(this.results));
        super.addNotify();
        this.choiceValue.requestFocusInWindow();
    }

    public void removeNotify() {
        this.gedcom.removeGedcomListener((GedcomListener)Spin.over(this.results));
        this.registry.put("regexp", this.checkRegExp.isSelected());
        this.registry.put("old.values", this.oldValues);
        this.registry.put("old.paths", this.oldPaths);
        super.removeNotify();
    }

    public void populate(JToolBar bar) {
        ButtonHelper bh = new ButtonHelper().setContainer(bar).setInsets(0);
        ActionSearch search = new ActionSearch();
        ActionStop stop = new ActionStop(search);
        this.bSearch = bh.create(search);
        this.bStop = bh.create(stop);
    }

    private void remember(ChoiceWidget choice, LinkedList old, String value) {
        if (value.trim().length() == 0) {
            return;
        }
        old.remove(value);
        old.addFirst(value);
        if (old.size() > 16) {
            old.removeLast();
        }
        choice.setValues(old);
        choice.setText(value);
    }

    private Matcher getMatcher(String pattern, boolean regex) {
        Matcher result = regex ? new RegExMatcher() : new SimpleMatcher();
        result.init(pattern);
        return result;
    }

    private List createPathActions() {
        ArrayList<ActionPath> result = new ArrayList<ActionPath>();
        for (int i = 0; i < DEFAULT_PATHS.length; ++i) {
            result.add(new ActionPath(DEFAULT_PATHS[i]));
        }
        return result;
    }

    private List createPatternActions() {
        ArrayList<ActionPattern> result = new ArrayList<ActionPattern>();
        int i = 0;
        while (true) {
            String key = "regexp." + i;
            String txt = resources.getString(key + ".txt", false);
            String pat = resources.getString(key + ".pat", false);
            if (txt == null) break;
            if (pat != null) {
                result.add(new ActionPattern(txt, pat));
            }
            ++i;
        }
        return result;
    }

    private class ResultWidget
    extends JList
    implements ListSelectionListener,
    ListCellRenderer,
    ContextProvider {
        private JTextPane text;
        private Color[] bgColors;

        private ResultWidget() {
            super(SearchView.this.results);
            this.text = new JTextPane();
            this.bgColors = new Color[3];
            this.bgColors[0] = this.getSelectionBackground();
            this.bgColors[1] = this.getBackground();
            this.bgColors[2] = new Color(Math.max(this.bgColors[1].getRed() - 16, 0), Math.min(this.bgColors[1].getGreen() + 16, 255), Math.max(this.bgColors[1].getBlue() - 16, 0));
            this.setCellRenderer(this);
            this.addListSelectionListener(this);
            this.text.setOpaque(true);
        }

        public ViewContext getContext() {
            ViewContext result = new ViewContext(SearchView.this.gedcom);
            Object[] selection = this.getSelectedValues();
            for (int i = 0; i < selection.length; ++i) {
                Hit hit = (Hit)selection[i];
                result.addProperty(hit.getProperty());
            }
            return result;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Hit hit = (Hit)value;
            int c = isSelected ? 0 : 1 + (hit.getEntity() & 1);
            this.text.setBackground(this.bgColors[c]);
            this.text.setDocument(hit.getDocument());
            return this.text;
        }

        public void valueChanged(ListSelectionEvent e) {
            int row = SearchView.this.listResults.getSelectedIndex();
            if (row >= 0) {
                WindowManager.broadcast(new ContextSelectionEvent(new ViewContext(SearchView.this.results.getHit(row).getProperty()), this));
            }
        }
    }

    private class Results
    extends AbstractListModel
    implements GedcomListener {
        private List hits = new ArrayList(255);

        private Results() {
        }

        private void clear() {
            if (this.hits.isEmpty()) {
                return;
            }
            int size = this.hits.size();
            this.hits.clear();
            this.fireIntervalRemoved(this, 0, size - 1);
        }

        private void add(List list) {
            if (list.isEmpty()) {
                return;
            }
            int size = this.hits.size();
            this.hits.addAll(list);
            this.fireIntervalAdded(this, size, this.hits.size() - 1);
        }

        public Object getElementAt(int index) {
            return this.hits.get(index);
        }

        public int getSize() {
            return this.hits.size();
        }

        private Hit getHit(int i) {
            return (Hit)this.hits.get(i);
        }

        public void gedcomEntityAdded(Gedcom gedcom, Entity entity) {
        }

        public void gedcomEntityDeleted(Gedcom gedcom, Entity entity) {
        }

        public void gedcomPropertyAdded(Gedcom gedcom, Property property, int pos, Property added) {
        }

        public void gedcomPropertyChanged(Gedcom gedcom, Property prop) {
            for (int i = 0; i < this.hits.size(); ++i) {
                Hit hit = (Hit)this.hits.get(i);
                if (hit.getProperty() != prop) continue;
                this.fireContentsChanged(this, i, i);
            }
        }

        public void gedcomPropertyDeleted(Gedcom gedcom, Property property, int pos, Property removed) {
            int i = 0;
            while (i < this.hits.size()) {
                Hit hit = (Hit)this.hits.get(i);
                if (hit.getProperty() == removed) {
                    this.hits.remove(i);
                    this.fireIntervalRemoved(this, i, i);
                    continue;
                }
                ++i;
            }
        }
    }

    private class ActionStop
    extends Action2 {
        private ActionSearch start;

        private ActionStop(ActionSearch start) {
            this.setImage(IMG_STOP);
            this.setEnabled(false);
            this.start = start;
        }

        protected void execute() {
            this.start.cancel(false);
        }
    }

    private class ActionSearch
    extends Action2 {
        private TagPath tagPath = null;
        private int hitCount = 0;
        private Set entities = new HashSet();
        private List hits = new ArrayList(255);
        private Matcher matcher;

        private ActionSearch() {
            this.setImage(IMG_START);
            this.setAsync(1);
        }

        protected boolean preExecute() {
            SearchView.this.results.clear();
            SearchView.this.bSearch.setEnabled(false);
            SearchView.this.bStop.setEnabled(true);
            String value = SearchView.this.choiceValue.getText();
            String path = SearchView.this.choicePath.getText();
            try {
                this.matcher = SearchView.this.getMatcher(value, SearchView.this.checkRegExp.isSelected());
                this.tagPath = path.length() > 0 ? new TagPath(path) : null;
            }
            catch (IllegalArgumentException e) {
                WindowManager.getInstance(this.getTarget()).openDialog(null, value, 0, e.getMessage(), Action2.okOnly(), (Component)SearchView.this);
                return false;
            }
            SearchView.this.remember(SearchView.this.choiceValue, SearchView.this.oldValues, value);
            SearchView.this.remember(SearchView.this.choicePath, SearchView.this.oldPaths, path);
            return true;
        }

        protected void execute() {
            this.search(SearchView.this.gedcom);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void syncExecute() {
            List list = this.hits;
            synchronized (list) {
                SearchView.this.results.add(this.hits);
                this.hits.clear();
            }
            SearchView.this.labelCount.setText("" + this.hitCount);
        }

        protected void handleThrowable(String phase, Throwable t) {
            WindowManager.getInstance(this.getTarget()).openDialog(null, null, 1, t.getMessage(), Action2.okOnly(), (Component)SearchView.this);
        }

        protected void postExecute(boolean preExecuteResult) {
            SearchView.this.labelCount.setText("" + this.hitCount);
            this.entities.clear();
            this.hits.clear();
            this.hitCount = 0;
            SearchView.this.bSearch.setEnabled(true);
            SearchView.this.bStop.setEnabled(false);
        }

        private void search(Gedcom gedcom) {
            for (int t = 0; t < Gedcom.ENTITIES.length; ++t) {
                Iterator es = gedcom.getEntities(Gedcom.ENTITIES[t]).iterator();
                while (es.hasNext()) {
                    this.search((Entity)es.next());
                }
            }
        }

        private void search(Entity entity) {
            this.search(entity, entity, 0);
        }

        private void search(Entity entity, Property prop, int pathIndex) {
            if (this.getThread().isInterrupted()) {
                return;
            }
            boolean searchThis = true;
            if (this.tagPath != null) {
                if (pathIndex < this.tagPath.length() && !this.tagPath.get(pathIndex).equals(prop.getTag())) {
                    return;
                }
                boolean bl = searchThis = pathIndex >= this.tagPath.length() - 1;
            }
            if (searchThis && !prop.isTransient()) {
                if (entity == prop) {
                    this.search(entity, entity, entity.getId(), true);
                }
                this.search(entity, prop, prop.getDisplayValue(), false);
            }
            int n = prop.getNoOfProperties();
            for (int i = 0; i < n; ++i) {
                this.search(entity, prop.getProperty(i), pathIndex + 1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void search(Entity entity, Property prop, String value, boolean isID) {
            Matcher.Match[] matches = this.matcher.match(value);
            if (matches.length == 0) {
                return;
            }
            if (this.hitCount == 255) {
                throw new IndexOutOfBoundsException(resources.getString("maxhits", Integer.toString(255)));
            }
            ++this.hitCount;
            this.entities.add(entity);
            Hit hit = new Hit(prop, value, matches, this.entities.size(), isID);
            List list = this.hits;
            synchronized (list) {
                this.hits.add(hit);
                if (this.hits.size() == 1) {
                    this.sync();
                }
            }
        }
    }

    private class ActionPattern
    extends Action2 {
        private String pattern;

        private ActionPattern(String txt, String pat) {
            int i = txt.indexOf(32);
            if (i > 0) {
                txt = "<html><b>" + txt.substring(0, i) + "</b>&nbsp;&nbsp;&nbsp;" + txt.substring(i) + "</html>";
            }
            this.setText(txt);
            this.pattern = pat;
        }

        protected void execute() {
            final JTextField field = SearchView.this.choiceValue.getTextEditor();
            int selStart = field.getSelectionStart();
            int selEnd = field.getSelectionEnd();
            if (selEnd <= selStart) {
                selEnd = selStart = field.getCaretPosition();
            }
            String all = field.getText();
            String before = all.substring(0, selStart);
            String selection = selEnd > selStart ? '(' + all.substring(selStart, selEnd) + ')' : "";
            String after = all.substring(selEnd);
            final String result = MessageFormat.format(this.pattern, all, before, selection, after);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    int pos = result.indexOf(35);
                    field.setText(result.substring(0, pos) + result.substring(pos + 1));
                    field.select(0, 0);
                    field.setCaretPosition(pos);
                    SearchView.this.checkRegExp.setSelected(true);
                }
            });
        }
    }

    private class ActionPath
    extends Action2 {
        private TagPath tagPath;

        private ActionPath(String path) {
            this.tagPath = new TagPath(path);
            MetaProperty meta = Grammar.V55.getMeta(this.tagPath);
            this.setText(meta.getName());
            this.setImage(meta.getImage());
        }

        protected void execute() {
            SearchView.this.choicePath.setText(this.tagPath.toString());
        }
    }
}

