/*
 * Decompiled with CFR 0.152.
 */
package genj.search;

import genj.gedcom.Property;
import genj.search.Matcher;
import java.awt.Color;
import javax.swing.ImageIcon;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

class Hit {
    private static final SimpleAttributeSet RED = new SimpleAttributeSet();
    private static final SimpleAttributeSet BOLD = new SimpleAttributeSet();
    private Property property;
    private ImageIcon img;
    private StyledDocument doc;
    private int entity;

    Hit(Property setProp, String value, Matcher.Match[] matches, int setEntity, boolean isID) {
        this.property = setProp;
        this.img = this.property.getImage(false);
        this.entity = setEntity;
        this.doc = new DefaultStyledDocument();
        try {
            int offset = 0;
            String tag = setProp.getTag();
            this.doc.insertString(offset++, " ", null);
            if (!isID) {
                this.doc.insertString(offset, tag, BOLD);
                offset += tag.length();
                this.doc.insertString(offset++, " ", null);
            }
            this.doc.insertString(offset, value, null);
            for (int i = 0; i < matches.length; ++i) {
                Matcher.Match m = matches[i];
                this.doc.setCharacterAttributes(offset + m.pos, m.len, RED, false);
            }
            offset += value.length();
            if (isID) {
                this.doc.insertString(offset++, " ", null);
                this.doc.insertString(offset, tag, BOLD);
            }
            SimpleAttributeSet img = new SimpleAttributeSet();
            StyleConstants.setIcon(img, setProp.getImage(false));
            this.doc.insertString(0, " ", img);
        }
        catch (Throwable t) {
            // empty catch block
        }
    }

    StyledDocument getDocument() {
        return this.doc;
    }

    Property getProperty() {
        return this.property;
    }

    ImageIcon getImage() {
        return this.img;
    }

    int getEntity() {
        return this.entity;
    }

    static {
        StyleConstants.setForeground(RED, Color.RED);
        StyleConstants.setBold(BOLD, true);
    }
}

