/*
 * Decompiled with CFR 0.152.
 */
package genj.report;

import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Property;
import genj.gedcom.UnitOfWork;
import genj.report.Report;
import genj.report.ReportLoader;
import genj.report.ReportView;
import genj.util.Registry;
import genj.util.Resources;
import genj.util.swing.Action2;
import genj.util.swing.ImageIcon;
import genj.view.ActionProvider;
import genj.view.ViewFactory;
import genj.view.ViewManager;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.swing.JComponent;

public class ReportViewFactory
implements ViewFactory,
ActionProvider {
    static final ImageIcon IMG = new ImageIcon(ReportViewFactory.class, "View.gif");
    static /* synthetic */ Class class$genj$report$ReportView;

    public JComponent createView(String title, Gedcom gedcom, Registry registry, ViewManager manager) {
        return new ReportView(title, gedcom, registry, manager);
    }

    public ImageIcon getImage() {
        return IMG;
    }

    public String getTitle(boolean abbreviate) {
        return Resources.get(this).getString("title" + (abbreviate ? ".short" : ""));
    }

    public List createActions(Property[] properties, ViewManager manager) {
        return this.getActions(properties, properties[0].getGedcom(), manager);
    }

    public List createActions(Entity entity, ViewManager manager) {
        return this.getActions(entity, entity.getGedcom(), manager);
    }

    public List createActions(Gedcom gedcom, ViewManager manager) {
        return this.getActions(gedcom, gedcom, manager);
    }

    public List createActions(Property property, ViewManager manager) {
        return this.getActions(property, property.getGedcom(), manager);
    }

    private List getActions(Object context, Gedcom gedcom, ViewManager manager) {
        ArrayList<ActionRun> result = new ArrayList<ActionRun>(10);
        Report[] reports = ReportLoader.getInstance().getReports();
        for (int r = 0; r < reports.length; ++r) {
            Report report = reports[r];
            try {
                String accept = report.accepts(context);
                if (accept == null) continue;
                result.add(new ActionRun(accept, context, gedcom, report, manager));
                continue;
            }
            catch (Throwable t) {
                ReportView.LOG.log(Level.WARNING, "Report " + report.getClass().getName() + " failed in accept()", t);
            }
        }
        return result;
    }

    private class ActionRun
    extends Action2 {
        private Object context;
        private Gedcom gedcom;
        private Report report;
        private ViewManager manager;

        private ActionRun(String txt, Object context, Gedcom gedcom, Report report, ViewManager manager) {
            this.context = context;
            this.gedcom = gedcom;
            this.report = report;
            this.manager = manager;
            this.setImage(report.getImage());
            this.setText(txt);
            this.setAsync(1);
        }

        protected boolean preExecute() {
            if (this.report.usesStandardOut()) {
                Object[] views = this.manager.getViews(class$genj$report$ReportView == null ? (class$genj$report$ReportView = ReportViewFactory.class$("genj.report.ReportView")) : class$genj$report$ReportView, this.gedcom);
                ReportView view = views.length == 0 ? (ReportView)this.manager.openView(class$genj$report$ReportViewFactory == null ? (class$genj$report$ReportViewFactory = ReportViewFactory.class$("genj.report.ReportViewFactory")) : class$genj$report$ReportViewFactory, this.gedcom).getView() : (ReportView)views[0];
                view.run(this.report, this.context);
                return false;
            }
            return true;
        }

        protected void execute() {
            final Report instance = this.report.getInstance(this.getTarget(), null);
            try {
                if (instance.isReadOnly()) {
                    instance.start(this.context);
                } else {
                    this.gedcom.doUnitOfWork(new UnitOfWork(){

                        public void perform(Gedcom gedcom) {
                            try {
                                instance.start(ActionRun.this.context);
                            }
                            catch (Throwable t) {
                                throw new RuntimeException(t);
                            }
                        }
                    });
                }
            }
            catch (Throwable t) {
                Throwable cause = t.getCause();
                if (cause instanceof InterruptedException) {
                    instance.println("***cancelled");
                }
                ReportView.LOG.log(Level.WARNING, "encountered throwable in " + instance.getClass().getName() + ".start()", cause != null ? cause : t);
            }
        }
    }
}

