/*
 * Decompiled with CFR 0.152.
 */
package genj.report;

import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.UnitOfWork;
import genj.io.FileAssociation;
import genj.option.OptionsWidget;
import genj.report.HTMLEditorKit;
import genj.report.Report;
import genj.report.ReportList;
import genj.report.ReportLoader;
import genj.report.ReportSelectionListener;
import genj.util.GridBagHelper;
import genj.util.Registry;
import genj.util.Resources;
import genj.util.swing.Action2;
import genj.util.swing.ButtonHelper;
import genj.util.swing.ImageIcon;
import genj.view.ContextSelectionEvent;
import genj.view.ToolBarSupport;
import genj.view.ViewContext;
import genj.view.ViewManager;
import genj.window.WindowManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;

public class ReportView
extends JPanel
implements ToolBarSupport {
    static Logger LOG = Logger.getLogger("genj.report");
    private static final long FLUSH_WAIT = 200L;
    private static final String EOL = System.getProperty("line.separator");
    private static final ImageIcon imgStart = new ImageIcon(ReportView.class, "Start.gif");
    private static final ImageIcon imgStop = new ImageIcon(ReportView.class, "Stop.gif");
    private static final ImageIcon imgSave = new ImageIcon(ReportView.class, "Save.gif");
    private static final ImageIcon imgReload = new ImageIcon(ReportView.class, "Reload.gif");
    private static final ImageIcon imgGroup = new ImageIcon(ReportView.class, "Group.gif");
    private Gedcom gedcom;
    private JLabel lFile;
    private JLabel lAuthor;
    private JLabel lVersion;
    private JTextPane tpInfo;
    private JEditorPane taOutput;
    private ReportList listOfReports;
    private JTabbedPane tabbedPane;
    private ActionStart actionStart = new ActionStart();
    private ActionStop actionStop = new ActionStop(this.actionStart);
    private OptionsWidget owOptions;
    private HTMLEditorKit editorKit;
    private Registry registry;
    static final Resources RESOURCES = Resources.get(ReportView.class);
    private ViewManager manager;
    private String title;

    public ReportView(String theTitle, Gedcom theGedcom, Registry theRegistry, ViewManager theManager) {
        this.gedcom = theGedcom;
        this.registry = theRegistry;
        this.manager = theManager;
        this.title = theTitle;
        this.setLayout(new BorderLayout());
        this.tabbedPane = new JTabbedPane();
        this.add((Component)this.tabbedPane, "Center");
        Callback callback = new Callback();
        this.tabbedPane.add(RESOURCES.getString("report.reports"), this.createReportList(callback));
        this.tabbedPane.add(RESOURCES.getString("report.options"), this.createReportOptions());
        this.tabbedPane.add(RESOURCES.getString("report.output"), this.createReportOutput(callback));
    }

    public void removeNotify() {
        super.removeNotify();
        ReportLoader.getInstance().saveOptions();
    }

    private JPanel createReportList(Callback callback) {
        JPanel reportPanel = new JPanel();
        reportPanel.setBorder(new EmptyBorder(3, 3, 3, 3));
        GridBagHelper gh = new GridBagHelper(reportPanel);
        this.listOfReports = new ReportList(ReportLoader.getInstance().getReports(), this.registry.get("group", 1), this.registry);
        this.listOfReports.setSelectionListener(callback);
        JScrollPane spList = new JScrollPane(this.listOfReports){

            public Dimension getMinimumSize() {
                return super.getPreferredSize();
            }
        };
        spList.setHorizontalScrollBarPolicy(31);
        gh.add(spList, 1, 0, 1, 5, 34);
        gh.setParameter(1);
        gh.setInsets(new Insets(0, 0, 0, 5));
        this.lFile = new JLabel("");
        this.lFile.setForeground(Color.black);
        gh.add(new JLabel(RESOURCES.getString("report.file")), 2, 0);
        gh.add(this.lFile, 3, 0, 1, 1, 17);
        this.lAuthor = new JLabel("");
        this.lAuthor.setForeground(Color.black);
        gh.add(new JLabel(RESOURCES.getString("report.author")), 2, 1);
        gh.add(this.lAuthor, 3, 1, 1, 1, 17);
        this.lVersion = new JLabel();
        this.lVersion.setForeground(Color.black);
        gh.add(new JLabel(RESOURCES.getString("report.version")), 2, 2);
        gh.add(this.lVersion, 3, 2);
        this.editorKit = new HTMLEditorKit(this.getClass());
        this.tpInfo = new JTextPane();
        this.tpInfo.setEditable(false);
        this.tpInfo.setEditorKit(this.editorKit);
        this.tpInfo.setFont(new JTextField().getFont());
        this.tpInfo.addHyperlinkListener(new FollowHyperlink(this.tpInfo));
        JScrollPane spInfo = new JScrollPane(this.tpInfo);
        gh.add(new JLabel(RESOURCES.getString("report.info")), 2, 3);
        gh.add(spInfo, 2, 4, 2, 1, 4);
        return reportPanel;
    }

    private JComponent createReportOutput(Callback callback) {
        this.taOutput = new JEditorPane();
        this.taOutput.setContentType("text/plain");
        this.taOutput.setFont(new Font("Monospaced", 0, 12));
        this.taOutput.setEditable(false);
        this.taOutput.addHyperlinkListener(new FollowHyperlink(this.taOutput));
        this.taOutput.addMouseMotionListener(callback);
        this.taOutput.addMouseListener(callback);
        return new JScrollPane(this.taOutput);
    }

    private JComponent createReportOptions() {
        this.owOptions = new OptionsWidget(this.getName());
        return this.owOptions;
    }

    public Dimension getPreferredSize() {
        return new Dimension(480, 320);
    }

    ViewManager getViewManager() {
        return this.manager;
    }

    void run(Report report, Object context) {
        if (!this.actionStart.isEnabled()) {
            return;
        }
        this.manager.showView(this);
        this.listOfReports.setSelection(report);
        this.actionStart.setContext(context);
        this.actionStart.trigger();
    }

    private boolean setRunning(boolean on) {
        this.actionStart.setEnabled(!on);
        this.actionStop.setEnabled(on);
        this.taOutput.setCursor(Cursor.getPredefinedCursor(on ? 3 : 0));
        return true;
    }

    public void populate(JToolBar bar) {
        ButtonHelper bh = new ButtonHelper().setContainer(bar).setInsets(0);
        bh.create(this.actionStart);
        bh.create(this.actionStop);
        bh.create(new ActionSave());
        bh.create(new ActionReload());
        bh.create(new ActionGroup());
    }

    private class OutputWriter
    extends Writer {
        private StringBuffer buffer = new StringBuffer(4096);
        private long lastFlush = -1L;

        private OutputWriter() {
        }

        public void close() {
            this.buffer.setLength(0);
        }

        public void flush() {
            if (this.buffer.length() == 0) {
                return;
            }
            ReportView.this.tabbedPane.getModel().setSelectedIndex(2);
            this.lastFlush = System.currentTimeMillis();
            String txt = this.buffer.toString();
            this.buffer.setLength(0);
            Document doc = ReportView.this.taOutput.getDocument();
            try {
                doc.insertString(doc.getLength(), txt, null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
            for (int i = 0; i < len; ++i) {
                char c = cbuf[off + i];
                if (c == '\r') continue;
                this.buffer.append(c);
            }
            if (System.currentTimeMillis() - this.lastFlush > 200L) {
                this.flush();
            }
        }
    }

    private class Callback
    extends MouseAdapter
    implements MouseMotionListener,
    ReportSelectionListener {
        private String id = null;

        private Callback() {
        }

        public void valueChanged(Report report) {
            if (report == null) {
                ReportView.this.lFile.setText("");
                ReportView.this.lAuthor.setText("");
                ReportView.this.lVersion.setText("");
                ReportView.this.tpInfo.setText("");
                ReportView.this.owOptions.setOptions(Collections.EMPTY_LIST);
            } else {
                ReportView.this.editorKit.setFrom(report.getClass());
                ReportView.this.lFile.setText(report.getFilename());
                ReportView.this.lAuthor.setText(report.getAuthor());
                ReportView.this.lVersion.setText(this.getReportVersion(report));
                ReportView.this.tpInfo.setText(report.getInfo().replaceAll("\n", "<br>"));
                ReportView.this.tpInfo.setCaretPosition(0);
                ReportView.this.owOptions.setOptions(report.getOptions());
            }
        }

        private String getReportVersion(Report report) {
            String version = report.getVersion();
            String update = report.getLastUpdate();
            if (update != null) {
                version = version + " - " + RESOURCES.getString("report.updated") + ": " + update;
            }
            return version;
        }

        public void mouseMoved(MouseEvent e) {
            this.id = this.markIDat(e.getPoint());
        }

        public void mouseClicked(MouseEvent e) {
            Entity entity;
            if (this.id != null && (entity = ReportView.this.gedcom.getEntity(this.id)) != null) {
                WindowManager.broadcast(new ContextSelectionEvent(new ViewContext(entity), ReportView.this, e.getClickCount() > 1));
            }
        }

        private String markIDat(Point loc) {
            try {
                int pos = ReportView.this.taOutput.viewToModel(loc);
                if (pos < 0) {
                    return null;
                }
                Document doc = ReportView.this.taOutput.getDocument();
                int i = 0;
                while (true) {
                    if (i == 10) {
                        return null;
                    }
                    if (pos == 0 || !Character.isLetterOrDigit(doc.getText(pos - 1, 1).charAt(0))) break;
                    --pos;
                    ++i;
                }
                int len = 0;
                while (true) {
                    if (len == 10) {
                        return null;
                    }
                    if (pos + len == doc.getLength() || !Character.isLetterOrDigit(doc.getText(pos + len, 1).charAt(0))) break;
                    ++len;
                }
                if (len < 2) {
                    return null;
                }
                String id = doc.getText(pos, len);
                if (ReportView.this.gedcom.getEntity(id) == null) {
                    return null;
                }
                ReportView.this.taOutput.requestFocusInWindow();
                ReportView.this.taOutput.setCaretPosition(pos);
                ReportView.this.taOutput.moveCaretPosition(pos + len);
                return id;
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }

        public void mouseDragged(MouseEvent e) {
        }
    }

    private static class FollowHyperlink
    implements HyperlinkListener {
        private JEditorPane editor;

        private FollowHyperlink(JEditorPane editor) {
            this.editor = editor;
        }

        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                return;
            }
            if (e.getDescription().startsWith("#")) {
                try {
                    this.editor.scrollToReference(e.getDescription().substring(1));
                }
                catch (Throwable throwable) {}
            } else {
                FileAssociation.open(e.getURL(), this.editor);
            }
        }
    }

    private class ActionGroup
    extends Action2 {
        protected ActionGroup() {
            this.setImage(imgGroup);
            this.setTip(RESOURCES, "report.group.tip");
        }

        protected void execute() {
            int viewType = ReportView.this.listOfReports.getViewType();
            if (viewType == 0) {
                ReportView.this.listOfReports.setViewType(1);
            } else {
                ReportView.this.listOfReports.setViewType(0);
            }
            ReportView.this.registry.put("group", ReportView.this.listOfReports.getViewType());
        }
    }

    private class ActionSave
    extends Action2 {
        protected ActionSave() {
            this.setImage(imgSave);
            this.setTip(RESOURCES, "report.save.tip");
        }

        protected void execute() {
            OutputStreamWriter out;
            int rc;
            JFileChooser chooser = new JFileChooser(".");
            chooser.setDialogTitle("Save Output");
            if (0 != chooser.showDialog(ReportView.this, "Save")) {
                return;
            }
            File file = chooser.getSelectedFile();
            if (file == null) {
                return;
            }
            if (file.exists() && (rc = WindowManager.getInstance(this.getTarget()).openDialog(null, ReportView.this.title, 2, "File exists. Overwrite?", Action2.yesNo(), (Component)ReportView.this)) != 0) {
                return;
            }
            try {
                out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charset.forName("UTF8"));
            }
            catch (IOException ex) {
                WindowManager.getInstance(this.getTarget()).openDialog(null, ReportView.this.title, 0, "Error while saving to\n" + file.getAbsolutePath(), Action2.okOnly(), (Component)ReportView.this);
                return;
            }
            try {
                String line;
                Document doc = ReportView.this.taOutput.getDocument();
                BufferedReader in = new BufferedReader(new StringReader(doc.getText(0, doc.getLength())));
                while ((line = in.readLine()) != null) {
                    out.write(line);
                    out.write("\n");
                }
                in.close();
                out.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    private class ActionStart
    extends Action2 {
        private Object context;
        private Report instance;
        private PrintWriter out;

        protected ActionStart() {
            this.setAsync(1);
            this.setImage(imgStart);
            this.setTip(RESOURCES, "report.start.tip");
        }

        protected void setContext(Object context) {
            this.context = context;
        }

        protected boolean preExecute() {
            ReportView.this.owOptions.stopEditing();
            ReportView.this.setRunning(true);
            Report report = ReportView.this.listOfReports.getSelection();
            if (report == null) {
                return false;
            }
            this.out = new PrintWriter(new OutputWriter());
            this.instance = report.getInstance(ReportView.this, this.out);
            Object useContext = this.context;
            this.context = null;
            if (useContext == null) {
                if (this.instance.getStartMethod(ReportView.this.gedcom) != null) {
                    useContext = ReportView.this.gedcom;
                } else {
                    for (int i = 0; i < Gedcom.ENTITIES.length; ++i) {
                        String tag = Gedcom.ENTITIES[i];
                        Entity sample = ReportView.this.gedcom.getFirstEntity(tag);
                        if (this.instance.accepts(sample) == null) continue;
                        String txt = this.instance.accepts(sample.getClass());
                        if (txt == null) {
                            Gedcom.getName(tag);
                        }
                        if ((useContext = this.instance.getEntityFromUser(txt, ReportView.this.gedcom, tag)) != null) break;
                        return false;
                    }
                }
            }
            if (useContext == null || report.accepts(useContext) == null) {
                WindowManager.getInstance(this.getTarget()).openDialog(null, report.getName(), 0, RESOURCES.getString("report.noaccept"), Action2.okOnly(), (Component)ReportView.this);
                return false;
            }
            this.context = useContext;
            ReportView.this.taOutput.setContentType("text/plain");
            ReportView.this.taOutput.setText("");
            return true;
        }

        protected void execute() {
            try {
                if (this.instance.isReadOnly()) {
                    this.instance.start(this.context);
                } else {
                    ReportView.this.gedcom.doUnitOfWork(new UnitOfWork(){

                        public void perform(Gedcom gedcom) {
                            try {
                                ActionStart.this.instance.start(ActionStart.this.context);
                            }
                            catch (Throwable t) {
                                throw new RuntimeException(t);
                            }
                        }
                    });
                }
            }
            catch (Throwable t) {
                Throwable cause = t.getCause();
                if (cause instanceof InterruptedException) {
                    this.instance.println("***cancelled");
                }
                this.instance.println(cause != null ? cause : t);
            }
        }

        protected void postExecute(boolean preExecuteResult) {
            this.context = null;
            ReportView.this.setRunning(false);
            if (this.out != null) {
                this.out.flush();
                this.out.close();
            }
            if (!preExecuteResult) {
                return;
            }
            URL url = null;
            try {
                AbstractDocument doc = (AbstractDocument)ReportView.this.taOutput.getDocument();
                Element p = doc.getParagraphElement(doc.getLength() - 1);
                String line = doc.getText(p.getStartOffset(), p.getEndOffset() - p.getStartOffset());
                url = new URL(line);
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (url != null) {
                try {
                    ReportView.this.taOutput.setPage(url);
                }
                catch (IOException e) {
                    LOG.log(Level.WARNING, "couldn't show html in report output", e);
                }
            }
        }
    }

    private class ActionStop
    extends Action2 {
        private Action2 start;

        protected ActionStop(Action2 start) {
            this.setImage(imgStop);
            this.setTip(RESOURCES, "report.stop.tip");
            this.setEnabled(false);
            this.start = start;
        }

        protected void execute() {
            this.start.cancel(false);
        }
    }

    private class ActionReload
    extends Action2 {
        protected ActionReload() {
            this.setImage(imgReload);
            this.setTip(RESOURCES, "report.reload.tip");
            this.setEnabled(!ReportLoader.getInstance().isReportsInClasspath());
        }

        protected void execute() {
            ReportView.this.tabbedPane.getModel().setSelectedIndex(0);
            ReportView.this.listOfReports.setSelection(null);
            ReportLoader.clear();
            Report[] reports = ReportLoader.getInstance().getReports();
            ReportView.this.listOfReports.setReports(reports);
        }
    }
}

