/*
 * Decompiled with CFR 0.152.
 */
package genj.report;

import genj.report.Report;
import genj.report.ReportView;
import genj.util.EnvironmentChecker;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;

public class ReportLoader {
    private List instances = new ArrayList(10);
    private List reports = new ArrayList(10);
    private List classpath = new ArrayList(10);
    private boolean isReportsInClasspath = false;
    private static ReportLoader singleton;

    static void clear() {
        singleton = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ReportLoader getInstance() {
        if (singleton == null) {
            Class clazz = ReportLoader.class;
            synchronized (clazz) {
                if (singleton == null) {
                    singleton = new ReportLoader();
                }
            }
        }
        return singleton;
    }

    public static File getReportDirectory() {
        return new File(EnvironmentChecker.getProperty((Object)ReportLoader.class, new String[]{"genj.report.dir", "user.dir/report"}, "report", "find report class-files"));
    }

    private ReportLoader() {
        File base = ReportLoader.getReportDirectory();
        ReportView.LOG.info("Reading reports from " + base);
        try {
            this.classpath.add(base.toURL());
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        this.parseDir(base, null);
        URLClassLoader cl = new URLClassLoader(this.classpath.toArray(new URL[this.classpath.size()]), this.getClass().getClassLoader());
        Iterator rs = this.reports.iterator();
        while (rs.hasNext()) {
            String rname = rs.next().toString();
            try {
                Report r = (Report)cl.loadClass(rname).newInstance();
                if (!this.isReportsInClasspath && r.getClass().getClassLoader() != cl) {
                    ReportView.LOG.warning("Reports are in classpath and can't be reloaded");
                    this.isReportsInClasspath = true;
                }
                this.instances.add(r);
            }
            catch (Throwable t) {
                ReportView.LOG.log(Level.WARNING, "Failed to instantiate " + rname, t);
            }
        }
        Collections.sort(this.instances, new Comparator(){

            public int compare(Object a, Object b) {
                try {
                    return ((Report)a).getName().compareTo(((Report)b).getName());
                }
                catch (Throwable t) {
                    return 0;
                }
            }
        });
    }

    private void parseDir(File dir, String pkg) {
        if (!dir.isDirectory()) {
            return;
        }
        String[] files = dir.list();
        for (int i = 0; i < files.length; ++i) {
            File file = new File(dir, files[i]);
            if (file.isDirectory()) {
                this.parseDir(file, (pkg == null ? "" : pkg + ".") + file.getName());
                continue;
            }
            String report = this.isReport(file, pkg);
            if (report != null) {
                this.reports.add(report);
                continue;
            }
            if (!this.isLibrary(file)) continue;
            try {
                ReportView.LOG.info("report library " + file.toURL());
                this.classpath.add(file.toURL());
                continue;
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
    }

    private boolean isLibrary(File file) {
        return !file.isDirectory() && (file.getName().endsWith(".jar") || file.getName().endsWith(".zip"));
    }

    private String isReport(File file, String pkg) {
        if (pkg != null && pkg.startsWith("genj") || file.isDirectory() || !file.getName().endsWith(".class") || !file.getName().startsWith("Report") || file.getName().indexOf("$") > 0) {
            return null;
        }
        String name = file.getName();
        return (pkg == null ? "" : pkg + ".") + name.substring(0, name.length() - ".class".length());
    }

    Report[] getReports() {
        return this.instances.toArray(new Report[this.instances.size()]);
    }

    void saveOptions() {
        Report[] rs = this.getReports();
        for (int r = 0; r < rs.length; ++r) {
            rs[r].saveOptions();
        }
    }

    boolean isReportsInClasspath() {
        return this.isReportsInClasspath;
    }
}

