/*
 * Decompiled with CFR 0.152.
 */
package genj.report;

import genj.chart.Chart;
import genj.common.ContextListWidget;
import genj.common.SelectEntityWidget;
import genj.fo.Document;
import genj.fo.Format;
import genj.fo.FormatOptionsWidget;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.time.PointInTime;
import genj.io.FileAssociation;
import genj.option.Option;
import genj.option.OptionsWidget;
import genj.option.PropertyOption;
import genj.report.Options;
import genj.report.ReportView;
import genj.util.EnvironmentChecker;
import genj.util.Registry;
import genj.util.Resources;
import genj.util.swing.Action2;
import genj.util.swing.ChoiceWidget;
import genj.util.swing.ImageIcon;
import genj.window.WindowManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileFilter;

public abstract class Report
implements Cloneable {
    protected static final Logger LOG = Logger.getLogger("genj.report");
    protected static final javax.swing.ImageIcon IMG_SHELL = new ImageIcon(ReportView.class, "ReportShell.gif");
    protected static final javax.swing.ImageIcon IMG_FO = new ImageIcon(ReportView.class, "ReportFO.gif");
    protected static final javax.swing.ImageIcon IMG_GUI = new ImageIcon(ReportView.class, "ReportGui.gif");
    protected Options OPTIONS = Options.getInstance();
    protected static final int OPTION_YESNO = 0;
    protected static final int OPTION_OKCANCEL = 1;
    protected static final int OPTION_OK = 2;
    private static final Category DEFAULT_CATEGORY = new Category("Other", IMG_SHELL);
    private static final Categories categories = new Categories();
    private static final String[][] OPTION_TEXTS;
    protected static final int ALIGN_LEFT = 0;
    protected static final int ALIGN_CENTER = 1;
    protected static final int ALIGN_RIGHT = 2;
    private static final Registry registry;
    private static final String lang;
    private Resources resources;
    protected PrintWriter out;
    private WindowManager windowManager;
    private Component owner;
    private List options;
    private javax.swing.ImageIcon image;
    private static final Pattern PATTERN_CVS_DATE;

    protected Report() {
    }

    Report getInstance(Component owner, PrintWriter out) {
        try {
            this.getOptions();
            Report result = (Report)this.clone();
            result.windowManager = WindowManager.getInstance(owner);
            result.out = out;
            result.owner = owner;
            return result;
        }
        catch (CloneNotSupportedException e) {
            ReportView.LOG.log(Level.SEVERE, "couldn't clone report", e);
            throw new RuntimeException("getInstance() failed");
        }
    }

    void log(String txt) {
        if (this.out != null) {
            this.out.println(txt);
        }
    }

    void saveOptions() {
        if (this.options == null) {
            return;
        }
        Iterator it = this.options.iterator();
        while (it.hasNext()) {
            ((Option)it.next()).persist(registry);
        }
    }

    List getOptions() {
        if (this.options != null) {
            return this.options;
        }
        this.options = PropertyOption.introspect(this);
        Iterator it = this.options.iterator();
        while (it.hasNext()) {
            String toolTipKey;
            String toolTip;
            PropertyOption option = (PropertyOption)it.next();
            option.restore(registry);
            String oname = this.translate(option.getProperty());
            if (oname.length() > 0) {
                option.setName(oname);
            }
            if ((toolTip = this.translate(toolTipKey = option.getProperty() + ".tip")).length() > 0 && !toolTip.equals(toolTipKey)) {
                option.setToolTip(toolTip);
            }
            option.setCategory(this.getName());
        }
        return this.options;
    }

    protected javax.swing.ImageIcon getImage() {
        if (this.image == null) {
            try {
                String file = this.getTypeName() + ".gif";
                this.image = new ImageIcon(file, this.getClass().getResourceAsStream(file));
            }
            catch (Throwable t) {
                this.image = this.usesStandardOut() ? IMG_SHELL : IMG_GUI;
            }
        }
        return this.image;
    }

    public Category getCategory() {
        String name = this.translate("category");
        if (name.equals("category")) {
            return DEFAULT_CATEGORY;
        }
        Category category = (Category)categories.get(name);
        if (category == null) {
            category = this.createCategory(name);
            categories.add(category);
        }
        return category;
    }

    private Category createCategory(String name) {
        String file;
        InputStream in = Report.class.getResourceAsStream(file = "Category" + name + ".gif");
        if (in == null) {
            in = this.getClass().getResourceAsStream(file);
        }
        javax.swing.ImageIcon image = in != null ? new ImageIcon(file, in) : IMG_SHELL;
        return new Category(name, image);
    }

    public final void flush() {
        if (this.out != null) {
            this.out.flush();
        }
    }

    public final void println() {
        this.println("");
    }

    public final void println(Object o) {
        if (o == null) {
            return;
        }
        if (Thread.interrupted()) {
            throw new RuntimeException(new InterruptedException());
        }
        this.log(o.toString());
    }

    public final void println(Throwable t) {
        CharArrayWriter awriter = new CharArrayWriter(256);
        t.printStackTrace(new PrintWriter(awriter));
        this.log(awriter.toString());
    }

    public File getFileFromUser(String title, String button) {
        return this.getFileFromUser(title, button, false);
    }

    public File getFileFromUser(String title, String button, boolean askForOverwrite) {
        return this.getFileFromUser(title, button, askForOverwrite, null);
    }

    public File getFileFromUser(String title, String button, boolean askForOverwrite, String extension) {
        String key = this.getClass().getName() + ".file";
        String dir = registry.get(key, EnvironmentChecker.getProperty((Object)this, "user.home", ".", "looking for report dir to let the user choose from"));
        JFileChooser chooser = new JFileChooser(dir);
        chooser.setFileSelectionMode(0);
        chooser.setDialogTitle(title);
        if (extension != null) {
            chooser.setFileFilter(new FileExtensionFilter(extension));
        }
        int rc = chooser.showDialog(this.owner, button);
        File result = chooser.getSelectedFile();
        if (rc != 0 || result == null) {
            return null;
        }
        if (result.exists() && askForOverwrite && (rc = this.windowManager.openDialog(null, title, 2, ReportView.RESOURCES.getString("report.file.overwrite"), Action2.yesNo(), this.owner)) != 0) {
            return null;
        }
        registry.put(key, result.getParent().toString());
        return result;
    }

    public final File getDirectoryFromUser(String title, String button) {
        String key = this.getClass().getName() + ".dir";
        String dir = registry.get(key, EnvironmentChecker.getProperty((Object)this, "user.home", ".", "looking for report dir to let the user choose from"));
        JFileChooser chooser = new JFileChooser(dir);
        chooser.setFileSelectionMode(1);
        chooser.setDialogTitle(title);
        int rc = chooser.showDialog(this.owner, button);
        File result = chooser.getSelectedFile();
        if (rc != 0 || result == null) {
            return null;
        }
        registry.put(key, result.toString());
        return result;
    }

    public final void showDocumentToUser(Document doc) {
        String title = "Document " + doc.getTitle();
        Registry foRegistry = new Registry(registry, this.getClass().getName() + ".fo");
        Action[] actions = Action2.okCancel();
        FormatOptionsWidget output = new FormatOptionsWidget(doc, foRegistry);
        output.connect(actions[0]);
        int rc = this.windowManager.openDialog("reportdoc", title, 3, output, actions, this.owner);
        if (rc != 0) {
            return;
        }
        Format formatter = output.getFormat();
        File file = null;
        String progress = null;
        if (formatter.getFileExtension() != null) {
            file = output.getFile();
            if (file == null) {
                return;
            }
            file.getParentFile().mkdirs();
            progress = this.windowManager.openNonModalDialog(null, title, 1, new JLabel("Writing Document to file " + file + " ..."), Action2.okOnly(), this.owner);
        }
        output.remember(foRegistry);
        try {
            formatter.format(doc, file);
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "formatting " + doc + " failed", t);
            this.windowManager.openDialog(null, "Formatting " + doc + " failed", 0, t.getMessage(), Action2.okOnly(), this.owner);
            file = null;
        }
        if (progress != null) {
            this.windowManager.close(progress);
        }
        if (file != null) {
            if (this.owner instanceof ReportView && file.getName().endsWith(".html")) {
                try {
                    this.log("" + file.toURL());
                }
                catch (MalformedURLException e) {}
            } else {
                FileAssociation association = FileAssociation.get(formatter.getFileExtension(), formatter.getFileExtension(), "Open", this.owner);
                if (association != null) {
                    association.execute(file);
                }
            }
        }
    }

    public final void showFileToUser(File file) {
        FileAssociation association = FileAssociation.get(file, "Open", this.owner);
        if (association != null) {
            association.execute(file);
        }
    }

    public final void showChartToUser(Chart chart) {
        this.showComponentToUser(chart);
    }

    public final void showComponentToUser(JComponent component) {
        this.windowManager.openNonModalDialog(this.getClass().getName() + "#component", this.getName(), 1, component, Action2.okOnly(), this.owner);
    }

    public final void showAnnotationsToUser(Gedcom gedcom, String msg, List annotations) {
        JPanel content = new JPanel(new BorderLayout());
        content.add("North", new JLabel(msg));
        content.add("Center", new JScrollPane(new ContextListWidget(gedcom, annotations)));
        this.windowManager.openNonModalDialog(this.getClass().getName() + "#items", this.getName(), 1, content, Action2.okOnly(), this.owner);
    }

    public final void showBrowserToUser(URL url) {
        FileAssociation.open(url, this.owner);
    }

    public final Entity getEntityFromUser(String msg, Gedcom gedcom, String tag) {
        int rc;
        SelectEntityWidget select = new SelectEntityWidget(gedcom, tag, null);
        Entity entity = gedcom.getEntity(registry.get("select." + tag, (String)null));
        if (entity != null) {
            select.setSelection(entity);
        }
        if ((rc = this.windowManager.openDialog("select." + tag, this.getName(), 3, new JComponent[]{new JLabel(msg), select}, Action2.okCancel(), this.owner)) != 0) {
            return null;
        }
        Entity result = select.getSelection();
        if (result == null) {
            return null;
        }
        registry.put("select." + result.getTag(), result.getId());
        return result;
    }

    public final Object getValueFromUser(String msg, Object[] choices, Object selected) {
        ChoiceWidget choice = new ChoiceWidget(choices, selected);
        choice.setEditable(false);
        int rc = this.windowManager.openDialog(null, this.getName(), 3, new JComponent[]{new JLabel(msg), choice}, Action2.okCancel(), this.owner);
        return rc == 0 ? choice.getSelectedItem() : null;
    }

    public final String getValueFromUser(String key, String msg) {
        return this.getValueFromUser(key, msg, new String[0]);
    }

    public final String getValueFromUser(String key, String msg, String[] defaultChoices) {
        String result;
        String[] presets;
        if (key != null && (presets = registry.get(key = this.getClass().getName() + "." + key, (String[])null)) != null) {
            defaultChoices = presets;
        }
        ChoiceWidget choice = new ChoiceWidget(defaultChoices, defaultChoices.length > 0 ? defaultChoices[0] : "");
        int rc = this.windowManager.openDialog(null, this.getName(), 3, new JComponent[]{new JLabel(msg), choice}, Action2.okCancel(), this.owner);
        String string = result = rc == 0 ? choice.getText() : null;
        if (key != null && result != null && result.length() > 0) {
            ArrayList<String> values = new ArrayList<String>(defaultChoices.length + 1);
            values.add(result);
            for (int d = 0; d < defaultChoices.length && d < 20; ++d) {
                if (result.equalsIgnoreCase(defaultChoices[d])) continue;
                values.add(defaultChoices[d]);
            }
            registry.put(key, values);
        }
        return result;
    }

    public final boolean getOptionsFromUser(String title, Object options) {
        List os = PropertyOption.introspect(options);
        String prefix = options.getClass().getName();
        int i = prefix.lastIndexOf(46);
        if (i > 0) {
            prefix = prefix.substring(i + 1);
        }
        if ((i = prefix.lastIndexOf(36)) > 0) {
            prefix = prefix.substring(i + 1);
        }
        Registry r = new Registry(registry, prefix);
        Iterator it = os.iterator();
        while (it.hasNext()) {
            PropertyOption option = (PropertyOption)it.next();
            option.restore(r);
            String oname = this.translate(prefix + "." + option.getName());
            if (oname.length() <= 0) continue;
            option.setName(oname);
        }
        OptionsWidget widget = new OptionsWidget(title, os);
        int rc = this.windowManager.openDialog(null, this.getName(), 3, widget, Action2.okCancel(), this.owner);
        if (rc != 0) {
            return false;
        }
        widget.stopEditing();
        it = os.iterator();
        while (it.hasNext()) {
            ((Option)it.next()).persist(r);
        }
        return true;
    }

    public final boolean getOptionFromUser(String msg, int option) {
        return 0 == this.getOptionFromUser(msg, OPTION_TEXTS[option]);
    }

    private int getOptionFromUser(String msg, String[] actions) {
        Action[] as = new Action[actions.length];
        for (int i = 0; i < as.length; ++i) {
            as[i] = new Action2(actions[i]);
        }
        return this.windowManager.openDialog(null, this.getName(), 3, msg, as, this.owner);
    }

    public final String translate(String key) {
        return this.translate(key, null);
    }

    public final String translate(String key, int value) {
        return this.translate(key, new Integer(value));
    }

    public final String translate(String key, Object value) {
        return this.translate(key, new Object[]{value});
    }

    public final String translate(String key, Object[] values) {
        Resources resources = this.getResources();
        if (resources == null) {
            return key;
        }
        String result = null;
        if (lang != null) {
            result = resources.getString(key + '.' + lang, values, false);
        }
        if (result == null) {
            result = resources.getString(key, values, true);
        }
        return result;
    }

    public String getFilename() {
        return this.getClass().getName().replace('.', '/') + ".java";
    }

    private String getTypeName() {
        String rtype = this.getClass().getName();
        while (rtype.indexOf(46) >= 0) {
            rtype = rtype.substring(rtype.indexOf(46) + 1);
        }
        return rtype;
    }

    protected Resources getResources() {
        if (this.resources == null) {
            this.resources = new Resources(this.getClass().getResourceAsStream(this.getTypeName() + ".properties"));
            try {
                File reports = new File("./src/report");
                String src = this.getClass().getName().replace('.', '/') + ".java";
                InputStream in = reports.exists() && reports.isDirectory() ? new FileInputStream(new File(reports, src)) : this.getClass().getResourceAsStream(src);
                this.resources.load(in);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.resources;
    }

    public final String getIndent(int level, int spacesPerLevel, String prefix) {
        String oneLevel = "";
        while (oneLevel.length() != spacesPerLevel) {
            oneLevel = oneLevel + " ";
        }
        StringBuffer buffer = new StringBuffer(256);
        while (--level > 0) {
            buffer.append(oneLevel);
        }
        if (prefix != null) {
            buffer.append(prefix);
        }
        return buffer.toString();
    }

    public final String getIndent(int level) {
        return this.getIndent(level, this.OPTIONS.getIndentPerLevel(), null);
    }

    public final String align(String txt, int length, int alignment) {
        int i;
        int before;
        int n = txt.length();
        if (n > length) {
            return txt.substring(0, length);
        }
        n = length - n;
        StringBuffer buffer = new StringBuffer(length);
        switch (alignment) {
            default: {
                before = 0;
                break;
            }
            case 1: {
                before = (int)((float)n * 0.5f);
                break;
            }
            case 2: {
                before = n;
            }
        }
        int after = n - before;
        for (i = 0; i < before; ++i) {
            buffer.append(' ');
        }
        buffer.append(txt);
        for (i = 0; i < after; ++i) {
            buffer.append(' ');
        }
        return buffer.toString();
    }

    public String getName() {
        String name = this.translate("name");
        if (name.length() == 0 || name.equals("name")) {
            name = this.getTypeName();
        }
        return name;
    }

    public String getAuthor() {
        return this.translate("author");
    }

    public String getVersion() {
        return this.translate("version");
    }

    public String getLastUpdate() {
        String result = this.translate("updated");
        if ("updated".equals(result)) {
            return null;
        }
        Matcher cvsdata = PATTERN_CVS_DATE.matcher(result);
        if (cvsdata.matches()) {
            try {
                result = new PointInTime(cvsdata.group(1) + cvsdata.group(2) + cvsdata.group(3)) + cvsdata.group(4);
            }
            catch (GedcomException gedcomException) {
                // empty catch block
            }
        }
        return result;
    }

    public String getInfo() {
        return this.translate("info");
    }

    public void start(Object context) throws Throwable {
        try {
            this.getStartMethod(context).invoke((Object)this, context);
        }
        catch (Throwable t) {
            String msg = "can't run report on input";
            if (t instanceof InvocationTargetException) {
                throw ((InvocationTargetException)t).getTargetException();
            }
            throw t;
        }
    }

    public boolean isReadOnly() {
        return true;
    }

    public boolean usesStandardOut() {
        return true;
    }

    public String accepts(Object context) {
        return this.getStartMethod(context) != null ? this.getName() : null;
    }

    Method getStartMethod(Object context) {
        try {
            Method[] methods = this.getClass().getDeclaredMethods();
            for (int m = 0; m < methods.length; ++m) {
                Class<?> param;
                Class<?>[] params;
                if (!methods[m].getName().equals("start") || (params = methods[m].getParameterTypes()).length != 1 || !(param = params[0]).isAssignableFrom(context.getClass())) continue;
                return methods[m];
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    static {
        categories.add(DEFAULT_CATEGORY);
        OPTION_TEXTS = new String[][]{{Action2.TXT_YES, Action2.TXT_NO}, {Action2.TXT_OK, Action2.TXT_CANCEL}, {Action2.TXT_OK}};
        registry = new Registry("genj-reports");
        lang = Locale.getDefault().getLanguage();
        PATTERN_CVS_DATE = Pattern.compile("\\$Date: (\\d\\d\\d\\d)/(\\d\\d)/(\\d\\d)( \\d\\d:\\d\\d:\\d\\d) *\\$");
    }

    private class FileExtensionFilter
    extends FileFilter {
        private String extension;

        public FileExtensionFilter(String extension) {
            this.extension = extension.toLowerCase();
        }

        public boolean accept(File f) {
            if (f == null) {
                return false;
            }
            if (f.isDirectory()) {
                return true;
            }
            return f.getName().toLowerCase().endsWith("." + this.extension);
        }

        public String getDescription() {
            return this.extension.toUpperCase() + " files";
        }
    }

    private static class Categories
    extends TreeMap {
        private Categories() {
        }

        void add(Category category) {
            this.put(category.getName(), category);
        }
    }

    public static class Category {
        private String name;
        private javax.swing.ImageIcon image;

        public Category(String name, javax.swing.ImageIcon image) {
            this.name = name;
            this.image = image;
        }

        public String getName() {
            return this.name;
        }

        public javax.swing.ImageIcon getImage() {
            return this.image;
        }
    }
}

