/*
 * Decompiled with CFR 0.152.
 */
package genj.renderer;

import genj.gedcom.Entity;
import genj.gedcom.IconValueAvailable;
import genj.gedcom.MultiLineProperty;
import genj.gedcom.Property;
import genj.gedcom.PropertyBlob;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyFile;
import genj.gedcom.PropertyMultilineValue;
import genj.gedcom.PropertyPlace;
import genj.gedcom.PropertySex;
import genj.gedcom.PropertyXRef;
import genj.gedcom.TagPath;
import genj.util.Dimension2d;
import genj.util.swing.ImageIcon;
import genj.util.swing.UnitGraphics;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;

public class PropertyRenderer {
    private static final String STARS = "*****";
    private static final int IMAGE_GAP = 4;
    public static final int PREFER_IMAGE = 1;
    public static final int PREFER_TXT = 2;
    public static final int PREFER_RIGHTALIGN = 4;
    public static final int PREFER_SHORT = 8;
    public static final int PREFER_DEFAULT = 10;
    private static final Dimension EMPTY_DIM = new Dimension(0, 0);
    private static final ImageIcon broken = new ImageIcon(PropertyRenderer.class, "Broken.gif");
    public static final PropertyRenderer DEFAULT_RENDERER = new PropertyRenderer();
    private static PropertyRenderer[] renderers = new PropertyRenderer[]{new RenderSecret(), new RenderFile(), new RenderPlace(), new RenderMLE(), new RenderXRef(), new RenderDate(), new RenderSex(), new RenderEntity(), DEFAULT_RENDERER};

    public boolean accepts(TagPath path, Property prop) {
        return true;
    }

    public static PropertyRenderer get(Property prop) {
        return PropertyRenderer.get(null, prop);
    }

    public static PropertyRenderer get(TagPath path, Property prop) {
        for (int i = 0; i < renderers.length; ++i) {
            PropertyRenderer renderer = renderers[i];
            if (!renderer.accepts(path, prop)) continue;
            return renderer;
        }
        return DEFAULT_RENDERER;
    }

    public final Dimension2D getSize(Font font, FontRenderContext context, Property prop, int preference, Point dpi) {
        return this.getSizeImpl(font, context, prop, preference, dpi);
    }

    protected Dimension2D getSizeImpl(Font font, FontRenderContext context, Property prop, int preference, Point dpi) {
        return this.getSizeImpl(font, context, prop, prop.getDisplayValue(), preference, dpi);
    }

    protected Dimension2D getSizeImpl(Font font, FontRenderContext context, Property prop, String txt, int preference, Point dpi) {
        double w = 0.0;
        double h = 0.0;
        if (this.isPreference(preference, 2) && txt.length() > 0) {
            TextLayout layout = new TextLayout(txt, font, context);
            w += (double)layout.getAdvance();
            h = Math.max(h, (double)(layout.getAscent() + layout.getDescent()));
        }
        if (this.isPreference(preference, 1)) {
            ImageIcon img = prop.getImage(false);
            LineMetrics lm = font.getLineMetrics("", context);
            float max = lm.getHeight();
            float scale = 1.0f;
            if (max < (float)img.getIconHeight()) {
                scale = max / (float)img.getIconHeight();
            }
            w += (double)((int)Math.ceil((float)img.getIconWidth() * scale) + 4);
            h = Math.max(h, (double)lm.getHeight());
        }
        return new Dimension2d(w, h);
    }

    public final void render(Graphics2D g, Rectangle bounds, Property prop, int preference, Point dpi) {
        this.renderImpl(g, bounds, prop, preference, dpi);
    }

    protected void renderImpl(Graphics2D g, Rectangle bounds, Property prop, int preference, Point dpi) {
        this.renderImpl(g, bounds, prop, prop.getDisplayValue(), preference, dpi);
    }

    protected void renderImpl(Graphics2D g, Rectangle bounds, Property prop, String txt, int preference, Point dpi) {
        if (this.isPreference(preference, 1)) {
            this.renderImpl(g, bounds, prop.getImage(false), dpi);
        }
        if (this.isPreference(preference, 2)) {
            this.renderImpl(g, bounds, txt, preference);
        }
    }

    protected void renderImpl(Graphics2D g, Rectangle bounds, ImageIcon img, Point dpi) {
        if (bounds.getHeight() == 0.0 || bounds.getWidth() == 0.0) {
            return;
        }
        int w = img.getIconWidth();
        int max = g.getFontMetrics().getHeight();
        AffineTransform at = AffineTransform.getTranslateInstance(bounds.getX(), bounds.getY());
        if (max < img.getIconHeight()) {
            float scale = (float)max / (float)img.getIconHeight();
            at.scale(scale, scale);
            w = (int)Math.ceil((float)w * scale);
        }
        g.drawImage(img.getImage(), at, null);
        bounds.x += w + 4;
        bounds.width -= w + 4;
    }

    protected void renderImpl(Graphics2D g, Rectangle bounds, String txt, int preference) {
        if (txt.length() == 0) {
            return;
        }
        TextLayout layout = new TextLayout(txt, g.getFont(), g.getFontRenderContext());
        double x = bounds.getX();
        if (this.isPreference(preference, 4) && (double)layout.getAdvance() < bounds.getWidth()) {
            x = bounds.getMaxX() - (double)layout.getAdvance();
        }
        layout.draw(g, (float)x, (float)bounds.getY() + layout.getAscent());
    }

    protected boolean isPreference(int preference, int flag) {
        return (preference & flag) != 0;
    }

    protected boolean isNullRenderer() {
        return false;
    }

    static class RenderDate
    extends PropertyRenderer {
        RenderDate() {
        }

        public boolean accepts(TagPath path, Property prop) {
            return prop instanceof PropertyDate;
        }

        public void renderImpl(Graphics2D g, Rectangle bounds, Property prop, int preference, Point dpi) {
            super.renderImpl(g, bounds, prop, preference | 4, dpi);
        }
    }

    static class RenderSecret
    extends PropertyRenderer {
        RenderSecret() {
        }

        public boolean accepts(TagPath path, Property prop) {
            return prop != null && prop.isSecret();
        }

        public Dimension2D getSizeImpl(Font font, FontRenderContext context, Property prop, int preference, Point dpi) {
            return super.getSizeImpl(font, context, prop, PropertyRenderer.STARS, preference, dpi);
        }

        public void renderImpl(Graphics2D g, Rectangle bounds, Property prop, int preference, Point dpi) {
            super.renderImpl(g, bounds, prop, PropertyRenderer.STARS, preference, dpi);
        }
    }

    static class RenderXRef
    extends PropertyRenderer {
        RenderXRef() {
        }

        public boolean accepts(TagPath path, Property prop) {
            return prop instanceof PropertyXRef;
        }
    }

    static class RenderEntity
    extends PropertyRenderer {
        RenderEntity() {
        }

        public boolean accepts(TagPath path, Property prop) {
            return prop instanceof Entity;
        }

        public Dimension2D getSizeImpl(Font font, FontRenderContext context, Property prop, int preference, Point dpi) {
            return super.getSizeImpl(font, context, prop, ((Entity)prop).getId(), preference, dpi);
        }

        public void renderImpl(Graphics2D g, Rectangle bounds, Property prop, int preference, Point dpi) {
            super.renderImpl(g, bounds, prop, ((Entity)prop).getId(), preference | 4, dpi);
        }
    }

    static class RenderFile
    extends PropertyRenderer {
        RenderFile() {
        }

        public boolean accepts(TagPath path, Property prop) {
            return prop instanceof PropertyFile || prop instanceof PropertyBlob || path != null && path.getLast().equals("FILE");
        }

        public Dimension2D getSizeImpl(Font font, FontRenderContext context, Property prop, int preference, Point dpi) {
            ImageIcon img = this.getImage(prop, preference);
            if (img == null) {
                return EMPTY_DIM;
            }
            return img.getSizeInPoints(dpi);
        }

        public void renderImpl(Graphics2D g, Rectangle bounds, Property prop, int preference, Point dpi) {
            ImageIcon img = this.getImage(prop, preference);
            if (img == null) {
                return;
            }
            UnitGraphics ug = new UnitGraphics(g, 1.0, 1.0);
            ug.pushTransformation();
            ug.setColor(Color.black);
            ug.translate(bounds.x, bounds.y);
            Point idpi = img.getResolution();
            double scalex = 1.0;
            double scaley = 1.0;
            if (idpi != null) {
                scalex *= (double)dpi.x / (double)idpi.x;
                scaley *= (double)dpi.y / (double)idpi.y;
            }
            double w = (double)img.getIconWidth() * scalex;
            double h = (double)img.getIconHeight() * scaley;
            if ((double)bounds.width < w || (double)bounds.height < h) {
                double zoom = Math.min((double)bounds.width / w, (double)bounds.height / h);
                scalex *= zoom;
                scaley *= zoom;
            }
            ug.scale(scalex, scaley);
            ug.draw(img, 0.0, 0.0, 0.0, 0.0);
            ug.popTransformation();
        }

        private ImageIcon getImage(Property prop, int preference) {
            ImageIcon result = null;
            if (prop instanceof IconValueAvailable) {
                result = ((IconValueAvailable)((Object)prop)).getValueAsIcon();
            }
            if (result == null && this.isPreference(preference, 1)) {
                return broken;
            }
            return result;
        }

        protected boolean isNullRenderer() {
            return true;
        }
    }

    static class RenderMLE
    extends PropertyRenderer {
        RenderMLE() {
        }

        public boolean accepts(TagPath path, Property prop) {
            return prop instanceof PropertyMultilineValue;
        }

        public Dimension2D getSizeImpl(Font font, FontRenderContext context, Property prop, int preference, Point dpi) {
            if (!(prop instanceof MultiLineProperty)) {
                return super.getSizeImpl(font, context, prop, preference, dpi);
            }
            int lines = 0;
            double width = 0.0;
            double height = 0.0;
            MultiLineProperty.Iterator line = ((MultiLineProperty)((Object)prop)).getLineIterator();
            do {
                ++lines;
                Rectangle2D bounds = font.getStringBounds(line.getValue(), context);
                width = Math.max(width, bounds.getWidth());
                height += bounds.getHeight();
            } while (line.next());
            return new Dimension2d(width, height);
        }

        public void renderImpl(Graphics2D g, Rectangle bounds, Property prop, int preference, Point dpi) {
            if (!(prop instanceof MultiLineProperty)) {
                super.renderImpl(g, bounds, prop, preference, dpi);
                return;
            }
            MultiLineProperty.Iterator line = ((MultiLineProperty)((Object)prop)).getLineIterator();
            Graphics2D graphics = g;
            Rectangle clip = g.getClipBounds();
            Font font = g.getFont();
            FontRenderContext context = graphics.getFontRenderContext();
            float x = (float)bounds.getX();
            float y = (float)bounds.getY();
            do {
                String txt = line.getValue();
                LineMetrics lm = font.getLineMetrics(txt, context);
                graphics.drawString(txt, x, (y += lm.getHeight()) - lm.getDescent());
            } while (!((double)y > bounds.getMaxY()) && line.next());
        }
    }

    static class RenderSex
    extends PropertyRenderer {
        RenderSex() {
        }

        public boolean accepts(TagPath path, Property prop) {
            return prop instanceof PropertySex;
        }

        public Dimension2D getSizeImpl(Font font, FontRenderContext context, Property prop, int preference, Point dpi) {
            return super.getSizeImpl(font, context, prop, 1, dpi);
        }

        public void renderImpl(Graphics2D g, Rectangle bounds, Property prop, int preference, Point dpi) {
            super.renderImpl(g, bounds, prop, 1, dpi);
        }
    }

    static class RenderPlace
    extends PropertyRenderer {
        RenderPlace() {
        }

        public boolean accepts(TagPath path, Property prop) {
            return prop instanceof PropertyPlace;
        }

        public Dimension2D getSizeImpl(Font font, FontRenderContext context, Property prop, int preference, Point dpi) {
            return super.getSizeImpl(font, context, prop, this.getText(prop, preference), preference, dpi);
        }

        public void renderImpl(Graphics2D g, Rectangle bounds, Property prop, int preference, Point dpi) {
            super.renderImpl(g, bounds, prop, this.getText(prop, preference), preference, dpi);
        }

        private String getText(Property prop, int preference) {
            if (!this.isPreference(preference, 8) | !(prop instanceof PropertyPlace)) {
                return prop.getDisplayValue();
            }
            return ((PropertyPlace)prop).getFirstAvailableJurisdiction();
        }
    }
}

