/*
 * Decompiled with CFR 0.152.
 */
package genj.renderer;

import genj.option.CustomOption;
import genj.option.OptionProvider;
import genj.option.PropertyOption;
import genj.util.Registry;
import genj.util.Resources;
import genj.util.swing.Action2;
import genj.util.swing.ScreenResolutionScale;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.Toolkit;
import java.util.List;

public class Options
extends OptionProvider {
    private static final Resources RESOURCES = Resources.get(Options.class);
    private static final Options instance = new Options();
    private Font defaultFont = new Font("SansSerif", 0, 11);
    private Point dpi = new Point(Toolkit.getDefaultToolkit().getScreenResolution(), Toolkit.getDefaultToolkit().getScreenResolution());

    public static Options getInstance() {
        return instance;
    }

    public Font getDefaultFont() {
        return this.defaultFont;
    }

    public void setDefaultFont(Font set) {
        this.defaultFont = set;
    }

    public List getOptions() {
        List result = PropertyOption.introspect(Options.getInstance());
        result.add(new ScreenResolutionOption());
        return result;
    }

    public Point getDPI() {
        return this.dpi;
    }

    private class ScreenResolutionOption
    extends CustomOption {
        private ScreenResolutionOption() {
        }

        public String getName() {
            return RESOURCES.getString("option.screenresolution");
        }

        public String getToolTip() {
            return RESOURCES.getString("option.screenresolution.tip", false);
        }

        public void persist(Registry registry) {
            registry.put("dpi", Options.this.dpi);
        }

        public void restore(Registry registry) {
            Point set = registry.get("dpi", (Point)null);
            if (set != null) {
                Options.this.dpi = set;
            }
        }

        protected void edit() {
            ScreenResolutionScale scale = new ScreenResolutionScale(Options.this.dpi);
            int rc = this.widget.getWindowManager().openDialog(null, this.getName(), 3, scale, Action2.okCancel(), (Component)this.widget);
            if (rc == 0) {
                Options.this.dpi = scale.getDPI();
            }
        }
    }
}

